/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.reservoir;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.BlockEio;
import crazypants.enderio.base.render.IHaveTESR;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumMergingBlockRenderMode;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.machines.machine.reservoir.ReservoirBlockRenderMapper;
import crazypants.enderio.machines.machine.reservoir.ReservoirItemRenderMapper;
import crazypants.enderio.machines.machine.reservoir.ReservoirRenderer;
import crazypants.enderio.machines.machine.reservoir.ReservoirTankWrapper;
import crazypants.enderio.machines.machine.reservoir.TileReservoirBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockReservoirBase
extends BlockEio<TileReservoirBase>
implements IResourceTooltipProvider,
ISmartRenderAwareBlock,
IHaveTESR {
    @SideOnly(value=Side.CLIENT)
    private static ReservoirItemRenderMapper RENDER_MAPPER;

    public static BlockOmniReservoir create_omni(@Nonnull IModObject modObject) {
        BlockOmniReservoir res = new BlockOmniReservoir(modObject);
        res.init();
        return res;
    }

    public static BlockReservoir create(@Nonnull IModObject modObject) {
        BlockReservoir result = new BlockReservoir(modObject);
        result.init();
        return result;
    }

    protected BlockReservoirBase(@Nonnull IModObject modObject) {
        super(modObject, new Material(MapColor.field_151662_n){

            public boolean func_76229_l() {
                return false;
            }
        });
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO)));
        this.setShape(this.mkShape(BlockFaceShape.SOLID));
    }

    @Override
    protected void init() {
        super.init();
        SmartModelAttacher.register((Block)this, EnumMergingBlockRenderMode.RENDER, EnumMergingBlockRenderMode.DEFAULTS, EnumMergingBlockRenderMode.AUTO);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumMergingBlockRenderMode.RENDER});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return state.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO));
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        ReservoirBlockRenderMapper renderMapper = new ReservoirBlockRenderMapper(state, world, pos);
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, renderMapper);
        blockStateWrapper.addCacheKey(renderMapper);
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return ReservoirItemRenderMapper.instance;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    @Override
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!entityPlayer.func_70093_af()) {
            TileReservoirBase tank = (TileReservoirBase)this.getTileEntity((IBlockAccess)world, pos);
            if (tank != null) {
                if (ToolUtil.isToolEquipped(entityPlayer, hand)) {
                    tank.setAutoEject(!tank.isAutoEject());
                    world.func_184138_a(pos, state, state, 3);
                    return true;
                }
                if (tank.getTank().getAvailableSpace() >= 1000 && FluidUtil.fillInternalTankFromPlayerHandItem((World)world, (BlockPos)pos, (EntityPlayer)entityPlayer, (EnumHand)hand, (ITankAccess)tank)) {
                    return true;
                }
                if (!tank.getTank().isFull() && FluidUtil.fillInternalTankFromPlayerHandItem((World)world, (BlockPos)pos, (EntityPlayer)entityPlayer, (EnumHand)hand, (ITankAccess)new ReservoirTankWrapper((ITankAccess)tank, world, pos, this.allowFluidVoiding()))) {
                    return true;
                }
                if (FluidUtil.fillPlayerHandItemFromInternalTank((World)world, (BlockPos)pos, (EntityPlayer)entityPlayer, (EnumHand)hand, (ITankAccess)tank)) {
                    return true;
                }
            }
        } else if (ToolUtil.breakBlockWithTool((Block)this, world, pos, side, entityPlayer, hand, this.permissionNodeWrenching)) {
            return true;
        }
        return false;
    }

    protected abstract boolean allowFluidVoiding();

    public boolean func_149662_c(@Nonnull IBlockState bs) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState bs, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && !world.func_180495_p(pos.func_177972_a(side)).doesSideBlockRendering(world, pos.func_177972_a(side), side.func_176734_d());
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack stack) {
        return this.func_149739_a();
    }

    private static class BlockReservoir
    extends BlockReservoirBase {
        public BlockReservoir(@Nonnull IModObject modObject) {
            super(modObject);
        }

        @Nullable
        public ItemStack getNBTDrop(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune, @Nullable TileReservoirBase te) {
            return new ItemStack((Block)this, 1, this.func_180651_a(state));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void bindTileEntitySpecialRenderer() {
            ClientRegistry.bindTileEntitySpecialRenderer(TileReservoirBase.class, (TileEntitySpecialRenderer)new ReservoirRenderer(this));
        }

        @Override
        protected boolean allowFluidVoiding() {
            return true;
        }
    }

    private static class BlockOmniReservoir
    extends BlockReservoirBase {
        public BlockOmniReservoir(@Nonnull IModObject modObject) {
            super(modObject);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void bindTileEntitySpecialRenderer() {
            ClientRegistry.bindTileEntitySpecialRenderer(TileReservoirBase.TileOmniReservoir.class, (TileEntitySpecialRenderer)new ReservoirRenderer(this));
        }

        @Override
        protected boolean allowFluidVoiding() {
            return false;
        }
    }
}

