/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.zombie;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.machines.machine.generator.zombie.IHasNutrientTank;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketNutrientTank
extends MessageTileEntity<TileEntity> {
    private int amount;

    public PacketNutrientTank() {
    }

    public <T extends TileEntity> PacketNutrientTank(@Nonnull T tile) {
        super(tile);
        this.amount = ((IHasNutrientTank)tile).getNutrientTank().getFluidAmount();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.amount);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.amount = buf.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketNutrientTank, IMessage> {
        public IMessage onMessage(PacketNutrientTank message, MessageContext ctx) {
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            TileEntity tile = message.getTileEntity(player.field_70170_p);
            if (tile instanceof IHasNutrientTank) {
                ((IHasNutrientTank)tile).getNutrientTank().setFluidAmount(message.amount);
            }
            return null;
        }
    }
}

