/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions;

import java.util.HashMap;
import java.util.Map;

public enum Stage {
    WAITING_FOR_SPAWN("wait", 20),
    OPENING_GUI("gui", 20),
    WAITING_FOR_PLAYER_INPUT("input", 20),
    WORKING("working", 2400),
    TIME_IS_UP("timeup", 20),
    TASK_IS_DONE("taskDone", 20),
    DONE("done", 20);

    private static final Map<String, Stage> TYPE_MAP;
    private final String code;
    private final int timeout;

    private Stage(String code, int timeout) {
        this.code = code;
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getCode() {
        return this.code;
    }

    public static Stage getByCode(String code) {
        return TYPE_MAP.get(code);
    }

    static {
        TYPE_MAP = new HashMap<String, Stage>();
        for (Stage type : Stage.values()) {
            TYPE_MAP.put(type.getCode(), type);
        }
    }
}

