/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingWatcher;
import appeng.api.networking.crafting.ICraftingWatcherHost;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.semiblock.IProvidingInventoryListener;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.IItemHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.IGridBlock", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.crafting.ICraftingProvider", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.crafting.ICraftingWatcherHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.storage.IStackWatcherHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.storage.ICellContainer", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.ticking.IGridTickable", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.storage.IMEInventoryHandler", modid="appliedenergistics2", striprefs=true)})
public class SemiBlockRequester
extends SemiBlockLogistics
implements ISpecificRequester,
IProvidingInventoryListener,
IGridHost,
IGridBlock,
ICraftingProvider,
ICraftingWatcherHost,
IStackWatcherHost,
ICellContainer,
IGridTickable,
IMEInventoryHandler<IAEItemStack> {
    public static final String ID = "logistic_frame_requester";
    @GuiSynced
    private boolean aeMode;
    private Object gridNode;
    private Object craftingGrid;
    private Object stackWatcher;
    private Object craftingWatcher;
    private boolean needToCheckForInterface = true;
    private final Set<TileEntity> providingInventories = new HashSet<TileEntity>();

    @Override
    public int getColor() {
        return -16776961;
    }

    @Override
    public int amountRequested(ItemStack stack) {
        IItemHandler inv;
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0 && (inv = IOHelper.getInventoryForTE(this.getTileEntity())) != null) {
            int count = 0;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack s = inv.getStackInSlot(i);
                if (s.func_190926_b() || !this.tryMatch(s, stack)) continue;
                count += s.func_190916_E();
            }
            return Math.max(0, Math.min(stack.func_190916_E(), totalRequestingAmount - (count += this.getIncomingItems(stack))));
        }
        return 0;
    }

    private int getTotalRequestedAmount(ItemStack stack) {
        int requesting = 0;
        for (int i = 0; i < this.getFilters().getSlots(); ++i) {
            ItemStack requestingStack = this.getFilters().getStackInSlot(i);
            if (requestingStack.func_190926_b() || !this.tryMatch(stack, requestingStack)) continue;
            requesting += requestingStack.func_190916_E();
        }
        return requesting;
    }

    @Override
    public int amountRequested(FluidStack stack) {
        int totalRequestingAmount = this.getTotalRequestedAmount(stack);
        if (totalRequestingAmount > 0) {
            Object te = this.getTileEntity();
            int count = 0;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) continue;
                IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
                for (IFluidTankProperties properties : handler.getTankProperties()) {
                    FluidStack contents = properties.getContents();
                    if (contents == null || contents.getFluid() != stack.getFluid()) continue;
                    count += contents.amount;
                }
                if (count > 0) break;
            }
            return Math.max(0, Math.min(stack.amount, totalRequestingAmount - (count += this.getIncomingFluid(stack.getFluid()))));
        }
        return 0;
    }

    private int getTotalRequestedAmount(FluidStack stack) {
        int requesting = 0;
        for (int i = 0; i < 9; ++i) {
            FluidStack requestingStack = this.getTankFilter(i).getFluid();
            if (requestingStack == null || requestingStack.getFluid() != stack.getFluid()) continue;
            requesting += requestingStack.amount;
        }
        return requesting;
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    public GuiHandler.EnumGuiId getGuiID() {
        return GuiHandler.EnumGuiId.LOGISTICS_REQUESTER;
    }

    @Override
    public boolean canFilterStack() {
        return true;
    }

    @Override
    public boolean supportsBlacklisting() {
        return false;
    }

    @Override
    protected boolean shouldSaveNBT() {
        return this.aeMode || super.shouldSaveNBT();
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void update() {
        super.update();
        if (!this.world.field_72995_K && this.needToCheckForInterface) {
            this.needToCheckForInterface = Loader.isModLoaded((String)"appliedenergistics2") && this.aeMode && this.gridNode == null ? this.checkForInterface() : false;
        }
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
        if (guiID == 1) {
            this.needToCheckForInterface = this.aeMode = !this.aeMode;
            if (!this.aeMode && this.gridNode != null) {
                this.disconnectFromInterface();
            }
        }
        super.handleGUIButtonPress(guiID, player);
    }

    public boolean isIntegrationEnabled() {
        return this.aeMode;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("aeMode", this.aeMode);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.aeMode = tag.func_74767_n("aeMode");
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void invalidate() {
        super.invalidate();
        if (this.gridNode != null) {
            this.disconnectFromInterface();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isPlacedOnInterface() {
        return AEApi.instance().definitions().blocks().iface().maybeEntity().map(e -> e.isInstance(this.getTileEntity())).orElse(false);
    }

    @Optional.Method(modid="appliedenergistics2")
    private boolean checkForInterface() {
        Object te;
        if (this.isPlacedOnInterface() && (te = this.getTileEntity()) instanceof IGridHost) {
            if (((IGridHost)te).getGridNode(null) == null) {
                return true;
            }
            if (this.getGridNode(null) == null) {
                return true;
            }
            try {
                AEApi.instance().grid().createGridConnection(((IGridHost)te).getGridNode(null), this.getGridNode(null));
            }
            catch (FailedConnectionException e) {
                Log.error("Couldn't connect to an ME Interface!");
                e.printStackTrace();
            }
        }
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    private void disconnectFromInterface() {
        ((IGridNode)this.gridNode).destroy();
        this.gridNode = null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation arg0) {
        return AECableType.NONE;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation d) {
        if (this.gridNode == null) {
            this.gridNode = AEApi.instance().grid().createGridNode((IGridBlock)this);
        }
        return (IGridNode)this.gridNode;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.drop();
    }

    @Optional.Method(modid="appliedenergistics2")
    public EnumSet<EnumFacing> getConnectableSides() {
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public EnumSet<GridFlags> getFlags() {
        return EnumSet.noneOf(GridFlags.class);
    }

    @Optional.Method(modid="appliedenergistics2")
    public AEColor getGridColor() {
        return AEColor.TRANSPARENT;
    }

    @Optional.Method(modid="appliedenergistics2")
    public double getIdlePowerUsage() {
        return 1.0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.world, this.getPos());
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridHost getMachine() {
        return this;
    }

    @Optional.Method(modid="appliedenergistics2")
    public ItemStack getMachineRepresentation() {
        return new ItemStack(Itemss.LOGISTICS_FRAME_REQUESTER);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void gridChanged() {
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isWorldAccessible() {
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void onGridNotification(GridNotification arg0) {
    }

    @Optional.Method(modid="appliedenergistics2")
    public void setNetworkStatus(IGrid arg0, int arg1) {
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isBusy() {
        return true;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean pushPattern(ICraftingPatternDetails details, InventoryCrafting inventoryCrafting) {
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void provideCrafting(ICraftingProviderHelper helper) {
        this.updateProvidingItems(helper);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void onRequestChange(ICraftingGrid grid, IAEItemStack aeStack) {
        this.craftingGrid = grid;
        int freeSlot = -1;
        for (int i = 0; i < this.getFilters().getSlots(); ++i) {
            ItemStack filterStack = this.getFilters().getStackInSlot(i);
            if (!filterStack.func_190926_b()) {
                if (!aeStack.isSameType(filterStack)) continue;
                filterStack.func_190920_e((int)grid.requesting(aeStack));
                return;
            }
            if (freeSlot != -1) continue;
            freeSlot = i;
        }
        if (freeSlot >= 0) {
            this.getFilters().setStackInSlot(freeSlot, aeStack.createItemStack());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public void updateWatcher(ICraftingWatcher watcher) {
        this.craftingWatcher = watcher;
        this.updateProvidingItems();
    }

    @Optional.Method(modid="appliedenergistics2")
    public void onStackChange(IItemList arg0, IAEStack arg1, IAEStack arg2, IActionSource arg3, IStorageChannel arg4) {
        if (this.craftingGrid != null) {
            ICraftingGrid grid = (ICraftingGrid)this.craftingGrid;
            for (int i = 0; i < this.getFilters().getSlots(); ++i) {
                ItemStack s = this.getFilters().getStackInSlot(i);
                if (s.func_190926_b() || grid.isRequesting((IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)s))) continue;
                this.getFilters().setStackInSlot(i, ItemStack.field_190927_a);
                this.notifyNetworkOfCraftingChange();
            }
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public void updateWatcher(IStackWatcher watcher) {
        this.stackWatcher = watcher;
        this.updateProvidingItems();
    }

    @Optional.Method(modid="appliedenergistics2")
    private void updateProvidingItems() {
        this.updateProvidingItems(null);
    }

    @Optional.Method(modid="appliedenergistics2")
    private void notifyNetworkOfCraftingChange() {
        IGrid grid;
        if (this.gridNode != null && (grid = ((IGridNode)this.gridNode).getGrid()) != null) {
            grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, (IGridNode)this.gridNode));
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private void updateProvidingItems(ICraftingProviderHelper cHelper) {
        IStackWatcher sWatcher = (IStackWatcher)this.stackWatcher;
        ICraftingWatcher cWatcher = (ICraftingWatcher)this.craftingWatcher;
        if (sWatcher != null) {
            sWatcher.reset();
        }
        if (cWatcher != null) {
            cWatcher.reset();
        }
        for (IAEItemStack stack : this.getProvidingItems()) {
            if (sWatcher != null) {
                sWatcher.add((IAEStack)stack);
            }
            if (cWatcher != null) {
                cWatcher.add((IAEStack)stack);
            }
            if (cHelper == null) continue;
            cHelper.setEmitable(stack);
        }
        for (int i = 0; i < this.getFilters().getSlots(); ++i) {
            IAEItemStack stack;
            stack = this.getFilters().getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            IAEItemStack iaeStack = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack);
            if (sWatcher != null) {
                sWatcher.add((IAEStack)iaeStack);
            }
            if (cWatcher != null) {
                cWatcher.add((IAEStack)iaeStack);
            }
            if (cHelper == null) continue;
            cHelper.setEmitable(iaeStack);
        }
    }

    @Override
    public void notify(TileEntity te) {
        if (this.gridNode != null) {
            this.providingInventories.add(te);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private List<IAEItemStack> getProvidingItems() {
        ArrayList<IAEItemStack> stacks = new ArrayList<IAEItemStack>();
        Iterator<TileEntity> iter = this.providingInventories.iterator();
        while (iter.hasNext()) {
            TileEntity te = iter.next();
            if (this.isLogisticsTEInvalid(te)) {
                iter.remove();
                continue;
            }
            IItemHandler inv = IOHelper.getInventoryForTE(te);
            if (inv != null) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    ItemStack stack = inv.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    stacks.add((IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)stack));
                }
                continue;
            }
            iter.remove();
        }
        return stacks;
    }

    private boolean isLogisticsTEInvalid(TileEntity te) {
        if (te.func_145837_r()) {
            return true;
        }
        SemiBlockLogistics sb = SemiBlockManager.getInstance(this.world).getSemiBlock(SemiBlockLogistics.class, this.world, te.func_174877_v());
        return sb == null || !sb.shouldProvideTo(this.getPriority());
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.getGridNode(null);
    }

    @Optional.Method(modid="appliedenergistics2")
    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (channel == AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)) {
            return Collections.singletonList(this);
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    @Optional.Method(modid="appliedenergistics2")
    public void saveChanges(@Nullable ICellInventory<?> cellInventory) {
    }

    @Optional.Method(modid="appliedenergistics2")
    public void blinkCell(int arg0) {
    }

    @Optional.Method(modid="appliedenergistics2")
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(120, 120, false, false);
    }

    @Optional.Method(modid="appliedenergistics2")
    public TickRateModulation tickingRequest(IGridNode arg0, int arg1) {
        this.notifyNetworkOfCraftingChange();
        if (this.gridNode != null) {
            this.getGridNode(null).getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        return TickRateModulation.SAME;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IAEItemStack extractItems(IAEItemStack arg0, Actionable arg1, IActionSource arg2) {
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> arg0) {
        for (IAEItemStack stack : this.getProvidingItems()) {
            stack.setCountRequestable(stack.getStackSize());
            arg0.addRequestable((IAEStack)stack);
        }
        return arg0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IStorageChannel getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IAEItemStack injectItems(IAEItemStack arg0, Actionable arg1, IActionSource arg2) {
        return arg0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean canAccept(IAEItemStack arg0) {
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public AccessRestriction getAccess() {
        return AccessRestriction.READ;
    }

    @Optional.Method(modid="appliedenergistics2")
    public int getSlot() {
        return 0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isPrioritized(IAEItemStack arg0) {
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean validForPass(int arg0) {
        return true;
    }
}

