/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketSetLogisticsFluidFilterStack
extends LocationIntPacket<PacketSetLogisticsFluidFilterStack> {
    private FluidStack settingStack;
    private int settingIndex;

    public PacketSetLogisticsFluidFilterStack() {
    }

    public PacketSetLogisticsFluidFilterStack(SemiBlockLogistics logistics, FluidStack stack, int index) {
        super(logistics.getPos());
        this.settingStack = stack;
        this.settingIndex = index;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.settingStack != null);
        if (this.settingStack != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.settingStack.getFluid().getName());
            buf.writeInt(this.settingStack.amount);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.settingStack.tag);
        }
        buf.writeInt(this.settingIndex);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        if (buf.readBoolean()) {
            this.settingStack = new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt(), ByteBufUtils.readTag((ByteBuf)buf));
        }
        this.settingIndex = buf.readInt();
    }

    @Override
    public void handleClientSide(PacketSetLogisticsFluidFilterStack message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketSetLogisticsFluidFilterStack message, EntityPlayer player) {
        if (message.pos.equals((Object)new BlockPos(0, 0, 0))) {
            if (player.field_71070_bA instanceof ContainerLogistics) {
                ((ContainerLogistics)player.field_71070_bA).logistics.setFilter(message.settingIndex, message.settingStack);
            }
        } else {
            SemiBlockLogistics semiBlock = SemiBlockManager.getInstance(player.field_70170_p).getSemiBlock(SemiBlockLogistics.class, player.field_70170_p, message.pos);
            if (semiBlock != null) {
                semiBlock.setFilter(message.settingIndex, message.settingStack);
            }
        }
    }
}

