/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.IWidgetListener;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiRadioButton
extends Gui
implements IGuiWidget {
    public boolean checked;
    public boolean enabled = true;
    public final int x;
    public final int y;
    public final int color;
    private final int id;
    public final String text;
    private final FontRenderer fontRenderer;
    private List<String> tooltip;
    public List<GuiRadioButton> otherChoices;
    private IWidgetListener listener;
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 10;

    public GuiRadioButton(int id, int x, int y, int color, String text) {
        this.fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        this.tooltip = new ArrayList<String>();
        this.id = id;
        this.x = x;
        this.y = y;
        this.color = color;
        this.text = text;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        this.drawCircle(this.x + 5, this.y + 5, 5, this.enabled ? -6250336 : -6710887);
        this.drawCircle(this.x + 5, this.y + 5, 4, this.enabled ? -14671840 : -5592406);
        if (this.checked) {
            this.drawCircle(this.x + 5, this.y + 5, 1, this.enabled ? -1 : -5592406);
        }
        this.fontRenderer.func_78276_b(I18n.func_135052_a((String)this.text, (Object[])new Object[0]), this.x + 1 + 10, this.y + 5 - this.fontRenderer.field_78288_b / 2, this.enabled ? this.color : -7829368);
    }

    private void drawCircle(int x, int y, int radius, int color) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)f1, (float)f2, (float)f3, (float)f);
        wr.func_181668_a(6, DefaultVertexFormats.field_181705_e);
        int points = 20;
        for (int i = 0; i < points; ++i) {
            double sin = Math.sin((double)i / (double)points * Math.PI * 2.0);
            double cos = Math.cos((double)i / (double)points * Math.PI * 2.0);
            wr.func_181662_b((double)x + sin * (double)radius, (double)y + cos * (double)radius, (double)this.field_73735_i).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, 10 + this.fontRenderer.func_78256_a(this.text), 10);
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int button) {
        if (this.enabled) {
            if (this.otherChoices != null) {
                for (GuiRadioButton radioButton : this.otherChoices) {
                    radioButton.checked = false;
                }
            } else {
                throw new IllegalArgumentException("A radio button needs more than one choice! You need to set the GuiRadioButton#otherChoices field!");
            }
            this.checked = true;
            this.listener.actionPerformed(this);
        }
    }

    @Override
    public void onMouseClickedOutsideBounds(int mouseX, int mouseY, int button) {
    }

    public void setTooltip(String tooltip) {
        this.setTooltip(Collections.singletonList(tooltip));
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> curTooltip, boolean shiftPressed) {
        curTooltip.addAll(this.tooltip);
    }

    @Override
    public boolean onKey(char key, int keyCode) {
        return false;
    }

    @Override
    public void setListener(IWidgetListener gui) {
        this.listener = gui;
    }

    @Override
    public void update() {
    }

    @Override
    public void handleMouseInput() {
    }

    @Override
    public void postRender(int mouseX, int mouseY, float partialTick) {
    }
}

