/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.BakedMinigunWrapper;
import me.desht.pneumaticcraft.client.CamoModel;
import me.desht.pneumaticcraft.client.FluidStateMapper;
import me.desht.pneumaticcraft.client.gui.GuiUtils;
import me.desht.pneumaticcraft.client.gui.IExtraGuiHandling;
import me.desht.pneumaticcraft.client.gui.IGuiDrone;
import me.desht.pneumaticcraft.client.model.pressureglass.PressureGlassBakedModel;
import me.desht.pneumaticcraft.client.particle.AirParticle;
import me.desht.pneumaticcraft.client.render.RenderProgressingLine;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRegulatorTube;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.event.DateEventHandler;
import me.desht.pneumaticcraft.common.fluid.Fluids;
import me.desht.pneumaticcraft.common.item.ItemMicromissiles;
import me.desht.pneumaticcraft.common.item.ItemMinigun;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.item.ItemPneumaticSubtyped;
import me.desht.pneumaticcraft.common.item.ItemProgrammingPuzzle;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketJetBootState;
import me.desht.pneumaticcraft.common.network.PacketMarkPlayerJetbootsActive;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Quaternion;

public class ClientEventHandler {
    private static final double MINIGUN_RADIUS = 1.1;
    private static final double MINIGUN_TEXT_SIZE = 0.55;
    private static final float MAX_SCREEN_ROLL = 25.0f;
    private float currentScreenRoll = 0.0f;
    public static float playerRenderPartialTick;
    private final RenderProgressingLine minigunFire = new RenderProgressingLine().setProgress(1.0f);

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b() instanceof IProgrammable) {
            this.handleProgrammableTooltip(event);
        } else if (event.getItemStack().func_77973_b() instanceof ItemBucket || event.getItemStack().func_77973_b() instanceof UniversalBucket) {
            this.handleFluidContainerTooltip(event);
        }
    }

    private void handleProgrammableTooltip(ItemTooltipEvent event) {
        IProgrammable programmable = (IProgrammable)event.getItemStack().func_77973_b();
        if (programmable.canProgram(event.getItemStack()) && programmable.showProgramTooltip()) {
            boolean hasInvalidPrograms = false;
            ArrayList<String> addedEntries = new ArrayList<String>();
            List<IProgWidget> widgets = TileEntityProgrammer.getProgWidgets(event.getItemStack());
            Map<String, Integer> widgetMap = ClientEventHandler.getPuzzleSummary(widgets);
            for (Map.Entry<String, Integer> entry : widgetMap.entrySet()) {
                IProgWidget widget = ItemProgrammingPuzzle.getWidgetForName(entry.getKey());
                String prefix = "";
                GuiScreen curScreen = Minecraft.func_71410_x().field_71462_r;
                if (curScreen instanceof IGuiDrone && !((IGuiDrone)curScreen).getDrone().isProgramApplicable(widget)) {
                    prefix = TextFormatting.RED + TextFormatting.ITALIC.toString() + "";
                    hasInvalidPrograms = true;
                }
                addedEntries.add(prefix + "\u2022 " + entry.getValue() + "x " + I18n.func_135052_a((String)("programmingPuzzle." + entry.getKey() + ".name"), (Object[])new Object[0]));
            }
            if (hasInvalidPrograms) {
                event.getToolTip().add(TextFormatting.RED + I18n.func_135052_a((String)"gui.tooltip.programmable.invalidPieces", (Object[])new Object[0]));
            }
            Collections.sort(addedEntries);
            event.getToolTip().addAll(addedEntries);
            if (PneumaticCraftRepressurized.proxy.isSneakingInGui() && !widgets.isEmpty()) {
                Map<Integer, Integer> widgetColorMap = TileEntityProgrammer.getPuzzleSummary(widgets);
                event.getToolTip().add(TextFormatting.WHITE + I18n.func_135052_a((String)"gui.tooltip.programmable.requiredPieces", (Object[])new Object[0]));
                for (int color : widgetColorMap.keySet()) {
                    ItemStack stack = ItemProgrammingPuzzle.getStackForColor(color);
                    stack.func_190920_e(widgetColorMap.get(color).intValue());
                    event.getToolTip().add("- " + widgetColorMap.get(color) + " x " + stack.func_82833_r());
                }
            }
        }
    }

    private void handleFluidContainerTooltip(ItemTooltipEvent event) {
        String key;
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)event.getItemStack());
        if (fluidStack != null && fluidStack.amount > 0 && I18n.func_188566_a((String)(key = "gui.tooltip.item." + fluidStack.getFluid().getName() + "_bucket"))) {
            if (((String)event.getToolTip().get(event.getToolTip().size() - 1)).contains("Minecraft Forge")) {
                event.getToolTip().remove(event.getToolTip().size() - 1);
            }
            String prefix = "";
            if (!FluidRegistry.getDefaultFluidName((Fluid)fluidStack.getFluid()).startsWith("pneumaticcraft")) {
                prefix = TextFormatting.DARK_AQUA + "" + TextFormatting.ITALIC + "[" + "PneumaticCraft: Repressurized" + "] ";
            }
            if (PneumaticCraftRepressurized.proxy.isSneakingInGui()) {
                String translatedInfo = TextFormatting.AQUA + I18n.func_135052_a((String)key, (Object[])new Object[0]);
                event.getToolTip().addAll(PneumaticCraftUtils.convertStringIntoList(prefix + translatedInfo, 40));
            } else {
                event.getToolTip().add(TextFormatting.AQUA + I18n.func_135052_a((String)"gui.tooltip.sneakForInfo", (Object[])new Object[0]));
            }
        }
    }

    private static Map<String, Integer> getPuzzleSummary(List<IProgWidget> widgets) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (IProgWidget widget : widgets) {
            if (!map.containsKey(widget.getWidgetString())) {
                map.put(widget.getWidgetString(), 1);
                continue;
            }
            map.put(widget.getWidgetString(), (Integer)map.get(widget.getWidgetString()) + 1);
        }
        return map;
    }

    @SubscribeEvent
    public void onLivingRender(RenderLivingEvent.Pre event) {
        this.setRenderHead(event.getEntity(), false);
    }

    @SubscribeEvent
    public void onLivingRender(RenderLivingEvent.Post event) {
        this.setRenderHead(event.getEntity(), true);
    }

    private void setRenderHead(EntityLivingBase entity, boolean setRender) {
        Render renderer;
        if (entity.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == Itemss.PNEUMATIC_HELMET && (ConfigHandler.client.useHelmetModel || DateEventHandler.isIronManEvent()) && (renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)entity)) instanceof RenderBiped) {
            ModelBiped modelBiped = (ModelBiped)((RenderBiped)renderer).func_177087_b();
            modelBiped.field_78116_c.field_78806_j = setRender;
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && FMLClientHandler.instance().getClient().field_71415_G && PneumaticCraftRepressurized.proxy.getClientPlayer().field_70170_p != null && (ModuleRegulatorTube.inverted || !ModuleRegulatorTube.inLine)) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            ScaledResolution sr = new ScaledResolution(mc);
            FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
            String warning = TextFormatting.RED + I18n.func_135052_a((String)("gui.regulatorTube.hudMessage." + (ModuleRegulatorTube.inverted ? "inverted" : "notInLine")), (Object[])new Object[0]);
            fontRenderer.func_175063_a(warning, (float)(sr.func_78326_a() / 2 - fontRenderer.func_78256_a(warning) / 2), (float)(sr.func_78328_b() / 2 + 30), -1);
        }
    }

    @SubscribeEvent
    public void renderFirstPersonMinigun(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Minecraft mc = Minecraft.func_71410_x();
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof ItemMinigun) {
                ItemStack ammo;
                Minigun minigun = ((ItemMinigun)stack.func_77973_b()).getMinigun(stack, (EntityPlayer)player);
                int w = event.getResolution().func_78326_a();
                int h = event.getResolution().func_78328_b();
                if (minigun.isMinigunActivated() && minigun.getMinigunSpeed() == 0.4) {
                    this.drawBulletTraces2D(minigun.getAmmoColor() | 0x40000000, w, h);
                }
                if (!(ammo = minigun.getAmmoStack()).func_190926_b()) {
                    GuiUtils.drawItemStack(ammo, w / 2 + 16, h / 2 - 7);
                    int remaining = ammo.func_77958_k() - ammo.func_77952_i();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(w / 2 + 32), (float)(h / 2 - 1), (float)0.0f);
                    GlStateManager.func_179139_a((double)0.55, (double)0.55, (double)1.0);
                    String text = remaining + "/" + ammo.func_77958_k();
                    mc.field_71466_p.func_78276_b(text, 1, 0, 0);
                    mc.field_71466_p.func_78276_b(text, -1, 0, 0);
                    mc.field_71466_p.func_78276_b(text, 0, 1, 0);
                    mc.field_71466_p.func_78276_b(text, 0, -1, 0);
                    mc.field_71466_p.func_78276_b(text, 0, 0, minigun.getAmmoColor());
                    GlStateManager.func_179121_F();
                }
                mc.func_110434_K().func_110577_a(Textures.GUI_MINIGUN_CROSSHAIR);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179131_c((float)0.2f, (float)1.0f, (float)0.2f, (float)0.6f);
                Gui.func_146110_a((int)(w / 2 - 7), (int)(h / 2 - 7), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                event.setCanceled(true);
            }
        }
    }

    private void drawBulletTraces2D(int color, int w, int h) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GL11.glEnable((int)2852);
        RenderUtils.glColorHex(color);
        int x = w / 2;
        int y = h / 2;
        Random rand = Minecraft.func_71410_x().field_71441_e.field_73012_v;
        for (int i = 0; i < 5; ++i) {
            int stipple = 0xFFFF & ~(3 << rand.nextInt(16));
            GL11.glLineStipple((int)4, (short)((short)stipple));
            GlStateManager.func_187447_r((int)1);
            GL11.glVertex2f((float)(x + rand.nextInt(12) - 6), (float)(y + rand.nextInt(12) - 6));
            float f = Minecraft.func_71410_x().field_71474_y.field_186715_A == EnumHandSide.RIGHT ? 0.665f : 0.335f;
            GL11.glVertex2f((float)((float)w * f), (float)((float)h * 0.685f));
            GlStateManager.func_187437_J();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2852);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        EntityPlayerSP thisPlayer = Minecraft.func_71410_x().field_71439_g;
        double playerX = thisPlayer.field_70169_q + (thisPlayer.field_70165_t - thisPlayer.field_70169_q) * (double)event.getPartialTicks();
        double playerY = thisPlayer.field_70167_r + (thisPlayer.field_70163_u - thisPlayer.field_70167_r) * (double)event.getPartialTicks();
        double playerZ = thisPlayer.field_70166_s + (thisPlayer.field_70161_v - thisPlayer.field_70166_s) * (double)event.getPartialTicks();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
        for (EntityPlayer player : Minecraft.func_71410_x().field_71441_e.field_73010_i) {
            Minigun minigun;
            ItemStack curItem;
            if (thisPlayer == player && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 || (curItem = player.func_184614_ca()).func_77973_b() != Itemss.MINIGUN || !(minigun = ((ItemMinigun)Itemss.MINIGUN).getMinigun(curItem, player)).isMinigunActivated() || minigun.getMinigunSpeed() != 0.4) continue;
            GlStateManager.func_179094_E();
            playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
            playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
            playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
            GlStateManager.func_179137_b((double)playerX, (double)(playerY + 0.5), (double)playerZ);
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            RenderUtils.glColorHex(0x40000000 | minigun.getAmmoColor());
            Vec3d directionVec = player.func_70040_Z().func_72432_b();
            Vec3d vec = new Vec3d(directionVec.field_72450_a, 0.0, directionVec.field_72449_c).func_72432_b();
            vec.func_178785_b((float)Math.toRadians(-15.0f + (player.field_70759_as - player.field_70761_aq)));
            this.minigunFire.startX = vec.field_72450_a * 1.1;
            this.minigunFire.startY = vec.field_72448_b * 1.1 - player.func_70033_W();
            this.minigunFire.startZ = vec.field_72449_c * 1.1;
            for (int i = 0; i < 5; ++i) {
                this.minigunFire.endX = directionVec.field_72450_a * 20.0 + player.func_70681_au().nextDouble() - 0.5;
                this.minigunFire.endY = directionVec.field_72448_b * 20.0 + (double)player.func_70047_e() + player.func_70681_au().nextDouble() - 0.5;
                this.minigunFire.endZ = directionVec.field_72449_c * 20.0 + player.func_70681_au().nextDouble() - 0.5;
                this.minigunFire.render();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        for (int i = 0; i < 47; ++i) {
            ResourceLocation loc = new ResourceLocation("pneumaticcraft:blocks/pressure_chamber/windows/window_" + (i + 1));
            PressureGlassBakedModel.SPRITES[i] = event.getMap().func_174942_a(loc);
        }
        event.getMap().func_174942_a(AirParticle.AIR_PARTICLE_TEXTURE);
    }

    @SubscribeEvent
    public void onModelBaking(ModelBakeEvent event) {
        for (Block block : Blockss.blocks) {
            if (!(block instanceof BlockPneumaticCraftCamo)) continue;
            Map map = event.getModelManager().func_174954_c().func_178120_a().func_188181_b(block);
            for (Map.Entry entry : map.entrySet()) {
                Object object = event.getModelRegistry().func_82594_a(entry.getValue());
                if (object == null) continue;
                IBakedModel existing = (IBakedModel)object;
                CamoModel customModel = new CamoModel(existing);
                event.getModelRegistry().func_82595_a(entry.getValue(), (Object)customModel);
            }
        }
        ModelResourceLocation mrl = new ModelResourceLocation(Itemss.MINIGUN.getRegistryName(), "inventory");
        Object object = event.getModelRegistry().func_82594_a((Object)mrl);
        if (object != null) {
            event.getModelRegistry().func_82595_a((Object)mrl, (Object)new BakedMinigunWrapper((IBakedModel)object));
        }
    }

    @SubscribeEvent
    public void screenTilt(EntityViewRenderEvent.CameraSetup event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemPneumaticArmor && !player.field_70122_E) {
                float targetRoll;
                CommonHUDHandler handler = CommonHUDHandler.getHandlerForPlayer(player);
                float div = 50.0f;
                if (handler.isJetBootsActive()) {
                    float roll = player.field_70759_as - player.field_70758_at;
                    if ((double)Math.abs(roll) < 1.0E-4) {
                        targetRoll = 0.0f;
                    } else {
                        targetRoll = Math.signum(roll) * 25.0f;
                        div = Math.abs(400.0f / roll);
                    }
                } else {
                    targetRoll = 0.0f;
                }
                this.currentScreenRoll += (targetRoll - this.currentScreenRoll) / div;
                event.setRoll(this.currentScreenRoll);
            } else {
                this.currentScreenRoll = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        this.registerFluidModels();
        for (Block block : Blockss.blocks) {
            Item item = Item.func_150898_a((Block)block);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
        Item assemblyIO = Item.func_150898_a((Block)Blockss.ASSEMBLY_IO_UNIT);
        ModelLoader.setCustomModelResourceLocation((Item)assemblyIO, (int)1, (ModelResourceLocation)new ModelResourceLocation(PneumaticCraftUtils.RL("assembly_io_unit_import"), "inventory"));
        for (Item item : Itemss.items) {
            if (item instanceof ItemPneumaticSubtyped) {
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
                ItemPneumaticSubtyped subtyped = (ItemPneumaticSubtyped)item;
                NonNullList stacks = NonNullList.func_191196_a();
                item.func_150895_a((CreativeTabs)PneumaticCraftRepressurized.tabPneumaticCraft, stacks);
                for (ItemStack stack : stacks) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(PneumaticCraftUtils.RL(subtyped.getSubtypeModelName(stack.func_77960_j())), "inventory"));
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
        ModelLoader.setCustomStateMapper((Block)Blockss.DRONE_REDSTONE_EMITTER, blockIn -> Collections.emptyMap());
        ModelLoader.setCustomStateMapper((Block)Blockss.KEROSENE_LAMP_LIGHT, blockIn -> Collections.emptyMap());
        ModelLoader.setCustomStateMapper((Block)Blockss.PRESSURE_CHAMBER_GLASS, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return PressureGlassBakedModel.BAKED_MODEL;
            }
        });
    }

    private void registerFluidModels() {
        for (IFluidBlock fluidBlock : Fluids.MOD_FLUID_BLOCKS) {
            Item item = Item.func_150898_a((Block)((Block)fluidBlock));
            assert (item != null);
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            FluidStateMapper stateMapper = new FluidStateMapper(fluidBlock.getFluid());
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)stateMapper);
            ModelLoader.setCustomStateMapper((Block)((Block)fluidBlock), (IStateMapper)stateMapper);
        }
    }

    @SubscribeEvent
    public void jetBootsEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityPlayerSP player = FMLClientHandler.instance().getClientPlayerEntity();
            if (player == null || player.field_70170_p == null) {
                return;
            }
            CommonHUDHandler handler = CommonHUDHandler.getHandlerForPlayer((EntityPlayer)player);
            GameSettings settings = FMLClientHandler.instance().getClient().field_71474_y;
            if (!(!handler.isJetBootsActive() || handler.isJetBootsEnabled() && settings.field_74314_A.func_151470_d())) {
                NetworkHandler.sendToServer(new PacketJetBootState(false));
                handler.setJetBootsActive(false, (EntityPlayer)player);
            } else if (!handler.isJetBootsActive() && handler.isJetBootsEnabled() && settings.field_74314_A.func_151470_d()) {
                NetworkHandler.sendToServer(new PacketJetBootState(true));
                handler.setJetBootsActive(true, (EntityPlayer)player);
            }
        }
    }

    @SubscribeEvent
    public void playerPreRotateEvent(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (PacketMarkPlayerJetbootsActive.shouldPlayerBeRotated(player)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            GlStateManager.func_187444_a((Quaternion)ClientEventHandler.makeQuaternion(player));
            GlStateManager.func_179137_b((double)(-event.getX()), (double)(-event.getY()), (double)(-event.getZ()));
            player.field_184618_aE = 0.0f;
            player.field_70721_aZ = 0.0f;
        }
    }

    @SubscribeEvent
    public void playerPostRotateEvent(RenderPlayerEvent.Post event) {
        if (PacketMarkPlayerJetbootsActive.shouldPlayerBeRotated(event.getEntityPlayer())) {
            GlStateManager.func_179121_F();
        }
    }

    private static Quaternion makeQuaternion(EntityPlayer player) {
        Vec3d forward = player.func_70040_Z().func_72432_b();
        double dot = new Vec3d(0.0, 1.0, 0.0).func_72430_b(forward);
        if (Math.abs(dot + 1.0) < 1.0E-6) {
            return new Quaternion(0.0f, 1.0f, 0.0f, (float)Math.PI);
        }
        if (Math.abs(dot - 1.0) < 1.0E-6) {
            return new Quaternion();
        }
        Vec3d rotAxis = new Vec3d(0.0, 1.0, 0.0).func_72431_c(forward).func_72432_b();
        double a2 = Math.acos(dot) * 0.5;
        float s = (float)Math.sin(a2);
        return new Quaternion((float)rotAxis.field_72450_a * s, (float)rotAxis.field_72448_b * s, (float)rotAxis.field_72449_c * s, (float)Math.cos(a2));
    }

    @SubscribeEvent
    public void adjustFOVEvent(FOVUpdateEvent event) {
        CommonHUDHandler handler = CommonHUDHandler.getHandlerForPlayer();
        float modifier = 1.0f;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = event.getEntity().func_184582_a(slot);
            if (!(stack.func_77973_b() instanceof IFOVModifierItem)) continue;
            modifier *= ((IFOVModifierItem)stack.func_77973_b()).getFOVModifier(stack, event.getEntity(), slot);
        }
        event.setNewfov(event.getNewfov() * modifier);
    }

    @SubscribeEvent
    public void fogDensityEvent(EntityViewRenderEvent.FogDensity event) {
        if (event.getState().func_185904_a() == Material.field_151586_h && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            CommonHUDHandler handler = CommonHUDHandler.getHandlerForPlayer();
            if (handler.isArmorReady(EntityEquipmentSlot.HEAD) && handler.isScubaEnabled() && handler.getUpgradeCount(EntityEquipmentSlot.HEAD, IItemRegistry.EnumUpgrade.SCUBA) > 0) {
                event.setDensity(0.02f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void guiContainerForeground(GuiContainerEvent.DrawForeground event) {
        if (Minecraft.func_71410_x().field_71462_r instanceof IExtraGuiHandling) {
            ((IExtraGuiHandling)Minecraft.func_71410_x().field_71462_r).drawExtras(event);
        }
    }

    @SubscribeEvent
    public void renderTooltipEvent(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() instanceof ItemMicromissiles && stack.func_77942_o()) {
            int width = 0;
            FontRenderer fr = event.getFontRenderer();
            int y = event.getY() + fr.field_78288_b * 2 + 5;
            width = Math.max(width, this.renderString(fr, I18n.func_135052_a((String)"gui.micromissile.topSpeed", (Object[])new Object[0]), event.getX(), y));
            width = Math.max(width, this.renderString(fr, I18n.func_135052_a((String)"gui.micromissile.turnSpeed", (Object[])new Object[0]), event.getX(), y + fr.field_78288_b));
            width = Math.max(width, this.renderString(fr, I18n.func_135052_a((String)"gui.micromissile.damage", (Object[])new Object[0]), event.getX(), y + fr.field_78288_b * 2));
            int barX = event.getX() + width + 2;
            int barW = event.getWidth() - width - 10;
            GlStateManager.func_179090_x();
            GlStateManager.func_187441_d((float)10.0f);
            GL11.glEnable((int)2852);
            GL11.glLineStipple((int)1, (short)-258);
            RenderUtils.glColorHex(49152, 255);
            GlStateManager.func_187447_r((int)1);
            GL11.glVertex2i((int)barX, (int)(y + 4));
            GL11.glVertex2i((int)(barX + (int)((float)barW * stack.func_77978_p().func_74760_g("topSpeed"))), (int)(y + 4));
            GlStateManager.func_187437_J();
            GlStateManager.func_187447_r((int)1);
            GL11.glVertex2i((int)barX, (int)(y + 4 + fr.field_78288_b));
            GL11.glVertex2i((int)(barX + (int)((float)barW * stack.func_77978_p().func_74760_g("turnSpeed"))), (int)(y + 4 + fr.field_78288_b));
            GlStateManager.func_187437_J();
            GlStateManager.func_187447_r((int)1);
            GL11.glVertex2i((int)barX, (int)(y + 4 + fr.field_78288_b * 2));
            GL11.glVertex2i((int)(barX + (int)((float)barW * stack.func_77978_p().func_74760_g("damage"))), (int)(y + 4 + fr.field_78288_b * 2));
            GlStateManager.func_187437_J();
            GlStateManager.func_187441_d((float)1.0f);
            GL11.glDisable((int)2852);
        }
    }

    private int renderString(FontRenderer fr, String s, int x, int y) {
        fr.func_175063_a(s, (float)x, (float)y, -5592406);
        return fr.func_78256_a(s);
    }
}

