/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class SlimeLakeGenerator
implements IWorldGenerator {
    private final IBlockState liquid;
    private final IBlockState lakeBottomBlock;
    private final IBlockState[] slimeBlocks;

    public SlimeLakeGenerator(IBlockState liquid, IBlockState lakeBottomBlock, IBlockState ... slimeBlocks) {
        this.liquid = liquid;
        this.lakeBottomBlock = lakeBottomBlock;
        this.slimeBlocks = slimeBlocks;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateLake(random, world, world.func_175645_m(new BlockPos(chunkX * 16, 0, chunkZ * 16)));
    }

    public void generateLake(Random random, World world, BlockPos pos) {
        IBlockState state;
        int yy;
        int xx;
        while (pos.func_177956_o() > 5 && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 4) {
            return;
        }
        pos = pos.func_177982_a(-8, 0, -8);
        pos = pos.func_177979_c(4);
        boolean[] grid = new boolean[2048];
        int spots = random.nextInt(4) + 4;
        for (int i = 0; i < spots; ++i) {
            double xr = random.nextDouble() * 6.0 + 3.0;
            double yr = random.nextDouble() * 4.0 + 2.0;
            double zr = random.nextDouble() * 6.0 + 3.0;
            double xp = random.nextDouble() * (16.0 - xr - 2.0) + 1.0 + xr / 2.0;
            double yp = random.nextDouble() * (8.0 - yr - 4.0) + 2.0 + yr / 2.0;
            double zp = random.nextDouble() * (16.0 - zr - 2.0) + 1.0 + zr / 2.0;
            for (int xx2 = 1; xx2 < 15; ++xx2) {
                for (int zz = 1; zz < 15; ++zz) {
                    for (int yy2 = 1; yy2 < 7; ++yy2) {
                        double xd = ((double)xx2 - xp) / (xr / 2.0);
                        double yd = ((double)yy2 - yp) / (yr / 2.0);
                        double zd = ((double)zz - zp) / (zr / 2.0);
                        double d = xd * xd + yd * yd + zd * zd;
                        if (!(d < 1.0)) continue;
                        grid[(xx2 * 16 + zz) * 8 + yy2] = true;
                    }
                }
            }
        }
        for (xx = 0; xx < 16; ++xx) {
            for (int zz = 0; zz < 16; ++zz) {
                for (yy = 0; yy < 8; ++yy) {
                    boolean check;
                    boolean bl = check = !grid[(xx * 16 + zz) * 8 + yy] && (xx < 15 && grid[((xx + 1) * 16 + zz) * 8 + yy] || xx > 0 && grid[((xx - 1) * 16 + zz) * 8 + yy] || zz < 15 && grid[(xx * 16 + zz + 1) * 8 + yy] || zz > 0 && grid[(xx * 16 + (zz - 1)) * 8 + yy] || yy < 7 && grid[(xx * 16 + zz) * 8 + yy + 1] || yy > 0 && grid[(xx * 16 + zz) * 8 + (yy - 1)]);
                    if (!check) continue;
                    state = world.func_180495_p(pos.func_177982_a(xx, yy, zz));
                    Material m = state.func_177230_c().func_149688_o(state);
                    if (yy < 4 || !m.func_76224_d()) continue;
                    return;
                }
            }
        }
        for (xx = 0; xx < 16; ++xx) {
            for (int zz = 0; zz < 16; ++zz) {
                for (yy = 0; yy < 8; ++yy) {
                    if (!grid[(xx * 16 + zz) * 8 + yy] || world.func_175623_d(pos.func_177982_a(xx, yy, zz).func_177977_b())) continue;
                    world.func_180501_a(pos.func_177982_a(xx, yy, zz), yy >= 4 ? Blocks.field_150350_a.func_176223_P() : this.liquid, 2);
                }
            }
        }
        for (xx = 0; xx < 16; ++xx) {
            for (int zz = 0; zz < 16; ++zz) {
                for (yy = 0; yy < 8; ++yy) {
                    boolean check;
                    boolean bl = check = !grid[(xx * 16 + zz) * 8 + yy] && (xx < 15 && grid[((xx + 1) * 16 + zz) * 8 + yy] || xx > 0 && grid[((xx - 1) * 16 + zz) * 8 + yy] || zz < 15 && grid[(xx * 16 + zz + 1) * 8 + yy] || zz > 0 && grid[(xx * 16 + (zz - 1)) * 8 + yy] || yy < 7 && grid[(xx * 16 + zz) * 8 + yy + 1] || yy > 0 && grid[(xx * 16 + zz) * 8 + (yy - 1)]);
                    if (!check) continue;
                    state = world.func_180495_p(pos.func_177982_a(xx, yy, zz));
                    if (yy >= 4 && random.nextInt(2) == 0 || !state.func_177230_c().func_149688_o(state).func_76220_a()) continue;
                    IBlockState stateDown = world.func_180495_p(pos.func_177982_a(xx, yy + 1, zz));
                    if (stateDown.func_177230_c().func_149688_o(stateDown).func_76224_d()) {
                        if (random.nextInt(10) != 0) continue;
                        world.func_180501_a(pos.func_177982_a(xx, yy, zz), this.lakeBottomBlock, 2);
                        continue;
                    }
                    if (this.slimeBlocks.length <= 0) continue;
                    int r = random.nextInt(this.slimeBlocks.length);
                    world.func_180501_a(pos.func_177982_a(xx, yy, zz), this.slimeBlocks[r], 2);
                }
            }
        }
    }
}

