/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.items;

import codechicken.lib.model.ModelRegistryHelper;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import p455w0rd.danknull.api.IModelHolder;
import p455w0rd.danknull.client.render.DankNullRenderer;
import p455w0rd.danknull.init.ModConfig;
import p455w0rd.danknull.init.ModGlobals;
import p455w0rd.danknull.init.ModGuiHandler;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.util.DankNullUtils;

public class ItemDankNull
extends Item
implements IModelHolder {
    public static String INV_NAME = "danknull-inventory";
    InventoryDankNull inventory = null;

    public ItemDankNull() {
        this.setRegistryName("dank_null");
        this.func_77655_b("dank_null");
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        return new ICapabilityProvider(){

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(this.hasCapability(capability, facing) ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper((IInventory)DankNullUtils.getNewDankNullInventory(stack))) : null);
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int numSlots = DankNullUtils.getSlotCount(stack);
        String numPerSlot = "0";
        if (DankNullUtils.isCreativeDankNull(stack)) {
            numSlots -= 9;
            numPerSlot = I18n.func_74838_a((String)"dn.infinity");
        } else {
            DecimalFormat df = new DecimalFormat("###,###.###", new DecimalFormatSymbols(Locale.US));
            numPerSlot = I18n.func_74838_a((String)"dn.upto") + " " + df.format((Object)DankNullUtils.getDankNullMaxStackSize(stack));
        }
        tooltip.add(I18n.func_74837_a((String)"dn.numslots", (Object[])new Object[]{numSlots}));
        tooltip.add(I18n.func_74837_a((String)"dn.num_per_slot", (Object[])new Object[]{numPerSlot}));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i <= 6; ++i) {
            ResourceLocation regName = new ResourceLocation(this.getRegistryName().func_110624_b(), this.getRegistryName().func_110623_a() + "_" + i);
            ModelResourceLocation location = new ModelResourceLocation(regName, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)location);
            ModelRegistryHelper.register((ModelResourceLocation)location, (IBakedModel)new DankNullRenderer(() -> new ModelResourceLocation(regName, "inventory")));
        }
    }

    public String func_77653_i(ItemStack stack) {
        String name = I18n.func_74838_a((String)(this.func_77657_g(stack) + "_" + this.getDamage(stack) + ".name")).trim();
        if (ModConfig.Options.callItDevNull) {
            name = name.replace("/dank/", "/dev/");
        }
        return name;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (playerIn.func_70093_af() && (ModConfig.Options.ignoreEdgeDetection || this.getBlockUnderPlayer(playerIn) != Blocks.field_150350_a)) {
            ModGuiHandler.launchGui(ModGuiHandler.GUIType.DANKNULL, playerIn, worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i <= 6; ++i) {
                subItems.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public boolean func_77614_k() {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public boolean func_77645_m() {
        return false;
    }

    private IBlockState getBlockUnderPlayer(EntityPlayer player) {
        int blockX = MathHelper.func_76128_c((double)player.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)(player.func_174813_aQ().field_72338_b - 0.5));
        int blockZ = MathHelper.func_76128_c((double)player.field_70161_v);
        return player.func_130014_f_().func_180495_p(new BlockPos(blockX, blockY, blockZ));
    }

    public RayTraceResult rayTrace(EntityPlayer player, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return player.field_70170_p.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos posIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int amountToKeep;
        int count;
        ItemStack stack;
        InventoryDankNull inventory;
        ItemStack selectedStack;
        Block selectedBlock;
        if (!world.field_72995_K) {
            // empty if block
        }
        boolean isSelectedStackABlock = (selectedBlock = Block.func_149634_a((Item)(selectedStack = DankNullUtils.getSelectedStack(inventory = new InventoryDankNull(stack = player.func_184586_b(hand)))).func_77973_b())) != null && selectedBlock != Blocks.field_150350_a;
        Block blockUnderPlayer = this.getBlockUnderPlayer(player).func_177230_c();
        if (player.func_70093_af() && (ModConfig.Options.ignoreEdgeDetection || blockUnderPlayer != Blocks.field_150350_a && isSelectedStackABlock && blockUnderPlayer != selectedBlock)) {
            ModGuiHandler.launchGui(ModGuiHandler.GUIType.DANKNULL, player, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return EnumActionResult.SUCCESS;
        }
        DankNullUtils.SlotExtractionMode placementMode = DankNullUtils.getPlacementModeForStack(stack, selectedStack);
        if (placementMode != null && placementMode != DankNullUtils.SlotExtractionMode.KEEP_NONE && (count = DankNullUtils.getSelectedStackSize(inventory)) <= (amountToKeep = placementMode.getNumberToKeep()) && !player.field_71075_bZ.field_75098_d) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(posIn);
        Block block = state.func_177230_c();
        BlockPos pos = posIn;
        if (selectedStack.func_190926_b() || selectedStack.func_77973_b() instanceof ItemBlock || !(selectedStack.func_77973_b() instanceof ItemBlockSpecial)) {
            // empty if block
        }
        if (!block.func_176200_f((IBlockAccess)world, posIn) && block == Blocks.field_150431_aC) {
            facing = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)world, posIn) && selectedBlock != null && !selectedBlock.func_149730_j(selectedBlock.func_176203_a(selectedStack.func_77960_j()))) {
            pos = pos.func_177972_a(facing);
        }
        if (DankNullUtils.getSelectedStackSize(inventory) > 0 && player.func_175151_a(posIn, facing, stack)) {
            int meta = selectedStack.func_77960_j();
            if (selectedBlock instanceof BlockStairs || selectedBlock instanceof BlockBanner) {
                IBlockState newState = selectedBlock.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)player);
                EnumActionResult result = DankNullUtils.placeBlock(newState, world, pos);
                if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityBanner) {
                    if (facing == EnumFacing.UP) {
                        int i = MathHelper.func_76128_c((double)((double)((player.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
                        world.func_180501_a(pos, Blocks.field_180393_cK.func_176223_P().func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf(i)), 3);
                    } else {
                        world.func_180501_a(pos, Blocks.field_180394_cL.func_176223_P().func_177226_a((IProperty)BlockWallSign.field_176412_a, (Comparable)facing), 3);
                    }
                    ((TileEntityBanner)world.func_175625_s(pos)).func_175112_a(selectedStack, false);
                }
                if (result != EnumActionResult.FAIL) {
                    SoundType soundType = block.getSoundType(newState, world, pos, (Entity)player);
                    world.func_184133_a((EntityPlayer)null, player.func_180425_c(), soundType.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 2.0f));
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    DankNullUtils.decrSelectedStackSize(inventory, 1);
                }
                return EnumActionResult.SUCCESS;
            }
            if (!(selectedStack.func_77973_b() instanceof ItemBucket || selectedStack.func_77973_b() instanceof UniversalBucket || selectedStack.func_77973_b() instanceof ItemSnowball || selectedStack.func_77973_b() instanceof ItemEnderPearl || selectedStack.func_77973_b() instanceof ItemEgg)) {
                EnumActionResult result = this.placeItemIntoWorld(selectedStack.func_77946_l(), player, world, pos, facing, hitX, hitY, hitZ, hand);
                if (result == EnumActionResult.SUCCESS && !player.field_71075_bZ.field_75098_d && !DankNullUtils.isCreativeDankNull(stack)) {
                    DankNullUtils.decrSelectedStackSize(inventory, 1);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult placeItemIntoWorld(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        return this.placeItemIntoWorld(itemstack, player, world, pos, facing, hitX, hitY, hitZ, hand, false);
    }

    public EnumActionResult placeItemIntoWorld(@Nonnull ItemStack itemstack, @Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand, boolean skipSlab) {
        if (itemstack.func_77973_b() instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
            ItemSlab slab = null;
            if (itemstack.func_77973_b() instanceof ItemSlab && !skipSlab) {
                slab = (ItemSlab)itemstack.func_77973_b();
            }
            if (slab != null) {
                return this.placeSlab(player, world, pos.func_177972_a(facing.func_176734_d()), hand, facing, hitX, hitY, hitZ, itemstack, slab);
            }
            if (!block.func_176200_f((IBlockAccess)world, pos)) {
                pos = pos.func_177972_a(facing);
            }
            if (!itemstack.func_190926_b() && player.func_175151_a(pos, facing, itemstack) && world.func_190527_a(block, pos, false, facing, (Entity)null)) {
                IBlockState iblockstate1 = block.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, itemstack.func_77952_i(), (EntityLivingBase)player, hand);
                if (this.placeBlockAt(itemstack, player, world, pos, facing, hitX, hitY, hitZ, iblockstate1, block)) {
                    iblockstate1 = world.func_180495_p(pos);
                    SoundType soundtype = iblockstate1.func_177230_c().getSoundType(iblockstate1, world, pos, (Entity)player);
                    world.func_184133_a((EntityPlayer)null, player.func_180425_c(), soundtype.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 2.0f));
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState, Block block) {
        ItemStack tmpStack = stack.func_77946_l();
        tmpStack.func_190920_e(1);
        if (tmpStack.func_77973_b() instanceof ItemBlock) {
            ItemBlock blockItem = (ItemBlock)tmpStack.func_77973_b();
            blockItem.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
            return true;
        }
        world.func_180501_a(pos, newState, 3);
        world.func_175685_c(pos, block, true);
        if (player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, tmpStack);
        }
        return true;
    }

    public EnumActionResult placeSlab(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ, ItemStack itemstack, ItemSlab slab) {
        BlockSlab singleSlab = (BlockSlab)ReflectionHelper.getPrivateValue(ItemSlab.class, (Object)slab, (String[])new String[]{"singleSlab"});
        if (!itemstack.func_190926_b() && player.func_175151_a(pos, facing, itemstack)) {
            Comparable comparable = singleSlab.func_185674_a(itemstack);
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            ItemStack blockAsStack = new ItemStack(Item.func_150898_a((Block)iblockstate.func_177230_c()), 1, iblockstate.func_177230_c().func_176201_c(iblockstate));
            if (iblockstate.func_177230_c() == singleSlab && ((BlockSlab)iblockstate.func_177230_c()).func_185674_a(blockAsStack) == comparable) {
                IProperty iproperty = singleSlab.func_176551_l();
                Comparable comparable1 = iblockstate.func_177229_b(iproperty);
                BlockSlab.EnumBlockHalf blockslab$enumblockhalf = (BlockSlab.EnumBlockHalf)iblockstate.func_177229_b((IProperty)BlockSlab.field_176554_a);
                if ((facing == EnumFacing.UP && blockslab$enumblockhalf == BlockSlab.EnumBlockHalf.BOTTOM || facing == EnumFacing.DOWN && blockslab$enumblockhalf == BlockSlab.EnumBlockHalf.TOP) && comparable1 == comparable) {
                    IBlockState iblockstate1 = this.makeState(iproperty, comparable1, slab);
                    AxisAlignedBB axisalignedbb = iblockstate1.func_185890_d((IBlockAccess)worldIn, pos);
                    if (axisalignedbb != Block.field_185506_k && worldIn.func_72855_b(axisalignedbb.func_186670_a(pos)) && worldIn.func_180501_a(pos, iblockstate1, 3)) {
                        SoundType soundtype = singleSlab.getSoundType(iblockstate1, worldIn, pos, (Entity)player);
                        worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                        if (player instanceof EntityPlayerMP) {
                            CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, itemstack);
                        }
                    }
                    return this.tryPlace(player, itemstack, worldIn, pos, comparable, slab) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
                }
                return this.tryPlace(player, itemstack, worldIn, pos.func_177972_a(facing), comparable, slab) ? EnumActionResult.SUCCESS : this.placeItemIntoWorld(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, hand, true);
            }
            return this.tryPlace(player, itemstack, worldIn, pos.func_177972_a(facing), comparable, slab) ? EnumActionResult.SUCCESS : this.placeItemIntoWorld(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, hand, true);
        }
        return EnumActionResult.FAIL;
    }

    private boolean tryPlace(EntityPlayer player, ItemStack stack, World worldIn, BlockPos pos, Object itemSlabType, ItemSlab slab) {
        BlockSlab singleSlab = (BlockSlab)ReflectionHelper.getPrivateValue(ItemSlab.class, (Object)slab, (String[])new String[]{"singleSlab"});
        BlockSlab doubleSlab = (BlockSlab)ReflectionHelper.getPrivateValue(ItemSlab.class, (Object)slab, (String[])new String[]{"doubleSlab"});
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() == singleSlab) {
            Comparable comparable = singleSlab.func_185674_a(stack);
            ItemStack blockAsStack = new ItemStack(Item.func_150898_a((Block)iblockstate.func_177230_c()), 1, iblockstate.func_177230_c().func_176201_c(iblockstate));
            if (comparable == itemSlabType && ((BlockSlab)iblockstate.func_177230_c()).func_185674_a(blockAsStack) == comparable) {
                IBlockState iblockstate1 = this.makeState(singleSlab.func_176551_l(), comparable, slab);
                AxisAlignedBB axisalignedbb = iblockstate1.func_185890_d((IBlockAccess)worldIn, pos);
                if (axisalignedbb != Block.field_185506_k && worldIn.func_72855_b(axisalignedbb.func_186670_a(pos)) && worldIn.func_180501_a(pos, iblockstate1, 3)) {
                    SoundType soundtype = doubleSlab.getSoundType(iblockstate1, worldIn, pos, (Entity)player);
                    worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                }
                return true;
            }
        }
        return false;
    }

    protected <T extends Comparable<T>> IBlockState makeState(IProperty<T> p_185055_1_, Comparable<?> p_185055_2_, ItemSlab slab) {
        BlockSlab doubleSlab = (BlockSlab)ReflectionHelper.getPrivateValue(ItemSlab.class, (Object)slab, (String[])new String[]{"doubleSlab"});
        return doubleSlab.func_176223_P().func_177226_a(p_185055_1_, p_185055_2_);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ModGlobals.Rarities.getRarityFromMeta(stack.func_77952_i());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.func_77969_a(newStack) || slotChanged;
    }
}

