/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.blocks;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.item.IItemRenderer;
import com.google.common.collect.Maps;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BuiltInModel;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.danknull.blocks.BlockContainerBase;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.client.render.DankTextures;
import p455w0rd.danknull.client.render.TESRDankNullDock;
import p455w0rd.danknull.init.ModItems;
import p455w0rd.danknull.init.ModNetworking;
import p455w0rd.danknull.network.PacketSetDankNullInDock;
import p455w0rd.danknull.util.DankNullUtils;

public class BlockDankNullDock
extends BlockContainerBase {
    public static final String NAME = "danknull_dock";

    public BlockDankNullDock() {
        super(Material.field_151573_f, NAME, 10.0f, 6000000.0f);
        GameRegistry.registerTileEntity(TileDankNullDock.class, (ResourceLocation)new ResourceLocation("danknull", NAME));
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.isEmpty(worldIn, pos) ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0) : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isEmpty(source, pos) ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0) : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileDankNullDock();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelRegistryHelper.registerItemRenderer((Item)Item.func_150898_a((Block)this), (IItemRenderer)new TESRDankNullDock());
        BlockDankNullDock.setParticleTexture((Block)this);
        ClientRegistry.bindTileEntitySpecialRenderer(TileDankNullDock.class, (TileEntitySpecialRenderer)new TESRDankNullDock());
    }

    @SideOnly(value=Side.CLIENT)
    public static void setParticleTexture(Block block) {
        ModelResourceLocation modelLoc = new ModelResourceLocation(block.getRegistryName(), "particle");
        ModelRegistryHelper.register((ModelResourceLocation)modelLoc, (IBakedModel)new BuiltInModel(ItemCameraTransforms.field_178357_a, ItemOverrideList.field_188022_a){

            public TextureAtlasSprite func_177554_e() {
                return DankTextures.DANKNULL_DOCK_SPRITE;
            }
        });
        ModelLoader.setCustomStateMapper((Block)block, blockIn -> Maps.toMap((Iterable)blockIn.func_176194_O().func_177619_a(), input -> modelLoc));
    }

    private TileDankNullDock getTE(IBlockAccess worldIn, BlockPos pos) {
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileDankNullDock) {
            return (TileDankNullDock)worldIn.func_175625_s(pos);
        }
        return null;
    }

    private boolean isEmpty(IBlockAccess world, BlockPos pos) {
        return this.getTE(world, pos) != null && this.getTE(world, pos).getDankNull().func_190926_b();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        if (player.func_184102_h().func_175579_a(world, pos, player)) {
            return false;
        }
        TileDankNullDock dankDock = this.getTE((IBlockAccess)world, pos);
        if (dankDock != null) {
            if (!player.func_184586_b(hand).func_190926_b() && dankDock.getDankNull().func_190926_b() && player.func_184586_b(hand).func_77973_b() == ModItems.DANK_NULL) {
                ItemStack dankNull = player.func_184586_b(hand);
                dankDock.setInventory(DankNullUtils.getNewDankNullInventory(dankNull));
                player.func_184611_a(hand, ItemStack.field_190927_a);
                ModNetworking.getInstance().sendToDimension((IMessage)new PacketSetDankNullInDock(dankDock, dankNull), world.field_73011_w.getDimension());
                return true;
            }
            if (player.func_70093_af() || hand != EnumHand.MAIN_HAND || !dankDock.getDankNull().func_190926_b()) {
                // empty if block
            }
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getItemBlockWithNBT(world.func_175625_s(pos));
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        stack = this.getItemBlockWithNBT(te);
        BlockDankNullDock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    private ItemStack getItemBlockWithNBT(@Nullable TileEntity te) {
        ItemStack stack = new ItemStack((Block)this);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (te != null) {
            te.func_189515_b(nbttagcompound);
            stack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        }
        return stack;
    }
}

