/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import java.util.List;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TabbedPanel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.api.code.Function;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.logic.editors.ParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import mcjty.rftoolscontrol.logic.registry.Functions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public abstract class AbstractParameterEditor
implements ParameterEditor {
    public static final String PAGE_CONSTANT = "Constant";
    public static final String PAGE_VARIABLE = "Variable";
    public static final String PAGE_FUNCTION = "Function";
    private TextField variableIndex;
    private TabbedPanel tabbedPanel;
    private Panel buttonPanel;
    private ChoiceLabel functionLabel;
    private ToggleButton variableButton;
    private ToggleButton functionButton;
    private Runnable onClose;
    private Window parentWindow;

    @Override
    public void constantOnly() {
        this.variableButton.setEnabled(false);
        this.functionButton.setEnabled(false);
    }

    @Override
    public void setOnClose(Runnable onClose) {
        this.onClose = onClose;
    }

    @Override
    public void initialFocus(Window window) {
        this.parentWindow = window;
        if (PAGE_CONSTANT.equals(this.tabbedPanel.getCurrentName())) {
            this.initialFocusInternal(window);
        } else if (PAGE_VARIABLE.equals(this.tabbedPanel.getCurrentName())) {
            this.initialFocusVariable(window);
        }
    }

    protected void closeWindow() {
        if (this.parentWindow != null) {
            this.parentWindow.getWindowManager().closeWindow(this.parentWindow);
        }
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    protected void initialFocusInternal(Window window) {
    }

    private void initialFocusVariable(Window window) {
        window.setTextFocus((Widget)this.variableIndex);
    }

    public static Integer parseIntSafe(String newText) {
        Integer f;
        if (newText == null || newText.isEmpty()) {
            return null;
        }
        try {
            f = newText.startsWith("$") ? Integer.valueOf((int)Long.parseLong(newText.substring(1), 16)) : Integer.valueOf(Integer.parseInt(newText));
        }
        catch (NumberFormatException e) {
            f = null;
        }
        return f;
    }

    public static Long parseLongSafe(String newText) {
        Long f;
        if (newText == null || newText.isEmpty()) {
            return null;
        }
        try {
            f = newText.startsWith("$") ? Long.valueOf(Long.parseLong(newText.substring(1), 16)) : Long.valueOf(Long.parseLong(newText));
        }
        catch (NumberFormatException e) {
            f = null;
        }
        return f;
    }

    public static Float parseFloatSafe(String newText) {
        Float f;
        try {
            f = Float.valueOf(Float.parseFloat(newText));
        }
        catch (NumberFormatException e) {
            f = null;
        }
        return f;
    }

    public static Double parseDoubleSafe(String newText) {
        Double f;
        try {
            f = Double.parseDouble(newText);
        }
        catch (NumberFormatException e) {
            f = null;
        }
        return f;
    }

    protected abstract ParameterValue readConstantValue();

    protected abstract void writeConstantValue(ParameterValue var1);

    @Override
    public ParameterValue readValue() {
        if (PAGE_CONSTANT.equals(this.tabbedPanel.getCurrentName())) {
            return this.readConstantValue();
        }
        if (PAGE_VARIABLE.equals(this.tabbedPanel.getCurrentName())) {
            Integer var = AbstractParameterEditor.parseIntSafe(this.variableIndex.getText());
            if (var != null) {
                return ParameterValue.variable(var);
            }
            return ParameterValue.variable(0);
        }
        if (PAGE_FUNCTION.equals(this.tabbedPanel.getCurrentName())) {
            String currentChoice = this.functionLabel.getCurrentChoice();
            return ParameterValue.function(Functions.FUNCTIONS.get(currentChoice));
        }
        return null;
    }

    @Override
    public void writeValue(ParameterValue value) {
        if (value == null || value.isConstant()) {
            this.switchPage(PAGE_CONSTANT, null);
            this.writeConstantValue(value);
        } else if (value.isVariable()) {
            this.switchPage(PAGE_VARIABLE, null);
            this.variableIndex.setText(Integer.toString(value.getVariableIndex()));
        } else if (value.isFunction()) {
            this.switchPage(PAGE_FUNCTION, null);
            String id = value.getFunction().getId();
            this.functionLabel.setChoice(id);
        }
    }

    protected Panel createLabeledPanel(Minecraft mc, Gui gui, String label, Widget<?> object, String ... tooltips) {
        object.setTooltips(tooltips);
        return (Panel)((Panel)new Panel(mc, gui).setLayout((Layout)new HorizontalLayout()).addChild((Widget)((Label)((Label)((Label)new Label(mc, gui).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setText(label)).setTooltips(tooltips)).setDesiredWidth(60))).addChild(object);
    }

    void createEditorPanel(Minecraft mc, Gui gui, Panel panel, ParameterEditorCallback callback, Panel constantPanel, ParameterType type) {
        Panel variablePanel = (Panel)new Panel(mc, gui).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(18);
        this.variableIndex = ((TextField)((TextField)new TextField(mc, gui).setDesiredHeight(14)).setTooltips(new String[]{"Index (in the processor)", "of the variable", "(first variable has index 0)"})).addTextEvent((parent, newText) -> callback.valueChanged(this.readValue()));
        ((Panel)((Panel)((Panel)variablePanel.addChild((Widget)new Label(mc, gui).setText("Index:"))).setTooltips(new String[]{"Index (in the processor)", "of the variable", "(first variable has index 0)"})).setDesiredHeight(14)).addChild((Widget)this.variableIndex);
        Panel functionPanel = new Panel(mc, gui).setLayout((Layout)new HorizontalLayout());
        this.functionLabel = (ChoiceLabel)new ChoiceLabel(mc, gui).setDesiredWidth(120);
        List<Function> functions = Functions.getFunctionsByType(type);
        for (Function function : functions) {
            this.functionLabel.addChoices(new String[]{function.getId()});
            this.functionLabel.setChoiceTooltip(function.getId(), function.getDescription().toArray(new String[function.getDescription().size()]));
        }
        functionPanel.addChild((Widget)this.functionLabel);
        this.functionLabel.addChoiceEvent((parent, newChoice) -> callback.valueChanged(this.readValue()));
        this.tabbedPanel = new TabbedPanel(mc, gui).addPage(PAGE_CONSTANT, (Widget)constantPanel).addPage(PAGE_VARIABLE, (Widget)variablePanel).addPage(PAGE_FUNCTION, (Widget)functionPanel);
        this.tabbedPanel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 23, 180, 60 + this.getHeight() - 5 - 18 - 40));
        this.buttonPanel = (Panel)new Panel(mc, gui).setLayout((Layout)new HorizontalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 5, 180, 18));
        ToggleButton constantButton = ((ToggleButton)new ToggleButton(mc, gui).setText(PAGE_CONSTANT)).addButtonEvent(w -> this.switchPage(PAGE_CONSTANT, callback));
        this.variableButton = ((ToggleButton)new ToggleButton(mc, gui).setText(PAGE_VARIABLE)).addButtonEvent(w -> this.switchPage(PAGE_VARIABLE, callback));
        this.functionButton = ((ToggleButton)new ToggleButton(mc, gui).setText(PAGE_FUNCTION)).addButtonEvent(w -> this.switchPage(PAGE_FUNCTION, callback));
        ((Panel)((Panel)this.buttonPanel.addChild((Widget)constantButton)).addChild((Widget)this.variableButton)).addChild((Widget)this.functionButton);
        ((Panel)panel.addChild((Widget)this.buttonPanel)).addChild((Widget)this.tabbedPanel);
    }

    private void switchPage(String page, ParameterEditorCallback callback) {
        for (int i = 0; i < this.buttonPanel.getChildCount(); ++i) {
            ToggleButton button = (ToggleButton)this.buttonPanel.getChild(i);
            if (!page.equals(button.getText())) {
                button.setPressed(false);
            } else {
                button.setPressed(true);
            }
            this.tabbedPanel.setCurrent(page);
            if (callback == null) continue;
            callback.valueChanged(this.readValue());
        }
        if (this.parentWindow != null) {
            if (PAGE_CONSTANT.equals(page)) {
                this.initialFocusInternal(this.parentWindow);
            } else if (PAGE_VARIABLE.equals(page)) {
                this.initialFocusVariable(this.parentWindow);
            }
        }
    }
}

