/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.block.BlockConjured;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.spell.trick.block.PieceTrickConjureBlock;

public class PieceTrickConjureBlockSequence
extends PieceTrick {
    SpellParam position;
    SpellParam target;
    SpellParam maxBlocks;
    SpellParam time;

    public PieceTrickConjureBlockSequence(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.target = new ParamVector("psi.spellparam.target", SpellParam.GREEN, false, false);
        this.addParam(this.target);
        this.maxBlocks = new ParamNumber("psi.spellparam.max", SpellParam.RED, false, true);
        this.addParam(this.maxBlocks);
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.PURPLE, true, false);
        this.addParam(this.time);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double maxBlocksVal = (Double)this.getParamEvaluation(this.maxBlocks);
        if (maxBlocksVal == null || maxBlocksVal <= 0.0) {
            throw new SpellCompilationException("psi.spellerror.nonpositivevalue", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(maxBlocksVal * 15.0));
        meta.addStat(EnumSpellStat.COST, (int)(maxBlocksVal * 20.0));
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        Vector3 targetVal = (Vector3)this.getParamValue(context, this.target);
        Double maxBlocksVal = (Double)this.getParamValue(context, this.maxBlocks);
        Double timeVal = (Double)this.getParamValue(context, this.time);
        int maxBlocksInt = maxBlocksVal.intValue();
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        int len = (int)targetVal.mag();
        Vector3 targetNorm = targetVal.copy().normalize();
        World world = context.caster.func_130014_f_();
        for (int i = 0; i < Math.min(len, maxBlocksInt); ++i) {
            Vector3 blockVec = positionVal.copy().add(targetNorm.copy().multiply(i));
            if (!context.isInRadius(blockVec)) {
                throw new SpellRuntimeException("psi.spellerror.outsideradius");
            }
            BlockPos pos = blockVec.toBlockPos();
            if (!world.func_175660_a(context.caster, pos)) continue;
            PieceTrickConjureBlock.conjure(context, timeVal, pos, world, this.messWithState(ModBlocks.conjured.func_176223_P()));
        }
        return null;
    }

    public IBlockState messWithState(IBlockState state) {
        return state.func_177226_a((IProperty)BlockConjured.SOLID, (Comparable)Boolean.valueOf(true));
    }
}

