/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;

public class ItemBlockEnergyContainerAutoSupply
extends ItemBlockEnergyContainer {
    public ItemBlockEnergyContainerAutoSupply(Block block) {
        super(block);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)this.isActivated(itemStack), (String)(this.func_77658_a() + ".info.auto_supply"));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return new ActionResult(EnumActionResult.PASS, (Object)this.toggleActivation(player.func_184586_b(hand), world, player));
    }

    public static void autofill(IEnergyStorage source, World world, Entity entity) {
        int tickAmount;
        if (entity instanceof EntityPlayer && !world.field_72995_K && (tickAmount = source.extractEnergy(Integer.MAX_VALUE, true)) > 0) {
            EntityPlayer player = (EntityPlayer)entity;
            for (EnumHand hand : EnumHand.values()) {
                ItemStack held = player.func_184586_b(hand);
                ItemStack filled = ItemBlockEnergyContainerAutoSupply.tryFillContainerForPlayer(source, held, tickAmount, player);
                if (filled == null) continue;
                player.func_184611_a(hand, filled);
            }
        }
    }

    public static ItemStack tryFillContainerForPlayer(IEnergyStorage source, ItemStack held, int tickAmount, EntityPlayer player) {
        IEnergyStorage target;
        int moved;
        if (held.hasCapability(CapabilityEnergy.ENERGY, null) && (moved = (target = (IEnergyStorage)held.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(source.extractEnergy(target.receiveEnergy(tickAmount, true), false), false)) > 0) {
            return held;
        }
        return null;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean par5) {
        if (this.isActivated(itemStack) && itemStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            ItemBlockEnergyContainerAutoSupply.autofill((IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null), world, entity);
        }
        super.func_77663_a(itemStack, world, entity, itemSlot, par5);
    }

    public ItemStack toggleActivation(ItemStack itemStack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemStack activated = itemStack.func_77946_l();
                activated.func_77964_b(1 - activated.func_77952_i());
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    public boolean isActivated(ItemStack itemStack) {
        return itemStack.func_77952_i() == 1;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return this.isActivated(itemStack);
    }
}

