/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.dimensions.world.LostWoodlandMansion;
import mcjty.lostcities.dimensions.world.LostWorldProvider;
import mcjty.lostcities.dimensions.world.LostWorldType;
import mcjty.lostcities.dimensions.world.LostWorldTypeAdapter;
import mcjty.lostcities.dimensions.world.LostWorldTypeBOP;
import net.minecraft.world.DimensionType;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.StringUtils;

public class ModDimensions {
    public static LostWorldType worldType;
    public static LostWorldTypeBOP worldTypeBOP;
    public static List<LostWorldTypeAdapter> worldTypeAdapterList;
    public static DimensionType lostDimensionType;
    public static Map<Integer, String> dimensionProfileMap;

    public static void init() {
        worldType = new LostWorldType();
        if (LostCities.biomesoplenty) {
            worldTypeBOP = new LostWorldTypeBOP();
        }
        for (String worldtype : LostCityConfiguration.ADAPTING_WORLDTYPES) {
            worldTypeAdapterList.add(new LostWorldTypeAdapter(worldtype));
        }
        if (LostCityConfiguration.DIMENSION_ID != -1) {
            lostDimensionType = DimensionType.register((String)"lostcities", (String)"_lost", (int)LostCityConfiguration.DIMENSION_ID, LostWorldProvider.class, (boolean)false);
            DimensionManager.registerDimension((int)LostCityConfiguration.DIMENSION_ID, (DimensionType)lostDimensionType);
            dimensionProfileMap.put(LostCityConfiguration.DIMENSION_ID, LostCityConfiguration.DIMENSION_PROFILE);
        }
        for (String dimInfo : LostCityConfiguration.ADDITIONAL_DIMENSIONS) {
            String[] split = StringUtils.split((String)dimInfo, (char)':');
            int id = Integer.parseInt(split[0]);
            String profile = split[1];
            if (lostDimensionType == null) {
                lostDimensionType = DimensionType.register((String)"lostcities", (String)"_lost", (int)id, LostWorldProvider.class, (boolean)false);
            }
            DimensionManager.registerDimension((int)id, (DimensionType)lostDimensionType);
            dimensionProfileMap.put(id, profile);
        }
        MapGenStructureIO.func_143034_b(LostWoodlandMansion.Start.class, (String)"LostMansion");
    }

    static {
        worldTypeAdapterList = new ArrayList<LostWorldTypeAdapter>();
        dimensionProfileMap = new HashMap<Integer, String>();
    }
}

