/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.WorldTypeTools;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.CitySphere;
import mcjty.lostcities.dimensions.world.lost.cityassets.AssetRegistries;
import mcjty.lostcities.dimensions.world.lost.cityassets.PredefinedCity;
import mcjty.lostcities.dimensions.world.lost.cityassets.PredefinedSphere;
import mcjty.lostcities.varia.CustomTeleporter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onCreateSpawnPoint(WorldEvent.CreateSpawnPosition event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            if (!WorldTypeTools.isLostCities(world)) {
                return;
            }
            LostCityProfile profile = WorldTypeTools.getProfile(world);
            if (profile == null) {
                return;
            }
            LostCityChunkGenerator provider = WorldTypeTools.getLostCityChunkGenerator(world);
            Predicate<BlockPos> isSuitable = pos -> true;
            boolean needsCheck = false;
            if (!profile.SPAWN_BIOME.isEmpty()) {
                Biome spawnBiome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(profile.SPAWN_BIOME));
                if (spawnBiome == null) {
                    LostCities.logger.error("Cannot find biome '" + profile.SPAWN_BIOME + "' for the player to spawn in !");
                } else {
                    isSuitable = blockPos -> world.func_180494_b(blockPos) == spawnBiome;
                    needsCheck = true;
                }
            } else if (!profile.SPAWN_CITY.isEmpty()) {
                PredefinedCity city = AssetRegistries.PREDEFINED_CITIES.get(profile.SPAWN_CITY);
                if (city == null) {
                    LostCities.logger.error("Cannot find city '" + profile.SPAWN_CITY + "' for the player to spawn in !");
                } else {
                    float sqradius = this.getSqRadius(city.getRadius(), 0.8f);
                    isSuitable = blockPos -> city.getDimension() == world.field_73011_w.getDimension() && CitySphere.squaredDistance(city.getChunkX() * 16 + 8, city.getChunkZ() * 16 + 8, blockPos.func_177958_n(), blockPos.func_177952_p()) < (double)sqradius;
                    needsCheck = true;
                }
            } else if (!profile.SPAWN_SPHERE.isEmpty()) {
                if ("<in>".equals(profile.SPAWN_SPHERE)) {
                    isSuitable = blockPos -> {
                        CitySphere sphere = CitySphere.getCitySphere(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4, provider);
                        if (!sphere.isEnabled()) {
                            return false;
                        }
                        float sqradius = this.getSqRadius((int)sphere.getRadius(), 0.8f);
                        return sphere.getCenterPos().func_177951_i((Vec3i)blockPos) < (double)sqradius;
                    };
                    needsCheck = true;
                } else if ("<out>".equals(profile.SPAWN_SPHERE)) {
                    isSuitable = blockPos -> {
                        CitySphere sphere = CitySphere.getCitySphere(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4, provider);
                        if (!sphere.isEnabled()) {
                            return true;
                        }
                        float sqradius = sphere.getRadius() * sphere.getRadius();
                        return sphere.getCenterPos().func_177951_i((Vec3i)new BlockPos(blockPos.func_177958_n(), sphere.getCenterPos().func_177956_o(), blockPos.func_177952_p())) > (double)sqradius;
                    };
                    needsCheck = true;
                } else {
                    PredefinedSphere sphere = AssetRegistries.PREDEFINED_SPHERES.get(profile.SPAWN_SPHERE);
                    if (sphere == null) {
                        LostCities.logger.error("Cannot find sphere '" + profile.SPAWN_SPHERE + "' for the player to spawn in !");
                    } else {
                        float sqradius = this.getSqRadius(sphere.getRadius(), 0.8f);
                        isSuitable = blockPos -> sphere.getDimension() == world.field_73011_w.getDimension() && CitySphere.squaredDistance(sphere.getChunkX() * 16 + 8, sphere.getChunkZ() * 16 + 8, blockPos.func_177958_n(), blockPos.func_177952_p()) < (double)sqradius;
                        needsCheck = true;
                    }
                }
            }
            if (profile.SPAWN_NOT_IN_BUILDING) {
                isSuitable = isSuitable.and(blockPos -> this.isOutsideBuilding(provider, (BlockPos)blockPos));
                needsCheck = true;
            }
            switch (profile.LANDSCAPE_TYPE) {
                case DEFAULT: 
                case CAVERN: {
                    if (!needsCheck) break;
                    this.findSafeSpawnPoint(world, provider, isSuitable);
                    event.setCanceled(true);
                    break;
                }
                case FLOATING: 
                case SPACE: {
                    this.findSafeSpawnPoint(world, provider, isSuitable);
                    event.setCanceled(true);
                }
            }
        }
    }

    private boolean isOutsideBuilding(LostCityChunkGenerator provider, BlockPos pos) {
        BuildingInfo info = BuildingInfo.getBuildingInfo(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, provider);
        return !info.isCity() || !info.hasBuilding;
    }

    private int getSqRadius(int radius, float pct) {
        return (int)((float)radius * pct * ((float)radius * pct));
    }

    private void findSafeSpawnPoint(World world, LostCityChunkGenerator provider, @Nonnull Predicate<BlockPos> isSuitable) {
        Random rand = new Random(world.func_72905_C());
        rand.nextFloat();
        rand.nextFloat();
        int radius = 200;
        int attempts = 0;
        do {
            for (int i = 0; i < 200; ++i) {
                int x = rand.nextInt(radius * 2) - radius;
                int z = rand.nextInt(radius * 2) - radius;
                ++attempts;
                if (!isSuitable.test(new BlockPos(x, 128, z))) continue;
                LostCityProfile profile = BuildingInfo.getProfile(x >> 4, z >> 4, provider);
                for (int y = profile.GROUNDLEVEL - 5; y < 125; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!this.isValidStandingPosition(world, pos)) continue;
                    world.func_175652_B(pos.func_177984_a());
                    return;
                }
            }
            radius += 100;
        } while (attempts <= 10000);
        LostCities.logger.error("Can't find a valid spawn position!");
        throw new RuntimeException("Can't find a valid spawn position!");
    }

    private boolean isValidStandingPosition(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().func_185481_k(state) && state.func_177230_c().func_149686_d(state) && state.func_177230_c().func_149662_c(state) && world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(pos.func_177981_b(2));
    }

    private boolean isValidSpawnBed(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockBed)) {
            return false;
        }
        EnumFacing direction = Blocks.field_150324_C.getBedDirection(state, (IBlockAccess)world, pos);
        Block b1 = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block b2 = world.func_180495_p(pos.func_177972_a(direction.func_176734_d()).func_177977_b()).func_177230_c();
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(LostCityConfiguration.SPECIAL_BED_BLOCK));
        if (b1 != b || b2 != b) {
            return false;
        }
        if (world.func_180495_p(pos.func_177972_a(direction)).func_177230_c() != Blocks.field_150465_bP) {
            return false;
        }
        if (world.func_180495_p(pos.func_177972_a(direction.func_176746_e())).func_177230_c() != Blocks.field_150465_bP) {
            return false;
        }
        if (world.func_180495_p(pos.func_177972_a(direction.func_176735_f())).func_177230_c() != Blocks.field_150465_bP) {
            return false;
        }
        if (world.func_180495_p(pos.func_177967_a(direction.func_176734_d(), 2)).func_177230_c() != Blocks.field_150465_bP) {
            return false;
        }
        if (world.func_180495_p(pos.func_177972_a(direction.func_176734_d()).func_177972_a(direction.func_176734_d().func_176746_e())).func_177230_c() != Blocks.field_150465_bP) {
            return false;
        }
        return world.func_180495_p(pos.func_177972_a(direction.func_176734_d()).func_177972_a(direction.func_176734_d().func_176735_f())).func_177230_c() == Blocks.field_150465_bP;
    }

    private BlockPos findValidTeleportLocation(World world, BlockPos start) {
        int y;
        int chunkZ;
        int chunkX = start.func_177958_n() >> 4;
        BlockPos pos = this.findValidTeleportLocation(world, chunkX, chunkZ = start.func_177952_p() >> 4, y = start.func_177956_o());
        if (pos != null) {
            return pos;
        }
        for (int r = 1; r < 50; ++r) {
            for (int i = -r; i < r; ++i) {
                pos = this.findValidTeleportLocation(world, chunkX + i, chunkZ - r, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX + r, chunkZ + i, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX + r - i, chunkZ + r, y);
                if (pos != null) {
                    return pos;
                }
                pos = this.findValidTeleportLocation(world, chunkX - r, chunkZ + r - i, y);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    private BlockPos findValidTeleportLocation(World world, int chunkX, int chunkZ, int y) {
        BlockPos bestSpot = null;
        for (int dy = 0; dy < 255; ++dy) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos p;
                    if (y + dy < 250) {
                        p = new BlockPos(chunkX * 16 + x, y + dy, chunkZ * 16 + z);
                        if (this.isValidSpawnBed(world, p)) {
                            return p.func_177984_a();
                        }
                        if (bestSpot == null && this.isValidStandingPosition(world, p)) {
                            bestSpot = p.func_177984_a();
                        }
                    }
                    if (y - dy <= 1) continue;
                    p = new BlockPos(chunkX * 16 + x, y - dy, chunkZ * 16 + z);
                    if (this.isValidSpawnBed(world, p)) {
                        return p.func_177984_a();
                    }
                    if (bestSpot != null || !this.isValidStandingPosition(world, p)) continue;
                    bestSpot = p.func_177984_a();
                }
            }
        }
        return bestSpot;
    }

    @SubscribeEvent
    public void onPlayerSleepInBedEvent(PlayerSleepInBedEvent event) {
        if (LostCityConfiguration.DIMENSION_ID == -1) {
            return;
        }
        World world = event.getEntityPlayer().func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        BlockPos bedLocation = event.getPos();
        if (!this.isValidSpawnBed(world, bedLocation)) {
            return;
        }
        if (world.field_73011_w.getDimension() == LostCityConfiguration.DIMENSION_ID) {
            event.setResult(Event.Result.DENY);
            WorldServer destWorld = DimensionManager.getWorld((int)0);
            BlockPos location = this.findLocation(bedLocation, destWorld);
            CustomTeleporter.teleportToDimension(event.getEntityPlayer(), 0, location);
        } else {
            event.setResult(Event.Result.DENY);
            WorldServer destWorld = event.getEntity().func_130014_f_().func_73046_m().func_71218_a(LostCityConfiguration.DIMENSION_ID);
            BlockPos location = this.findLocation(bedLocation, destWorld);
            CustomTeleporter.teleportToDimension(event.getEntityPlayer(), LostCityConfiguration.DIMENSION_ID, location);
        }
    }

    private BlockPos findLocation(BlockPos bedLocation, WorldServer destWorld) {
        BlockPos top = destWorld.func_175672_r(bedLocation);
        BlockPos location = this.findValidTeleportLocation((World)destWorld, top);
        if (location == null) {
            location = top;
            if (destWorld.func_175623_d(top.func_177977_b())) {
                destWorld.func_175656_a(bedLocation, Blocks.field_150347_e.func_176223_P());
                location = bedLocation.func_177984_a();
            }
        }
        return location;
    }
}

