/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.lib.tilemodule.energyu.fe.storage;

import com.valkyrieofnight.vlib.lib.sys.io.nbt.INBTHandler;
import com.valkyrieofnight.vlib.lib.tilemodule.energyu.fe.IFEInternals;
import com.valkyrieofnight.vlib.lib.tilemodule.energyu.fe.IFEProducer;
import net.minecraft.nbt.NBTTagCompound;

public class FEProducer
implements IFEProducer,
INBTHandler<FEProducer>,
IFEInternals {
    protected int energy = 0;
    protected int capacity;
    protected int maxExtract;

    public FEProducer(int capacity) {
        this(capacity, capacity);
    }

    public FEProducer(int capacity, int maxExtract) {
        this.capacity = capacity;
        this.maxExtract = maxExtract;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public int getEnergyRoom() {
        return this.capacity - this.energy;
    }

    @Override
    public FEProducer readFromNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74762_e("energy");
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        return this;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.energy < 0) {
            this.energy = 0;
        }
        nbt.func_74768_a("energy", this.energy);
        return nbt;
    }

    @Override
    public void iSetFEStored(int en) {
        this.energy = en;
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
    }

    @Override
    public int iReceiveFE(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int iExtractFE(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.energy, maxExtract);
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int getRoom() {
        return this.capacity - this.energy;
    }
}

