/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tile;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.NetworkUtil;
import java.io.IOException;
import javax.annotation.Nonnull;
import magicbees.tile.logic.EffectJarHousing;
import magicbees.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityEffectJar
extends TileEntity
implements ITickable,
IActivatable,
IStreamable {
    private GameProfile ownerName;
    private ItemStackHandler beeSlots;
    private ItemStack queenStack = ItemStack.field_190927_a;
    private ItemStack droneQueen = null;
    private EffectJarHousing housingLogic = new EffectJarHousing(this);
    private IEffectData[] effectData = new IEffectData[2];
    private int throttle;
    private int currentBeeHealth;
    private int currentBeeColour;
    private boolean active = false;

    public TileEntityEffectJar() {
        this.beeSlots = new ItemStackHandler(1);
    }

    public void setOwner(EntityPlayer player) {
        this.ownerName = player.func_146103_bH();
    }

    public ItemStackHandler getInventory() {
        return this.beeSlots;
    }

    public int getCurrentBeeColour() {
        return this.currentBeeColour;
    }

    public int getCurrentBeeHealth() {
        return this.currentBeeHealth;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public ItemStack getQueenStack() {
        return this.queenStack;
    }

    public ItemStack getDrone() {
        if (this.droneQueen == null) {
            if (this.queenStack.func_190926_b()) {
                this.droneQueen = ItemStack.field_190927_a;
                return this.droneQueen;
            }
            this.droneQueen = new ItemStack((Item)Utils.getApicultureItems().beeDroneGE, 1, this.queenStack.func_77952_i());
            this.droneQueen.func_77982_d(((NBTTagCompound)Preconditions.checkNotNull((Object)this.queenStack.func_77978_p())).func_74737_b());
        }
        return this.droneQueen;
    }

    public void func_73660_a() {
        if (this.hasQueen()) {
            this.tickQueen();
        } else if (this.hasDrone()) {
            this.createQueenFromDrone();
        }
    }

    public void setQueenStack(ItemStack queenStack) {
        if (queenStack.func_190926_b()) {
            queenStack = ItemStack.field_190927_a;
        }
        this.queenStack = queenStack;
        this.droneQueen = null;
    }

    public GameProfile getOwner() {
        return this.ownerName;
    }

    private void createQueenFromDrone() {
        ItemStack droneStack = this.beeSlots.getStackInSlot(0);
        if (BeeManager.beeRoot.isDrone(droneStack)) {
            IBee bee = (IBee)Preconditions.checkNotNull((Object)BeeManager.beeRoot.getMember(droneStack));
            if (droneStack.func_190916_E() == 1) {
                this.beeSlots.setStackInSlot(0, ItemStack.field_190927_a);
            } else {
                droneStack.func_190918_g(1);
            }
            this.queenStack = new ItemStack((Item)Utils.getApicultureItems().beeQueenGE, 1, droneStack.func_77952_i());
            this.queenStack.func_77982_d(((NBTTagCompound)Preconditions.checkNotNull((Object)droneStack.func_77978_p())).func_74737_b());
            this.queenStack.func_190920_e(1);
            this.droneQueen = null;
            int current = bee.getHealth();
            int max = bee.getMaxHealth();
            this.currentBeeHealth = current * 100 / max;
            this.currentBeeColour = bee.getGenome().getPrimary().getSpriteColour(0);
        }
        this.func_70296_d();
    }

    private boolean hasDrone() {
        return !this.beeSlots.getStackInSlot(0).func_190926_b();
    }

    @Nonnull
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            if (!this.field_145850_b.field_72995_K) {
                NetworkUtil.sendNetworkPacket((IForestryPacketClient)new PacketActiveUpdate((IActivatable)this), (BlockPos)this.field_174879_c, (World)this.field_145850_b);
            }
        }
    }

    private void tickQueen() {
        IBee queen = BeeManager.beeRoot.getMember(this.queenStack);
        if (this.queenStack == null || queen == null) {
            throw new RuntimeException();
        }
        if (this.field_145850_b.field_72995_K && this.active && this.func_145831_w().func_72820_D() % 4L == 0L) {
            this.effectData = queen.doFX(this.effectData, (IBeeHousing)this.housingLogic);
            return;
        }
        this.setActive(this.housingLogic.canWork());
        if (!this.active) {
            return;
        }
        this.currentBeeColour = queen.getGenome().getPrimary().getSpriteColour(0);
        this.effectData = queen.doEffect(this.effectData, (IBeeHousing)this.housingLogic);
        if (this.throttle > 550) {
            this.throttle = 0;
            queen.age(this.func_145831_w(), 0.26f);
            if (queen.getHealth() == 0) {
                this.queenStack = ItemStack.field_190927_a;
                this.droneQueen = null;
                this.currentBeeHealth = 0;
                this.currentBeeColour = 0xFFFFFF;
            } else {
                if (this.queenStack.func_77978_p() == null) {
                    this.queenStack.func_77982_d(new NBTTagCompound());
                }
                queen.writeToNBT(this.queenStack.func_77978_p());
            }
            this.currentBeeHealth = queen.getHealth() * 100 / queen.getMaxHealth();
            this.func_70296_d();
            NetworkUtil.sendNetworkPacket((IForestryPacketClient)new PacketTileStream((TileEntity)this), (BlockPos)this.field_174879_c, (World)this.field_145850_b);
        } else {
            ++this.throttle;
        }
    }

    private boolean hasQueen() {
        return !this.queenStack.func_190926_b();
    }

    public void func_145839_a(NBTTagCompound tagRoot) {
        super.func_145839_a(tagRoot);
        this.beeSlots.deserializeNBT(tagRoot.func_74775_l("beeSlots"));
        if (!tagRoot.func_74764_b("queenStack")) {
            this.queenStack = this.droneQueen = ItemStack.field_190927_a;
        } else {
            this.queenStack = new ItemStack(tagRoot.func_74775_l("queenStack"));
            this.droneQueen = null;
        }
        this.currentBeeHealth = tagRoot.func_74762_e("currentBeeHealth");
        this.throttle = tagRoot.func_74762_e("throttle");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tagRoot) {
        super.func_189515_b(tagRoot);
        tagRoot.func_74782_a("beeSlots", (NBTBase)this.beeSlots.serializeNBT());
        if (!this.queenStack.func_190926_b()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.queenStack.func_77955_b(tag);
            tagRoot.func_74782_a("queenStack", (NBTBase)tag);
        }
        tagRoot.func_74768_a("currentBeeHealth", this.currentBeeHealth);
        tagRoot.func_74768_a("throttle", this.throttle);
        return tagRoot;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public ItemStack getDropStack() {
        return this.beeSlots.getStackInSlot(0);
    }

    public void writeData(@Nonnull PacketBufferForestry data) {
        data.func_150786_a(this.func_189515_b(new NBTTagCompound()));
    }

    public void readData(@Nonnull PacketBufferForestry data) throws IOException {
        this.func_145839_a(data.func_150793_b());
    }
}

