/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IAlleleSpeciesBuilder;
import forestry.api.genetics.IClassification;
import java.awt.Color;
import javax.annotation.Nonnull;
import magicbees.bees.BeeIntegrationInterface;
import magicbees.elec332.corerepack.compat.forestry.ForestryAlleles;
import magicbees.elec332.corerepack.compat.forestry.bee.BeeGenomeTemplate;
import magicbees.elec332.corerepack.compat.forestry.bee.ForestryBeeEffects;
import magicbees.init.AlleleRegister;
import magicbees.util.Config;
import magicbees.util.IMagicBeesBranch;
import magicbees.util.Utils;
import net.minecraftforge.fml.common.Loader;

public enum EnumBeeBranches implements IMagicBeesBranch
{
    VEILED("Velatapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
        }

        @Override
        public void setIndividualProperties(IAlleleSpeciesBuilder speciesBuilder) {
        }
    }
    ,
    ARCANE("Arcanapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
            genomeTemplate.setFloweringSpeed(ForestryAlleles.FLOWERING_SLOW);
            genomeTemplate.setFertility(ForestryAlleles.FERTILITY_HIGH);
        }

        @Override
        public Color getSecondaryColor() {
            return new Color(16751968);
        }
    }
    ,
    SUPERNATURAL("Occultapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
            genomeTemplate.setSpeed(ForestryAlleles.SPEED_NORMAL);
            genomeTemplate.setFloweringSpeed(ForestryAlleles.FLOWERING_SLOWEST);
        }

        @Override
        public Color getSecondaryColor() {
            return ARCANE.getSecondaryColor();
        }
    }
    ,
    SCHOLARLY("Doctapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setSpeed(ForestryAlleles.SPEED_SLOW);
            genomeTemplate.setLifeSpan(ForestryAlleles.LIFESPAN_ELONGATED);
            genomeTemplate.setTemperatureTolerance(ForestryAlleles.TOLERANCE_UP_2);
            genomeTemplate.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
            genomeTemplate.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
            genomeTemplate.setFlowerProvider(AlleleRegister.flowersBookshelf);
        }

        @Override
        public void setIndividualProperties(IAlleleSpeciesBuilder speciesBuilder) {
            super.setIndividualProperties(speciesBuilder);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
        }
    }
    ,
    SKULKING("Malevolenapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setSpeed(ForestryAlleles.SPEED_FAST);
            genomeTemplate.setFloweringSpeed(ForestryAlleles.FLOWERING_FASTER);
            genomeTemplate.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
            genomeTemplate.setFertility(ForestryAlleles.FERTILITY_NORMAL);
        }

        @Override
        public void setIndividualProperties(IAlleleSpeciesBuilder speciesBuilder) {
        }

        @Override
        public Color getSecondaryColor() {
            return new Color(14766646);
        }
    }
    ,
    MAGICAL("Magicapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setSpeed(ForestryAlleles.SPEED_NORMAL);
            genomeTemplate.setLifeSpan(ForestryAlleles.LIFESPAN_NORMAL);
        }
    }
    ,
    TIME("Tempestivapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
            genomeTemplate.setFertility(ForestryAlleles.FERTILITY_NORMAL);
            genomeTemplate.setSpeed(ForestryAlleles.SPEED_NORMAL);
            genomeTemplate.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
        }
    }
    ,
    SOUL("Animapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
            genomeTemplate.setToleratesRain(ForestryAlleles.TRUE_RECESSIVE);
        }
    }
    ,
    ABOMINABLE("Detestabilapis"){

        @Override
        public void setIndividualProperties(IAlleleSpeciesBuilder speciesBuilder) {
            super.setIndividualProperties(speciesBuilder);
            speciesBuilder.setTemperature(EnumTemperature.HELLISH);
            speciesBuilder.setHumidity(EnumHumidity.ARID);
        }

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setTemperatureTolerance(ForestryAlleles.TOLERANCE_DOWN_2);
            genomeTemplate.setFlowerProvider(ForestryAlleles.FLOWERS_NETHER);
            genomeTemplate.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
            genomeTemplate.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
            genomeTemplate.setEffect((IAlleleEffect)ForestryBeeEffects.effectAggressive);
            genomeTemplate.setLifeSpan(ForestryAlleles.LIFESPAN_SHORT);
        }

        @Override
        public Color getSecondaryColor() {
            return new Color(9834240);
        }
    }
    ,
    EXTRINSIC("Extrarapis"){

        @Override
        public void setIndividualProperties(IAlleleSpeciesBuilder speciesBuilder) {
            super.setIndividualProperties(speciesBuilder);
            speciesBuilder.setTemperature(EnumTemperature.COLD);
        }

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setTemperatureTolerance(ForestryAlleles.TOLERANCE_UP_2);
            genomeTemplate.setEffect((IAlleleEffect)ForestryBeeEffects.effectAggressive);
            genomeTemplate.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
            genomeTemplate.setFlowerProvider(ForestryAlleles.FLOWERS_END);
            genomeTemplate.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
        }

        @Override
        public Color getSecondaryColor() {
            return new Color(0xF696FF);
        }
    }
    ,
    METALLIC("Metalliapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setSpeed(ForestryAlleles.SPEED_SLOWEST);
            genomeTemplate.setFertility(ForestryAlleles.FERTILITY_LOW);
            genomeTemplate.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
            genomeTemplate.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
        }

        @Override
        public boolean enabled() {
            return Config.Bees.enableGemBees;
        }
    }
    ,
    GEM("Lapidapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            METALLIC.setBranchProperties(genomeTemplate);
        }

        @Override
        public boolean enabled() {
            return Config.Bees.enableGemBees;
        }
    }
    ,
    TRANSMUTING("Transmutapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setLifeSpan(ForestryAlleles.LIFESPAN_SHORTEST);
            genomeTemplate.setHumidityTolerance(ForestryAlleles.TOLERANCE_UP_1);
            genomeTemplate.setTemperatureTolerance(ForestryAlleles.TOLERANCE_DOWN_2);
        }
    }
    ,
    THAUMIC("Thaumiapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setFertility(ForestryAlleles.FERTILITY_LOW);
            genomeTemplate.setFlowerProvider(null);
        }
    }
    ,
    FLESHY("Carnosapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            SKULKING.setBranchProperties(genomeTemplate);
        }
    }
    ,
    ALCHEMICAL("Alchimiapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            throw new IllegalStateException();
        }
    }
    ,
    ESSENTIAL("Essentiapis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            throw new IllegalStateException();
        }
    }
    ,
    THERMAL("Thermametallic"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate template) {
            BeeIntegrationInterface.getTemplateTE(template);
        }

        @Override
        public boolean enabled() {
            return Loader.isModLoaded((String)"thermalfoundation");
        }
    }
    ,
    ADORABLE("Amabilis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            throw new IllegalStateException();
        }
    }
    ,
    BLOODY("Sanguis"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            throw new IllegalStateException();
        }
    }
    ,
    BOTANICAL("Botanica"){

        @Override
        public void setBranchProperties(BeeGenomeTemplate genomeTemplate) {
            genomeTemplate.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
            genomeTemplate.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_1);
            genomeTemplate.setSpeed(ForestryAlleles.SPEED_SLOWER);
        }

        @Override
        public Color getSecondaryColor() {
            return new Color(0xFFB2BB);
        }

        @Override
        public void setIndividualProperties(IAlleleSpeciesBuilder speciesBuilder) {
        }

        @Override
        public boolean enabled() {
            return Loader.isModLoaded((String)"botania");
        }
    };

    private final IClassification classification;

    private EnumBeeBranches(String scientificName) {
        this.classification = BeeManager.beeFactory.createBranch("magicbees.branch." + this.name().toLowerCase(), scientificName);
    }

    @Override
    public abstract void setBranchProperties(BeeGenomeTemplate var1);

    @Override
    public void setIndividualProperties(IAlleleSpeciesBuilder speciesBuilder) {
        Utils.setSecret(speciesBuilder);
    }

    @Override
    @Nonnull
    public IClassification getClassification() {
        return this.classification;
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public Color getSecondaryColor() {
        return new Color(16743462);
    }

    public static void registerClassifications() {
        IClassification bees = AlleleManager.alleleRegistry.getClassification("family.apidae");
        for (EnumBeeBranches classification : EnumBeeBranches.values()) {
            bees.addMemberGroup(classification.getClassification());
        }
    }
}

