/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.alveary;

import binnie.extrabees.alveary.AlvearyLogic;
import binnie.extrabees.client.gui.AlvearyContainer;
import binnie.extrabees.client.gui.ContainerMutator;
import binnie.extrabees.client.gui.GuiContainerMutator;
import binnie.extrabees.utils.AlvearyMutationHandler;
import forestry.api.apiculture.IBeeGenome;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class AlvearyLogicMutator
extends AlvearyLogic {
    private final ItemStackHandler inv = new MutationItemStackHandler();

    public IItemHandlerModifiable getInventory() {
        return this.inv;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.inv.deserializeNBT(nbt.func_74775_l("inventory"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74782_a("inventory", (NBTBase)this.inv.serializeNBT());
        return nbt;
    }

    public float getMutationModifier(@Nonnull IBeeGenome genome, @Nonnull IBeeGenome mate, float currentModifier) {
        ItemStack mutator = this.inv.getStackInSlot(0);
        float mult = AlvearyMutationHandler.getMutationMult(mutator);
        return Math.min(mult * currentModifier, 15.0f);
    }

    @Override
    public void onQueenDeath() {
        this.inv.extractItem(0, 1, false);
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(@Nonnull EntityPlayer player, int data) {
        return new GuiContainerMutator(this.getContainer(player, data));
    }

    @Override
    @Nullable
    public AlvearyContainer getContainer(@Nonnull EntityPlayer player, int data) {
        return new ContainerMutator(player, this);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    private static class MutationItemStackHandler
    extends ItemStackHandler {
        public MutationItemStackHandler() {
            super(1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!AlvearyMutationHandler.isMutationItem(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

