/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static final Random RAND = new Random();
    public static String[] dyeNames = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
    static long UUIDBase = 109406000905L;
    static long UUIDAdd = 1L;
    static Method m_getHarvestLevel = null;
    private static final HashMap<String, String> MODNAME_LOOKUP = new HashMap();
    private static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        if (!ApiUtils.isExistingOreName(oreName)) {
            return false;
        }
        ItemStack comp = Utils.copyStackWithAmount(stack, 1);
        NonNullList s = OreDictionary.getOres((String)oreName);
        for (ItemStack st : s) {
            if (!OreDictionary.itemMatches((ItemStack)st, (ItemStack)comp, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        return Utils.stackMatchesObject(stack, o, false);
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o, boolean checkNBT) {
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false) && (!checkNBT || ((ItemStack)o).func_77952_i() == Short.MAX_VALUE || Utils.compareItemNBT((ItemStack)o, stack));
        }
        if (o instanceof Collection) {
            for (Object io : (Collection)o) {
                if (!(io instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)io), (ItemStack)stack, (boolean)false) || checkNBT && ((ItemStack)io).func_77952_i() != Short.MAX_VALUE && !Utils.compareItemNBT((ItemStack)io, stack)) continue;
                return true;
            }
        } else {
            if (o instanceof IngredientStack) {
                return ((IngredientStack)o).matchesItemStack(stack);
            }
            if (o instanceof ItemStack[]) {
                for (ItemStack io : (ItemStack[])o) {
                    if (!OreDictionary.itemMatches((ItemStack)io, (ItemStack)stack, (boolean)false) || checkNBT && io.func_77952_i() != Short.MAX_VALUE && !Utils.compareItemNBT(io, stack)) continue;
                    return true;
                }
            } else {
                if (o instanceof FluidStack) {
                    FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
                    return fs != null && fs.containsFluid((FluidStack)o);
                }
                if (o instanceof String) {
                    return Utils.compareToOreName(stack, (String)o);
                }
            }
        }
        return false;
    }

    public static boolean compareItemNBT(ItemStack stack1, ItemStack stack2) {
        boolean empty2;
        if (stack1.func_190926_b() != stack2.func_190926_b()) {
            return false;
        }
        boolean empty1 = stack1.func_77978_p() == null || stack1.func_77978_p().func_82582_d();
        boolean bl = empty2 = stack2.func_77978_p() == null || stack2.func_77978_p().func_82582_d();
        if (empty1 != empty2) {
            return false;
        }
        if (!empty1 && !stack1.func_77978_p().equals((Object)stack2.func_77978_p())) {
            return false;
        }
        return stack1.areCapsCompatible(stack2);
    }

    public static boolean canCombineArrays(ItemStack[] stacks, ItemStack[] target) {
        HashSet<IngredientStack> inputSet = new HashSet<IngredientStack>();
        for (ItemStack s : stacks) {
            inputSet.add(new IngredientStack(s));
        }
        for (ItemStack t : target) {
            int size = t.func_190916_E();
            Iterator it = inputSet.iterator();
            while (it.hasNext()) {
                IngredientStack in = (IngredientStack)it.next();
                if (!in.matchesItemStackIgnoringSize(t)) continue;
                int taken = Math.min(size, in.inputSize);
                size -= taken;
                in.inputSize -= taken;
                if (in.inputSize <= 0) {
                    it.remove();
                }
                if (size > 0) continue;
                break;
            }
            if (size <= 0) continue;
            return false;
        }
        return true;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack s2 = stack.func_77946_l();
        s2.func_190920_e(amount);
        return s2;
    }

    public static int getDye(ItemStack stack) {
        if (stack.func_190926_b()) {
            return -1;
        }
        if (stack.func_77973_b().equals(Items.field_151100_aR)) {
            return stack.func_77952_i();
        }
        for (int dye = 0; dye < dyeNames.length; ++dye) {
            if (!Utils.compareToOreName(stack, "dye" + dyeNames[dye])) continue;
            return dye;
        }
        return -1;
    }

    public static boolean isDye(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b().equals(Items.field_151100_aR)) {
            return true;
        }
        for (int dye = 0; dye < dyeNames.length; ++dye) {
            if (!Utils.compareToOreName(stack, "dye" + dyeNames[dye])) continue;
            return true;
        }
        return false;
    }

    public static FluidStack copyFluidStackWithAmount(FluidStack stack, int amount, boolean stripPressure) {
        if (stack == null) {
            return null;
        }
        FluidStack fs = new FluidStack(stack, amount);
        if (stripPressure && fs.tag != null && fs.tag.func_74764_b("pressurized")) {
            fs.tag.func_82580_o("pressurized");
            if (fs.tag.func_82582_d()) {
                fs.tag = null;
            }
        }
        return fs;
    }

    public static UUID generateNewUUID() {
        UUID uuid = new UUID(UUIDBase, UUIDAdd);
        ++UUIDAdd;
        return uuid;
    }

    public static BlockPos toCC(Object object) {
        return ApiUtils.toBlockPos(object);
    }

    public static DirectionalBlockPos toDirCC(Object object, EnumFacing direction) {
        if (object instanceof BlockPos) {
            return new DirectionalBlockPos((BlockPos)object, direction);
        }
        if (object instanceof TileEntity) {
            return new DirectionalBlockPos(((TileEntity)object).func_174877_v(), direction);
        }
        return null;
    }

    public static boolean isBlockAt(World world, BlockPos pos, Block b, int meta) {
        return Utils.blockstateMatches(world.func_180495_p(pos), b, meta);
    }

    public static boolean blockstateMatches(IBlockState state, Block b, int meta) {
        if (state.func_177230_c().equals(b)) {
            return meta < 0 || meta == Short.MAX_VALUE || state.func_177230_c().func_176201_c(state) == meta;
        }
        return false;
    }

    public static boolean isOreBlockAt(World world, BlockPos pos, String oreName) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        return Utils.compareToOreName(stack, oreName);
    }

    public static boolean canFenceConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing, Material material) {
        BlockPos other = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(other);
        Block block = world.func_180495_p(other).func_177230_c();
        if (block.canBeConnectedTo(world, other, facing.func_176734_d())) {
            return true;
        }
        BlockFaceShape blockfaceshape = state.func_193401_d(world, other, facing.func_176734_d());
        boolean flag = blockfaceshape == BlockFaceShape.MIDDLE_POLE && (state.func_185904_a() == material || block instanceof BlockFenceGate);
        return !Utils.isExceptBlockForAttachWithFence(block) && blockfaceshape == BlockFaceShape.SOLID || flag;
    }

    private static boolean isExceptionBlockForAttaching(Block block) {
        return block instanceof BlockShulkerBox || block instanceof BlockLeaves || block instanceof BlockTrapDoor || block == Blocks.field_150461_bJ || block == Blocks.field_150383_bp || block == Blocks.field_150359_w || block == Blocks.field_150426_aN || block == Blocks.field_150432_aD || block == Blocks.field_180398_cJ || block == Blocks.field_150399_cn;
    }

    private static boolean isExceptBlockForAttachWithPiston(Block block) {
        return Utils.isExceptionBlockForAttaching(block) || block == Blocks.field_150331_J || block == Blocks.field_150320_F || block == Blocks.field_150332_K;
    }

    private static boolean isExceptBlockForAttachWithFence(Block block) {
        return Utils.isExceptBlockForAttachWithPiston(block) || block == Blocks.field_180401_cv || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || block == Blocks.field_150428_aP;
    }

    public static String formatDouble(double d, String s) {
        DecimalFormat df = new DecimalFormat(s);
        return df.format(d);
    }

    public static String toScientificNotation(int value, String decimalPrecision, int useKilo) {
        float formatted;
        float f = value >= 1000000000 ? (float)value / 1.0E9f : (value >= 1000000 ? (float)value / 1000000.0f : (formatted = value >= useKilo ? (float)value / 1000.0f : (float)value));
        String notation = value >= 1000000000 ? "G" : (value >= 1000000 ? "M" : (value >= useKilo ? "K" : ""));
        return Utils.formatDouble(formatted, "0." + decimalPrecision) + notation;
    }

    public static String toCamelCase(String s) {
        return s.substring(0, 1).toUpperCase(Locale.ENGLISH) + s.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public static String getHarvestLevelName(int lvl) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            try {
                Class<?> clazz;
                if (m_getHarvestLevel == null && (clazz = Class.forName("tconstruct.library.util")) != null) {
                    m_getHarvestLevel = clazz.getDeclaredMethod("getHarvestLevelName", Integer.TYPE);
                }
                if (m_getHarvestLevel != null) {
                    return (String)m_getHarvestLevel.invoke(null, lvl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return I18n.func_135052_a((String)("desc.immersiveengineering.info.mininglvl." + Math.max(-1, Math.min(lvl, 6))), (Object[])new Object[0]);
    }

    public static String getModVersion(String modid) {
        for (ModContainer container : Loader.instance().getActiveModList()) {
            if (!container.getModId().equalsIgnoreCase(modid)) continue;
            return container.getVersion();
        }
        return "";
    }

    public static String getModName(String modid) {
        if (MODNAME_LOOKUP.containsKey(modid)) {
            return MODNAME_LOOKUP.get(modid);
        }
        ModContainer modContainer = (ModContainer)Loader.instance().getIndexedModList().get(modid);
        if (modContainer != null) {
            MODNAME_LOOKUP.put(modid, modContainer.getName());
            return modContainer.getName();
        }
        return "";
    }

    public static <T> int findSequenceInList(List<T> list, T[] sequence, BiPredicate<T, T> predicate) {
        if (list.size() <= 0 || list.size() < sequence.length) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!predicate.test(sequence[0], list.get(i))) continue;
            boolean found = true;
            for (int j = 1; j < sequence.length && (found = predicate.test(sequence[j], list.get(i + j))); ++j) {
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public static boolean tilePositionMatch(TileEntity tile0, TileEntity tile1) {
        return tile0.func_174877_v().equals((Object)tile1.func_174877_v());
    }

    public static EnumFacing rotateFacingTowardsDir(EnumFacing f, EnumFacing dir) {
        if (dir == EnumFacing.NORTH) {
            return f;
        }
        if (dir == EnumFacing.SOUTH && f.func_176740_k() != EnumFacing.Axis.Y) {
            return f.func_176746_e().func_176746_e();
        }
        if (dir == EnumFacing.WEST && f.func_176740_k() != EnumFacing.Axis.Y) {
            return f.func_176735_f();
        }
        if (dir == EnumFacing.EAST && f.func_176740_k() != EnumFacing.Axis.Y) {
            return f.func_176746_e();
        }
        if (dir == EnumFacing.DOWN && f.func_176740_k() != EnumFacing.Axis.Y) {
            return f.func_176732_a(EnumFacing.Axis.X);
        }
        if (dir == EnumFacing.UP && f.func_176740_k() != EnumFacing.Axis.X) {
            return f.func_176732_a(EnumFacing.Axis.X).func_176734_d();
        }
        return f;
    }

    public static RayTraceResult getMovingObjectPositionFromPlayer(World world, EntityLivingBase living, boolean bool) {
        float f = 1.0f;
        float f1 = living.field_70127_C + (living.field_70125_A - living.field_70127_C) * f;
        float f2 = living.field_70126_B + (living.field_70177_z - living.field_70126_B) * f;
        double d0 = living.field_70169_q + (living.field_70165_t - living.field_70169_q) * (double)f;
        double d1 = living.field_70167_r + (living.field_70163_u - living.field_70167_r) * (double)f + (double)(world.field_72995_K ? living.func_70047_e() - (living instanceof EntityPlayer ? ((EntityPlayer)living).getDefaultEyeHeight() : 0.0f) : living.func_70047_e());
        double d2 = living.field_70166_s + (living.field_70161_v - living.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (living instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)living).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, bool, !bool, false);
    }

    public static boolean canBlocksSeeOther(World world, BlockPos cc0, BlockPos cc1, Vec3d pos0, Vec3d pos1) {
        HashSet<BlockPos> inter = Utils.rayTrace(pos0, pos1, world);
        for (BlockPos cc : inter) {
            if (cc.equals((Object)cc0) || cc.equals((Object)cc1)) continue;
            return false;
        }
        return true;
    }

    public static Vec3d getLivingFrontPos(EntityLivingBase entity, double offset, double height, EnumHandSide hand, boolean useSteppedYaw, float partialTicks) {
        double offsetX = hand == EnumHandSide.LEFT ? -0.3125 : (hand == EnumHandSide.RIGHT ? 0.3125 : 0.0);
        float yaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
        if (useSteppedYaw) {
            yaw = entity.field_70760_ar + (entity.field_70761_aq - entity.field_70760_ar) * partialTicks;
        }
        float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
        float yawCos = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawSin = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchCos = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float pitchSin = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d(entity.field_70165_t + offsetX * (double)yawCos + offset * (double)pitchCos * (double)yawSin, entity.field_70163_u + offset * (double)pitchSin + height, entity.field_70161_v + offset * (double)pitchCos * (double)yawCos - offsetX * (double)yawSin);
    }

    public static List<EntityLivingBase> getTargetsInCone(World world, Vec3d start, Vec3d dir, float spreadAngle, float truncationLength) {
        double length = dir.func_72433_c();
        Vec3d dirNorm = dir.func_72432_b();
        double radius = Math.tan(spreadAngle / 2.0f) * length;
        Vec3d endLow = start.func_178787_e(dir).func_178786_a(radius, radius, radius);
        Vec3d endHigh = start.func_178787_e(dir).func_72441_c(radius, radius, radius);
        AxisAlignedBB box = new AxisAlignedBB(Utils.minInArray(start.field_72450_a, endLow.field_72450_a, endHigh.field_72450_a), Utils.minInArray(start.field_72448_b, endLow.field_72448_b, endHigh.field_72448_b), Utils.minInArray(start.field_72449_c, endLow.field_72449_c, endHigh.field_72449_c), Utils.maxInArray(start.field_72450_a, endLow.field_72450_a, endHigh.field_72450_a), Utils.maxInArray(start.field_72448_b, endLow.field_72448_b, endHigh.field_72448_b), Utils.maxInArray(start.field_72449_c, endLow.field_72449_c, endHigh.field_72449_c));
        List list = world.func_72872_a(EntityLivingBase.class, box);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EntityLivingBase e = (EntityLivingBase)iterator.next();
            if (Utils.isPointInCone(start, dirNorm, radius, length, truncationLength, e.func_174791_d().func_178788_d(start))) continue;
            iterator.remove();
        }
        return list;
    }

    public static boolean isPointInConeByAngle(Vec3d start, Vec3d normDirection, double aperture, double length, Vec3d relativePoint) {
        return Utils.isPointInCone(start, normDirection, Math.tan(aperture / 2.0) * length, length, 0.0f, relativePoint);
    }

    public static boolean isPointInCone(Vec3d start, Vec3d normDirection, double radius, double length, Vec3d relativePoint) {
        return Utils.isPointInCone(start, normDirection, radius, length, 0.0f, relativePoint);
    }

    public static boolean isPointInConeByAngle(Vec3d start, Vec3d normDirection, float aperture, double length, float truncationLength, Vec3d relativePoint) {
        return Utils.isPointInCone(start, normDirection, Math.tan(aperture / 2.0f) * length, length, truncationLength, relativePoint);
    }

    public static boolean isPointInCone(Vec3d start, Vec3d normDirection, double radius, double length, float truncationLength, Vec3d relativePoint) {
        double projectedDist = relativePoint.func_72430_b(normDirection);
        if (projectedDist < (double)truncationLength || projectedDist > length) {
            return false;
        }
        double radiusAtDist = projectedDist / length * radius;
        Vec3d orthVec = relativePoint.func_178788_d(normDirection.func_186678_a(projectedDist));
        return orthVec.func_189985_c() < radiusAtDist * radiusAtDist;
    }

    public static boolean isPointInTriangle(Vec3d tA, Vec3d tB, Vec3d tC, Vec3d point) {
        Vec3d v0 = tC.func_178788_d(tA);
        Vec3d v1 = tB.func_178788_d(tA);
        Vec3d v2 = point.func_178788_d(tA);
        return Utils.isPointInTriangle(v0, v1, v2);
    }

    private static boolean isPointInTriangle(Vec3d leg0, Vec3d leg1, Vec3d targetVec) {
        double dot00 = leg0.func_72430_b(leg0);
        double dot01 = leg0.func_72430_b(leg1);
        double dot02 = leg0.func_72430_b(targetVec);
        double dot11 = leg1.func_72430_b(leg1);
        double dot12 = leg1.func_72430_b(targetVec);
        double invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        double v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u >= 0.0 && v >= 0.0 && u + v < 1.0;
    }

    private static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static void attractEnemies(EntityLivingBase target, float radius) {
        Utils.attractEnemies(target, radius, null);
    }

    public static void attractEnemies(EntityLivingBase target, float radius, Predicate<EntityMob> predicate) {
        AxisAlignedBB aabb = new AxisAlignedBB(target.field_70165_t - (double)radius, target.field_70163_u - (double)radius, target.field_70161_v - (double)radius, target.field_70165_t + (double)radius, target.field_70163_u + (double)radius, target.field_70161_v + (double)radius);
        List list = target.func_130014_f_().func_72872_a(EntityMob.class, aabb);
        for (EntityMob mob : list) {
            if (predicate != null && !predicate.test(mob)) continue;
            mob.func_70624_b(target);
            mob.func_70625_a((Entity)target, 180.0f, 0.0f);
        }
    }

    public static boolean isHammer(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("IE_HAMMER");
    }

    public static boolean isWirecutter(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("IE_WIRECUTTER");
    }

    public static boolean canBlockDamageSource(EntityLivingBase entity, DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && entity.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(entity.func_174791_d()).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            return vec3d2.func_72430_b(vec3d1) < 0.0;
        }
        return false;
    }

    public static Vec3d getFlowVector(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockFluidBase) {
            return ((BlockFluidBase)state.func_177230_c()).getFlowVector((IBlockAccess)world, pos);
        }
        if (!(state.func_177230_c() instanceof BlockLiquid)) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        BlockLiquid block = (BlockLiquid)state.func_177230_c();
        Vec3d vec3 = new Vec3d(0.0, 0.0, 0.0);
        Material mat = state.func_185904_a();
        int i = Utils.getEffectiveFlowDecay((IBlockAccess)world, pos, mat);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            int j = Utils.getEffectiveFlowDecay((IBlockAccess)world, blockpos, mat);
            if (j < 0) {
                if (world.func_180495_p(blockpos).func_185904_a().func_76230_c() || (j = Utils.getEffectiveFlowDecay((IBlockAccess)world, blockpos.func_177977_b(), mat)) < 0) continue;
                int k = j - (i - 8);
                vec3 = vec3.func_72441_c((double)((blockpos.func_177958_n() - pos.func_177958_n()) * k), (double)((blockpos.func_177956_o() - pos.func_177956_o()) * k), (double)((blockpos.func_177952_p() - pos.func_177952_p()) * k));
                continue;
            }
            if (j < 0) continue;
            int l = j - i;
            vec3 = vec3.func_72441_c((double)((blockpos.func_177958_n() - pos.func_177958_n()) * l), (double)((blockpos.func_177956_o() - pos.func_177956_o()) * l), (double)((blockpos.func_177952_p() - pos.func_177952_p()) * l));
        }
        if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) >= 8) {
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos1 = pos.func_177972_a(enumfacing1);
                if (!block.func_176212_b((IBlockAccess)world, blockpos1, enumfacing1) && !block.func_176212_b((IBlockAccess)world, blockpos1.func_177984_a(), enumfacing1)) continue;
                vec3 = vec3.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
                break;
            }
        }
        return vec3.func_72432_b();
    }

    static int getEffectiveFlowDecay(IBlockAccess world, BlockPos pos, Material mat) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a() != mat) {
            return -1;
        }
        int l = state.func_177230_c().func_176201_c(state);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    public static Vec3d addVectors(Vec3d vec0, Vec3d vec1) {
        return vec0.func_72441_c(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c);
    }

    public static double minInArray(double ... f) {
        if (f.length < 1) {
            return 0.0;
        }
        double min = f[0];
        for (int i = 1; i < f.length; ++i) {
            min = Math.min(min, f[i]);
        }
        return min;
    }

    public static double maxInArray(double ... f) {
        if (f.length < 1) {
            return 0.0;
        }
        double max = f[0];
        for (int i = 1; i < f.length; ++i) {
            max = Math.max(max, f[i]);
        }
        return max;
    }

    public static boolean isVecInEntityHead(EntityLivingBase entity, Vec3d vec) {
        if (entity.field_70131_O / entity.field_70130_N < 2.0f) {
            return false;
        }
        double d = vec.field_72448_b - (entity.field_70163_u + (double)entity.func_70047_e());
        return Math.abs(d) < 0.25;
    }

    public static void unlockIEAdvancement(EntityPlayer player, String name) {
        if (player instanceof EntityPlayerMP) {
            PlayerAdvancements advancements = ((EntityPlayerMP)player).func_192039_O();
            AdvancementManager manager = ((WorldServer)player.func_130014_f_()).func_191952_z();
            Advancement advancement = manager.func_192778_a(new ResourceLocation("immersiveengineering", name));
            if (advancement != null) {
                advancements.func_192750_a(advancement, "code_trigger");
            }
        }
    }

    public static NBTTagCompound getRandomFireworkExplosion(Random rand, int preType) {
        int type;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound expl = new NBTTagCompound();
        expl.func_74757_a("Flicker", true);
        expl.func_74757_a("Trail", true);
        int[] colors = new int[rand.nextInt(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            int j = rand.nextInt(11) + 1;
            if (j > 2) {
                ++j;
            }
            if (j > 6) {
                j += 2;
            }
            colors[i] = ItemDye.field_150922_c[j];
        }
        expl.func_74783_a("Colors", colors);
        int n = type = preType >= 0 ? preType : rand.nextInt(4);
        if (preType < 0 && type == 3) {
            type = 4;
        }
        expl.func_74774_a("Type", (byte)type);
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)expl);
        tag.func_74782_a("Explosions", (NBTBase)list);
        return tag;
    }

    public static FluidStack drainFluidBlock(World world, BlockPos pos, boolean doDrain) {
        Block b = world.func_180495_p(pos).func_177230_c();
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)b);
        if (f != null) {
            if (b instanceof IFluidBlock) {
                if (((IFluidBlock)b).canDrain(world, pos)) {
                    return ((IFluidBlock)b).drain(world, pos, doDrain);
                }
                return null;
            }
            if (b.func_176201_c(world.func_180495_p(pos)) == 0) {
                if (doDrain) {
                    world.func_175698_g(pos);
                }
                return new FluidStack(f, 1000);
            }
            return null;
        }
        return null;
    }

    public static Fluid getRelatedFluid(World w, BlockPos pos) {
        Block b = w.func_180495_p(pos).func_177230_c();
        return FluidRegistry.lookupFluidForBlock((Block)b);
    }

    public static boolean placeFluidBlock(World world, BlockPos pos, FluidStack fluid) {
        boolean canPlace;
        if (fluid == null || fluid.getFluid() == null) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        Block fluidBlock = fluid.getFluid().getBlock();
        if (Blocks.field_150355_j.equals(fluidBlock)) {
            fluidBlock = Blocks.field_150358_i;
        } else if (Blocks.field_150353_l.equals(fluidBlock)) {
            fluidBlock = Blocks.field_150356_k;
        }
        boolean bl = canPlace = b == null || b.isAir(state, (IBlockAccess)world, pos) || b.func_176200_f((IBlockAccess)world, pos);
        if (fluidBlock != null && canPlace && fluid.amount >= 1000) {
            boolean placed = false;
            if (fluidBlock instanceof BlockFluidBase) {
                BlockFluidBase blockFluid = (BlockFluidBase)fluidBlock;
                placed = world.func_175656_a(pos, fluidBlock.func_176203_a(blockFluid.getMaxRenderHeightMeta()));
            } else {
                placed = world.func_175656_a(pos, fluidBlock.func_176223_P());
            }
            if (placed) {
                fluid.amount -= 1000;
            }
            return placed;
        }
        return false;
    }

    public static IBlockState getStateFromItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        Block block = Utils.getBlockFromItem(stack.func_77973_b());
        if (block != null) {
            return block.func_176203_a(stack.func_77952_i());
        }
        return null;
    }

    public static Block getBlockFromItem(Item item) {
        if (item == Items.field_151066_bu) {
            return Blocks.field_150383_bp;
        }
        return Block.func_149634_a((Item)item);
    }

    public static boolean canInsertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side) {
        if (!stack.func_190926_b() && inventory != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)true);
            return temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E();
        }
        return false;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side) {
        IItemHandler handler;
        ItemStack temp;
        if (!stack.func_190926_b() && inventory != null && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) && ((temp = ItemHandlerHelper.insertItem((IItemHandler)(handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)), (ItemStack)stack.func_77946_l(), (boolean)true)).func_190926_b() || temp.func_190916_E() < stack.func_190916_E())) {
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, EnumFacing side, boolean simulate) {
        if (inventory != null && !stack.func_190926_b() && inventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler handler = (IItemHandler)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)simulate);
        }
        return stack;
    }

    public static void dropStackAtPos(World world, BlockPos pos, ItemStack stack, EnumFacing facing) {
        if (!stack.func_190926_b()) {
            EntityItem ei = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack.func_77946_l());
            ei.field_70181_x = 0.025000000372529;
            if (facing != null) {
                ei.field_70159_w = 0.075f * (float)facing.func_82601_c();
                ei.field_70179_y = 0.075f * (float)facing.func_82599_e();
            }
            world.func_72838_d((Entity)ei);
        }
    }

    public static void dropStackAtPos(World world, BlockPos pos, ItemStack stack) {
        Utils.dropStackAtPos(world, pos, stack, null);
    }

    public static ItemStack addToEmptyInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.func_70297_j_();
        inventory.func_70299_a(slot, Utils.copyStackWithAmount(stack, Math.min(stack.func_190916_E(), stackLimit)));
        return stackLimit >= stack.func_190916_E() ? ItemStack.field_190927_a : stack.func_77979_a(stack.func_190916_E() - stackLimit);
    }

    public static ItemStack addToOccupiedSlot(IInventory inventory, int slot, ItemStack stack, ItemStack existingStack) {
        int stackLimit = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        if (stack.func_190916_E() + existingStack.func_190916_E() > stackLimit) {
            int stackDiff = stackLimit - existingStack.func_190916_E();
            existingStack.func_190920_e(stackLimit);
            stack.func_190918_g(stackDiff);
            inventory.func_70299_a(slot, existingStack);
            return stack;
        }
        existingStack.func_190917_f(Math.min(stack.func_190916_E(), stackLimit));
        inventory.func_70299_a(slot, existingStack);
        return stackLimit >= stack.func_190916_E() ? ItemStack.field_190927_a : stack.func_77979_a(stack.func_190916_E() - stackLimit);
    }

    public static ItemStack fillFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut, @Nullable EntityPlayer player) {
        FluidActionResult result;
        if (containerIn == null || containerIn.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (containerIn.func_77942_o() && containerIn.func_77978_p().func_82582_d()) {
            containerIn.func_77982_d(null);
        }
        if ((result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)false)).isSuccess()) {
            ItemStack full = result.getResult();
            if (containerOut.func_190926_b() || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)full, (boolean)true)) {
                if (!containerOut.func_190926_b() && containerOut.func_190916_E() + full.func_190916_E() > containerOut.func_77976_d()) {
                    return ItemStack.field_190927_a;
                }
                result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack drainFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut, @Nullable EntityPlayer player) {
        FluidActionResult result;
        if (containerIn == null || containerIn.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (containerIn.func_77942_o() && containerIn.func_77978_p().func_82582_d()) {
            containerIn.func_77982_d(null);
        }
        if ((result = FluidUtil.tryEmptyContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)false)).isSuccess()) {
            ItemStack empty = result.getResult();
            if (containerOut.func_190926_b() || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)empty, (boolean)true)) {
                if (!containerOut.func_190926_b() && containerOut.func_190916_E() + empty.func_190916_E() > containerOut.func_77976_d()) {
                    return ItemStack.field_190927_a;
                }
                result = FluidUtil.tryEmptyContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (EntityPlayer)player, (boolean)true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isFluidContainerFull(ItemStack stack) {
        IFluidTankProperties[] tank;
        if (stack.func_190926_b()) {
            return false;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
        if (handler == null) {
            return false;
        }
        for (IFluidTankProperties prop : tank = handler.getTankProperties()) {
            if (prop.getContents() != null && prop.getContents().amount >= prop.getCapacity()) continue;
            return false;
        }
        return true;
    }

    public static boolean isFluidRelatedItemStack(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
    }

    public static IRecipe findRecipe(InventoryCrafting crafting, World world) {
        return CraftingManager.func_192413_b((InventoryCrafting)crafting, (World)world);
    }

    public static NonNullList<ItemStack> createNonNullItemStackListFromArray(ItemStack[] stacks) {
        NonNullList list = NonNullList.func_191197_a((int)stacks.length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < stacks.length; ++i) {
            list.set(i, (Object)stacks[i]);
        }
        return list;
    }

    public static NonNullList<ItemStack> createNonNullItemStackListFromItemStack(ItemStack stack) {
        NonNullList list = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        list.set(0, (Object)stack);
        return list;
    }

    public static float[] rotateToFacing(float[] in, EnumFacing facing) {
        int i;
        int i2 = 0;
        while (i2 < in.length) {
            int n = i2++;
            in[n] = in[n] - 0.5f;
        }
        float[] ret = new float[in.length];
        for (i = 0; i < in.length; i += 3) {
            for (int j = 0; j < 3; ++j) {
                ret[i + j] = j == 0 ? in[i + 0] * (float)facing.func_82599_e() + in[i + 1] * (float)facing.func_82601_c() + in[i + 2] * (float)facing.func_96559_d() : (j == 1 ? in[i + 0] * (float)facing.func_82601_c() + in[i + 1] * (float)facing.func_96559_d() + in[i + 2] * (float)facing.func_82599_e() : in[i + 0] * (float)facing.func_96559_d() + in[i + 1] * (float)facing.func_82599_e() + in[i + 2] * (float)facing.func_82601_c());
            }
        }
        i = 0;
        while (i < in.length) {
            int n = i++;
            ret[n] = (float)((double)ret[n] + 0.5);
        }
        return ret;
    }

    public static int hashBlockstate(IBlockState state, Set<Object> ignoredProperties, boolean includeExtended) {
        int val = 0;
        int prime = 31;
        for (IProperty n : state.func_177227_a()) {
            if (ignoredProperties.contains(n)) continue;
            Comparable o = state.func_177229_b(n);
            val = 31 * val + (o == null ? 0 : o.hashCode());
        }
        if (includeExtended && state instanceof IExtendedBlockState) {
            IExtendedBlockState ext = (IExtendedBlockState)state;
            for (IUnlistedProperty n : ext.getUnlistedNames()) {
                if (ignoredProperties.contains(n)) continue;
                Object o = ext.getValue(n);
                val = 31 * val + (o == null ? 0 : o.hashCode());
            }
        }
        return val;
    }

    public static boolean areStatesEqual(IBlockState state, IBlockState other, Set<Object> ignoredProperties, boolean includeExtended) {
        for (IProperty i : state.func_177227_a()) {
            if (!other.func_177228_b().containsKey((Object)i)) {
                return false;
            }
            if (ignoredProperties.contains(i)) continue;
            Comparable valThis = state.func_177229_b(i);
            Comparable valOther = other.func_177229_b(i);
            if (valThis == null && valOther == null || valOther != null && valOther.equals(state.func_177229_b(i))) continue;
            return false;
        }
        if (includeExtended) {
            if (state instanceof IExtendedBlockState ^ other instanceof IExtendedBlockState) {
                return false;
            }
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState extState = (IExtendedBlockState)state;
                IExtendedBlockState extOther = (IExtendedBlockState)other;
                for (IUnlistedProperty i : extState.getUnlistedNames()) {
                    if (!extOther.getUnlistedProperties().containsKey((Object)i)) {
                        return false;
                    }
                    if (ignoredProperties.contains(i)) continue;
                    Object valThis = extState.getValue(i);
                    Object valOther = extOther.getValue(i);
                    if (valThis == null && valOther == null || valOther != null && valOther.equals(valThis)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean areArraysEqualIncludingBlockstates(Object[] a, Object[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object o1 = a[i];
            Object o2 = a2[i];
            if (!(o1 instanceof IBlockState && o2 instanceof IBlockState ? !Utils.areStatesEqual((IBlockState)o1, (IBlockState)o2, (Set<Object>)ImmutableSet.of(), false) : !(o1 != null ? o1.equals(o2) : o2 == null))) continue;
            return false;
        }
        return true;
    }

    public static double getCoeffForMinDistance(Vec3d point, Vec3d line, Vec3d across) {
        if (across.field_72450_a == 0.0 && across.field_72449_c == 0.0) {
            return (point.field_72448_b - line.field_72448_b) / across.field_72448_b;
        }
        Vec3d delta = point.func_178788_d(line);
        return delta.func_72430_b(across) / across.func_189985_c();
    }

    public static boolean isVecInBlock(Vec3d vec3d, BlockPos pos, BlockPos offset) {
        return vec3d.field_72450_a >= (double)(pos.func_177958_n() - offset.func_177958_n()) && vec3d.field_72450_a <= (double)(pos.func_177958_n() - offset.func_177958_n() + 1) && vec3d.field_72448_b >= (double)(pos.func_177956_o() - offset.func_177956_o()) && vec3d.field_72448_b <= (double)(pos.func_177956_o() - offset.func_177956_o() + 1) && vec3d.field_72449_c >= (double)(pos.func_177952_p() - offset.func_177952_p()) && vec3d.field_72449_c <= (double)(pos.func_177952_p() - offset.func_177952_p() + 1);
    }

    public static HashSet<BlockPos> rayTrace(Vec3d start, Vec3d end, World world) {
        return Utils.rayTrace(start, end, world, p -> {});
    }

    public static HashSet<BlockPos> rayTrace(Vec3d start, Vec3d end, World world, Consumer<BlockPos> out) {
        Vec3d tmp;
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        if (start.field_72450_a > end.field_72450_a) {
            Vec3d tmp2 = start;
            start = end;
            end = tmp2;
        }
        double min = start.field_72450_a;
        double dif = end.field_72450_a - min;
        double lengthAdd = Math.ceil(min) - start.field_72450_a;
        Vec3d mov = start.func_178788_d(end);
        if (mov.field_72450_a != 0.0) {
            mov = Utils.scalarProd(mov, 1.0 / mov.field_72450_a);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, out);
        }
        if (mov.field_72448_b != 0.0) {
            if (start.field_72448_b > end.field_72448_b) {
                tmp = start;
                start = end;
                end = tmp;
            }
            min = start.field_72448_b;
            dif = end.field_72448_b - min;
            lengthAdd = Math.ceil(min) - start.field_72448_b;
            mov = start.func_178788_d(end);
            mov = Utils.scalarProd(mov, 1.0 / mov.field_72448_b);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, out);
        }
        if (mov.field_72449_c != 0.0) {
            if (start.field_72449_c > end.field_72449_c) {
                tmp = start;
                start = end;
                end = tmp;
            }
            min = start.field_72449_c;
            dif = end.field_72449_c - min;
            lengthAdd = Math.ceil(min) - start.field_72449_c;
            mov = start.func_178788_d(end);
            mov = Utils.scalarProd(mov, 1.0 / mov.field_72449_c);
            Utils.ray(dif, mov, start, lengthAdd, ret, world, checked, out);
        }
        if (checked.isEmpty()) {
            BlockPos pos = new BlockPos(start);
            IBlockState state = world.func_180495_p(pos);
            Block b = state.func_177230_c();
            if (b.func_176209_a(state, false) && state.func_185910_a(world, pos, start, end) != null) {
                ret.add(pos);
            }
            checked.add(pos);
            out.accept(pos);
        }
        return ret;
    }

    private static void ray(double dif, Vec3d mov, Vec3d start, double lengthAdd, HashSet<BlockPos> ret, World world, HashSet<BlockPos> checked, Consumer<BlockPos> out) {
        boolean place = false;
        double standartOff = 0.0625;
        int i = 0;
        while ((double)i < dif) {
            Block b;
            IBlockState state;
            Vec3d pos = Utils.addVectors(start, Utils.scalarProd(mov, (double)i + lengthAdd + standartOff));
            Vec3d posNext = Utils.addVectors(start, Utils.scalarProd(mov, (double)(i + 1) + lengthAdd + standartOff));
            Vec3d posPrev = Utils.addVectors(start, Utils.scalarProd(mov, (double)i + lengthAdd - standartOff));
            Vec3d posVeryPrev = Utils.addVectors(start, Utils.scalarProd(mov, (double)(i - 1) + lengthAdd - standartOff));
            BlockPos blockPos = new BlockPos((int)Math.floor(pos.field_72450_a), (int)Math.floor(pos.field_72448_b), (int)Math.floor(pos.field_72449_c));
            if (!checked.contains(blockPos) && (double)i + lengthAdd + standartOff < dif) {
                state = world.func_180495_p(blockPos);
                b = state.func_177230_c();
                if (b.func_176209_a(state, false) && state.func_185910_a(world, blockPos, pos, posNext) != null) {
                    ret.add(blockPos);
                }
                checked.add(blockPos);
                out.accept(blockPos);
            }
            if (!checked.contains(blockPos = new BlockPos((int)Math.floor(posPrev.field_72450_a), (int)Math.floor(posPrev.field_72448_b), (int)Math.floor(posPrev.field_72449_c))) && (double)i + lengthAdd - standartOff < dif) {
                state = world.func_180495_p(blockPos);
                b = state.func_177230_c();
                if (b.func_176209_a(state, false) && state.func_185910_a(world, blockPos, posVeryPrev, posPrev) != null) {
                    ret.add(blockPos);
                }
                checked.add(blockPos);
                out.accept(blockPos);
            }
            ++i;
        }
    }

    public static Vec3d scalarProd(Vec3d v, double s) {
        return new Vec3d(v.field_72450_a * s, v.field_72448_b * s, v.field_72449_c * s);
    }

    public static BlockPos rayTraceForFirst(Vec3d start, Vec3d end, World w, Set<BlockPos> ignore) {
        HashSet<BlockPos> trace = Utils.rayTrace(start, end, w);
        for (BlockPos cc : ignore) {
            trace.remove(cc);
        }
        if (start.field_72450_a != end.field_72450_a) {
            trace = Utils.findMinOrMax(trace, start.field_72450_a > end.field_72450_a, 0);
        }
        if (start.field_72448_b != end.field_72448_b) {
            trace = Utils.findMinOrMax(trace, start.field_72448_b > end.field_72448_b, 0);
        }
        if (start.field_72449_c != end.field_72449_c) {
            trace = Utils.findMinOrMax(trace, start.field_72449_c > end.field_72449_c, 0);
        }
        if (trace.size() > 0) {
            BlockPos ret = trace.iterator().next();
            return ret;
        }
        return null;
    }

    public static HashSet<BlockPos> findMinOrMax(HashSet<BlockPos> in, boolean max, int coord) {
        int curr;
        HashSet<BlockPos> ret = new HashSet<BlockPos>();
        int currMinMax = max ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.func_177958_n() : (coord == 1 ? cc.func_177956_o() : cc.func_177956_o());
            if (!(max ^ curr < currMinMax)) continue;
            currMinMax = curr;
        }
        for (BlockPos cc : in) {
            curr = coord == 0 ? cc.func_177958_n() : (coord == 1 ? cc.func_177956_o() : cc.func_177952_p());
            if (curr != currMinMax) continue;
            ret.add(cc);
        }
        return ret;
    }

    public static TileEntity getExistingTileEntity(World world, BlockPos pos) {
        if (world.func_175667_e(pos)) {
            return world.func_175625_s(pos);
        }
        return null;
    }

    public static NonNullList<ItemStack> readInventory(NBTTagList nbt, int size) {
        NonNullList inv = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        int max = nbt.func_74745_c();
        for (int i = 0; i < max; ++i) {
            NBTTagCompound itemTag = nbt.func_150305_b(i);
            int slot = itemTag.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= size) continue;
            inv.set(slot, (Object)new ItemStack(itemTag));
        }
        return inv;
    }

    public static NBTTagList writeInventory(ItemStack[] inv) {
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < inv.length; ++i) {
            if (inv[i].func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            inv[i].func_77955_b(itemTag);
            invList.func_74742_a((NBTBase)itemTag);
        }
        return invList;
    }

    public static NBTTagList writeInventory(Collection<ItemStack> inv) {
        NBTTagList invList = new NBTTagList();
        byte slot = 0;
        for (ItemStack s : inv) {
            if (!s.func_190926_b()) {
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", slot);
                s.func_77955_b(itemTag);
                invList.func_74742_a((NBTBase)itemTag);
            }
            slot = (byte)(slot + 1);
        }
        return invList;
    }

    public static NonNullList<ItemStack> loadItemStacksFromNBT(NBTBase nbt) {
        NonNullList itemStacks = NonNullList.func_191196_a();
        if (nbt instanceof NBTTagCompound) {
            ItemStack stack = new ItemStack((NBTTagCompound)nbt);
            itemStacks.add((Object)stack);
            return itemStacks;
        }
        if (nbt instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)nbt;
            return Utils.readInventory(list, list.func_74745_c());
        }
        return itemStacks;
    }

    public static void modifyInvStackSize(NonNullList<ItemStack> inv, int slot, int amount) {
        if (slot >= 0 && slot < inv.size() && !((ItemStack)inv.get(slot)).func_190926_b()) {
            ((ItemStack)inv.get(slot)).func_190917_f(amount);
            if (((ItemStack)inv.get(slot)).func_190916_E() <= 0) {
                inv.set(slot, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public static void shuffleLootItems(List<ItemStack> stacks, int slotAmount, Random rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.func_190916_E() <= 0) {
                iterator.remove();
                continue;
            }
            if (itemstack.func_190916_E() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        slotAmount -= stacks.size();
        while (slotAmount > 0 && list.size() > 0) {
            ItemStack itemstack2 = (ItemStack)list.remove(MathHelper.func_76136_a((Random)rand, (int)0, (int)(list.size() - 1)));
            int i = MathHelper.func_76136_a((Random)rand, (int)1, (int)(itemstack2.func_190916_E() / 2));
            itemstack2.func_190918_g(i);
            ItemStack itemstack1 = itemstack2.func_77946_l();
            itemstack1.func_190920_e(i);
            if (itemstack2.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.func_190916_E() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, rand);
    }

    public static LootTable loadBuiltinLootTable(ResourceLocation resource, LootTableManager lootTableManager) {
        String s;
        URL url = Utils.class.getResource("/assets/" + resource.func_110624_b() + "/loot_tables/" + resource.func_110623_a() + ".json");
        if (url == null) {
            return LootTable.field_186464_a;
        }
        try {
            s = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            return LootTable.field_186464_a;
        }
        try {
            return ForgeHooks.loadLootTable((Gson)GSON_INSTANCE, (ResourceLocation)resource, (String)s, (boolean)false, (LootTableManager)lootTableManager);
        }
        catch (JsonParseException jsonparseexception) {
            jsonparseexception.printStackTrace();
            return LootTable.field_186464_a;
        }
    }

    public static int calcRedstoneFromInventory(IIEInventory inv) {
        if (inv == null) {
            return 0;
        }
        int max = inv.getComparatedSize();
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < max; ++j) {
            ItemStack itemstack = (ItemStack)inv.getInventory().get(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(inv.getSlotLimit(j), itemstack.func_77976_d());
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)max) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static Map<String, Object> saveStack(ItemStack stack) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (!stack.func_190926_b()) {
            ret.put("size", stack.func_190916_E());
            ret.put("name", Item.field_150901_e.func_177774_c((Object)stack.func_77973_b()));
            ret.put("nameUnlocalized", stack.func_77977_a());
            ret.put("label", stack.func_82833_r());
            ret.put("damage", stack.func_77952_i());
            ret.put("maxDamage", stack.func_77958_k());
            ret.put("maxSize", stack.func_77976_d());
            ret.put("hasTag", stack.func_77942_o());
        }
        return ret;
    }

    public static Map<String, Object> saveFluidTank(FluidTank tank) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (tank != null && tank.getFluid() != null) {
            ret.put("name", tank.getFluid().getFluid().getUnlocalizedName());
            ret.put("amount", tank.getFluidAmount());
            ret.put("capacity", tank.getCapacity());
            ret.put("hasTag", tank.getFluid().tag != null);
        }
        return ret;
    }

    public static Map<String, Object> saveFluidStack(FluidStack tank) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (tank != null && tank.getFluid() != null) {
            ret.put("name", tank.getFluid().getUnlocalizedName());
            ret.put("amount", tank.amount);
            ret.put("hasTag", tank.tag != null);
        }
        return ret;
    }

    public static void stateToNBT(NBTTagCompound out, IBlockState state) {
        out.func_74778_a("block", state.func_177230_c().getRegistryName().toString());
        for (IProperty prop : state.func_177227_a()) {
            Utils.saveProp(state, prop, out);
        }
    }

    public static IBlockState stateFromNBT(NBTTagCompound in) {
        Block b = Block.func_149684_b((String)in.func_74779_i("block"));
        if (b == null) {
            return Blocks.field_150342_X.func_176223_P();
        }
        IBlockState ret = b.func_176223_P();
        for (IProperty prop : ret.func_177227_a()) {
            String name = prop.func_177701_a();
            if (!in.func_150297_b(name, 8)) continue;
            ret = Utils.setProp(ret, prop, in.func_74779_i(name));
        }
        return ret;
    }

    public static NonNullList<ItemStack> getDrops(IBlockState state) {
        IBlockAccess w = Utils.getSingleBlockWorldAccess(state);
        NonNullList ret = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(ret, w, BlockPos.field_177992_a, state, 0);
        return ret;
    }

    private static <T extends Comparable<T>> void saveProp(IBlockState state, IProperty<T> prop, NBTTagCompound out) {
        out.func_74778_a(prop.func_177701_a(), prop.func_177702_a(state.func_177229_b(prop)));
    }

    private static <T extends Comparable<T>> IBlockState setProp(IBlockState state, IProperty<T> prop, String value) {
        Optional valueParsed = prop.func_185929_b(value);
        if (valueParsed.isPresent()) {
            return state.func_177226_a(prop, (Comparable)valueParsed.get());
        }
        return state;
    }

    public static AxisAlignedBB transformAABB(AxisAlignedBB original, EnumFacing facing) {
        double minX = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxZ = 0.0;
        EnumFacing right = facing.func_176746_e();
        switch (facing) {
            case NORTH: {
                minZ = original.field_72339_c;
                maxZ = original.field_72334_f;
                break;
            }
            case SOUTH: {
                minZ = 1.0 - original.field_72339_c;
                maxZ = 1.0 - original.field_72334_f;
                break;
            }
            case WEST: {
                minX = original.field_72339_c;
                maxX = original.field_72334_f;
                break;
            }
            case EAST: {
                minX = 1.0 - original.field_72339_c;
                maxX = 1.0 - original.field_72334_f;
            }
        }
        switch (right) {
            case EAST: {
                minX = original.field_72340_a;
                maxX = original.field_72336_d;
                break;
            }
            case WEST: {
                minX = 1.0 - original.field_72340_a;
                maxX = 1.0 - original.field_72336_d;
                break;
            }
            case SOUTH: {
                minZ = 1.0 - original.field_72340_a;
                maxZ = 1.0 - original.field_72336_d;
                break;
            }
            case NORTH: {
                minZ = original.field_72340_a;
                maxZ = original.field_72336_d;
            }
        }
        return new AxisAlignedBB(minX, original.field_72338_b, minZ, maxX, original.field_72337_e, maxZ);
    }

    public static IBlockAccess getSingleBlockWorldAccess(IBlockState state) {
        return new SingleBlockAcess(state);
    }

    private static class SingleBlockAcess
    implements IBlockAccess {
        IBlockState state;

        public SingleBlockAcess(IBlockState state) {
            this.state = state;
        }

        @Nullable
        public TileEntity func_175625_s(@Nonnull BlockPos pos) {
            return null;
        }

        public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
            return 0;
        }

        @Nonnull
        public IBlockState func_180495_p(@Nonnull BlockPos pos) {
            return pos.equals((Object)BlockPos.field_177992_a) ? this.state : Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(@Nonnull BlockPos pos) {
            return !pos.equals((Object)BlockPos.field_177992_a);
        }

        @Nonnull
        public Biome func_180494_b(@Nonnull BlockPos pos) {
            return Biomes.field_76789_p;
        }

        public int func_175627_a(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
            return 0;
        }

        @Nonnull
        public WorldType func_175624_G() {
            return WorldType.field_77137_b;
        }

        public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
            return pos.equals((Object)BlockPos.field_177992_a) && this.state.isSideSolid((IBlockAccess)this, BlockPos.field_177992_a, side);
        }
    }

    public static class InventoryCraftingFalse
    extends InventoryCrafting {
        private static final Container nullContainer = new Container(){

            public void func_75130_a(IInventory paramIInventory) {
            }

            public boolean func_75145_c(@Nonnull EntityPlayer p_75145_1_) {
                return false;
            }
        };

        public InventoryCraftingFalse(int w, int h) {
            super(nullContainer, w, h);
        }

        public static InventoryCrafting createFilledCraftingInventory(int w, int h, NonNullList<ItemStack> stacks) {
            InventoryCraftingFalse invC = new InventoryCraftingFalse(w, h);
            for (int j = 0; j < w * h; ++j) {
                if (((ItemStack)stacks.get(j)).func_190926_b()) continue;
                invC.func_70299_a(j, ((ItemStack)stacks.get(j)).func_77946_l());
            }
            return invC;
        }
    }
}

