/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.item.matcher;

import com.feed_the_beast.ftblib.lib.item.matcher.AndMatcher;
import com.feed_the_beast.ftblib.lib.item.matcher.IItemMatcher;
import com.feed_the_beast.ftblib.lib.item.matcher.ItemStackMatcher;
import com.feed_the_beast.ftblib.lib.item.matcher.NoItemMatcher;
import com.feed_the_beast.ftblib.lib.item.matcher.OrMatcher;
import com.feed_the_beast.ftblib.lib.item.matcher.OreNameMatcher;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemMatcherRegistry {
    private static final ArrayList<MatcherEntry> ENTRIES = new ArrayList();

    public static void register(Predicate<NBTBase> predicate, Supplier<IItemMatcher> supplier) {
        MatcherEntry entry = new MatcherEntry();
        entry.predicate = predicate;
        entry.supplier = supplier;
        ENTRIES.add(entry);
    }

    public static IItemMatcher createMatcher(@Nullable NBTBase nbt) {
        if (nbt == null || nbt.func_82582_d()) {
            return NoItemMatcher.INSTANCE;
        }
        for (MatcherEntry entry : ENTRIES) {
            if (!entry.predicate.test(nbt)) continue;
            IItemMatcher matcher = (IItemMatcher)entry.supplier.get();
            matcher.fromNBT(nbt);
            if (!matcher.isValid()) continue;
            return matcher;
        }
        ItemStackMatcher matcher = new ItemStackMatcher();
        matcher.fromNBT(nbt);
        return matcher.isValid() ? matcher : NoItemMatcher.INSTANCE;
    }

    static {
        ItemMatcherRegistry.register(nbt -> nbt instanceof NBTTagCompound && ((NBTTagCompound)nbt).func_74764_b("ore"), OreNameMatcher::new);
        ItemMatcherRegistry.register(nbt -> nbt instanceof NBTTagCompound && ((NBTTagCompound)nbt).func_74764_b("and"), AndMatcher::new);
        ItemMatcherRegistry.register(nbt -> nbt instanceof NBTTagCompound && ((NBTTagCompound)nbt).func_74764_b("or"), OrMatcher::new);
    }

    private static class MatcherEntry {
        private Predicate<NBTBase> predicate;
        private Supplier<IItemMatcher> supplier;

        private MatcherEntry() {
        }
    }
}

