/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.item.matcher;

import com.feed_the_beast.ftblib.lib.item.matcher.IItemMatcher;
import com.feed_the_beast.ftblib.lib.item.matcher.ItemMatcherRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AndMatcher
implements IItemMatcher {
    public final List<IItemMatcher> matchers = new ArrayList<IItemMatcher>();

    @Override
    public NBTBase toNBT(boolean forceTagCompound) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (IItemMatcher matcher : this.matchers) {
            if (!matcher.isValid()) continue;
            list.func_74742_a(matcher.toNBT(true));
        }
        nbt.func_74782_a("and", (NBTBase)list);
        return nbt;
    }

    @Override
    public void fromNBT(NBTBase nbt) {
        this.matchers.clear();
        if (nbt instanceof NBTTagCompound) {
            NBTTagList list = ((NBTTagCompound)nbt).func_150295_c("and", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                IItemMatcher matcher = ItemMatcherRegistry.createMatcher((NBTBase)list.func_150305_b(i));
                if (!matcher.isValid()) continue;
                this.matchers.add(matcher);
            }
        }
    }

    @Override
    public boolean test(ItemStack stack) {
        for (IItemMatcher matcher : this.matchers) {
            if (!matcher.isValid() || matcher.test(stack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isValid() {
        for (IItemMatcher matcher : this.matchers) {
            if (!matcher.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCache() {
        for (IItemMatcher matcher : this.matchers) {
            matcher.clearCache();
        }
    }

    @Override
    public void getAllStacks(Collection<ItemStack> stacks) {
        for (IItemMatcher matcher : this.matchers) {
            matcher.getAllStacks(stacks);
        }
    }
}

