/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class ContextMenu
extends Panel {
    public final List<ContextMenuItem> items;
    public boolean hasIcons;

    public ContextMenu(Panel panel, List<ContextMenuItem> i) {
        super(panel);
        this.items = i;
        this.hasIcons = false;
        for (ContextMenuItem item : this.items) {
            if (item.icon.isEmpty()) continue;
            this.hasIcons = true;
            break;
        }
    }

    @Override
    public void addWidgets() {
        for (ContextMenuItem item : this.items) {
            this.add(item.createWidget(this));
        }
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        boolean b = super.mousePressed(button);
        if (!b && !this.isMouseOver()) {
            this.closeContextMenu();
            return true;
        }
        return b;
    }

    @Override
    public void alignWidgets() {
        this.setWidth(0);
        for (Widget widget : this.widgets) {
            this.setWidth(Math.max(this.width, widget.width));
        }
        for (Widget widget : this.widgets) {
            widget.setX(3);
            widget.setWidth(this.width);
        }
        this.setWidth(this.width + 6);
        this.setHeight(this.align(new WidgetLayout.Vertical(3, 1, 3)));
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawContextMenuBackground(x, y, w, h);
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)900.0f);
        super.draw(theme, x, y, w, h);
        GlStateManager.func_179121_F();
    }

    public static class CSeperator
    extends Button {
        public CSeperator(Panel panel) {
            super(panel);
            this.setHeight(5);
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            Color4I.WHITE.withAlpha(130).draw(x + 2, y + 2, this.parent.width - 10, 1);
        }

        @Override
        public void onClicked(MouseButton button) {
        }
    }

    public static class CButton
    extends Button {
        public final ContextMenu contextMenu;
        public final ContextMenuItem item;

        public CButton(ContextMenu panel, ContextMenuItem i) {
            super(panel, i.title, i.icon);
            this.contextMenu = panel;
            this.item = i;
            this.setSize(panel.getGui().getTheme().getStringWidth(this.item.title) + (this.contextMenu.hasIcons ? 14 : 4), 12);
        }

        @Override
        public void addMouseOverText(List<String> list) {
            this.item.addMouseOverText(list);
        }

        @Override
        public WidgetType getWidgetType() {
            return this.item.enabled ? super.getWidgetType() : WidgetType.DISABLED;
        }

        @Override
        public void drawIcon(Theme theme, int x, int y, int w, int h) {
            this.item.drawIcon(theme, x, y, w, h);
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            if (this.contextMenu.hasIcons) {
                this.drawIcon(theme, x + 1, y + 2, 8, 8);
                theme.drawString(this.getTitle(), x + 11, y + 2, theme.getContentColor(this.getWidgetType()), 2);
            } else {
                theme.drawString(this.getTitle(), x + 2, y + 2, theme.getContentColor(this.getWidgetType()), 2);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            if (this.item.yesNoText.isEmpty()) {
                this.item.onClicked(this.contextMenu, button);
            } else {
                this.getGui().openYesNo(this.item.yesNoText, "", () -> this.item.onClicked(this.contextMenu, button));
            }
        }
    }
}

