/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class ConfigInt
extends ConfigValue
implements IntSupplier {
    public static final String ID = "int";
    public static final Color4I COLOR = Color4I.rgb(11164392);
    private int value;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    public ConfigInt() {
    }

    public ConfigInt(int v) {
        this.value = v;
    }

    public ConfigInt(int v, int mn, int mx) {
        this(MathHelper.func_76125_a((int)v, (int)mn, (int)mx));
        this.min = mn;
        this.max = mx;
    }

    public String func_176610_l() {
        return ID;
    }

    public ConfigInt setMin(int v) {
        this.min = v;
        return this;
    }

    public ConfigInt setMax(int v) {
        this.max = v;
        return this;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public void setInt(int v) {
        this.value = MathHelper.func_76125_a((int)v, (int)this.getMin(), (int)this.getMax());
    }

    @Override
    public String getString() {
        return Integer.toString(this.getInt());
    }

    @Override
    public boolean getBoolean() {
        return this.getInt() != 0;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public ConfigInt copy() {
        return new ConfigInt(this.getInt(), this.getMin(), this.getMax());
    }

    @Override
    public boolean equalsValue(ConfigValue value) {
        return this.getInt() == value.getInt();
    }

    @Override
    public Color4I getColor() {
        return COLOR;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
        super.addInfo(inst, list);
        int m = this.getMin();
        if (m != Integer.MIN_VALUE) {
            list.add(TextFormatting.AQUA + "Min: " + TextFormatting.RESET + m);
        }
        if ((m = this.getMax()) != Integer.MAX_VALUE) {
            list.add(TextFormatting.AQUA + "Max: " + TextFormatting.RESET + m);
        }
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        try {
            int val = Integer.parseInt(string);
            if (val < this.getMin() || val > this.getMax()) {
                return false;
            }
            if (!simulate) {
                this.setInt(val);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.value = this.getInt();
        if (this.value != 0) {
            nbt.func_74780_a(key, (double)this.value);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setInt(nbt.func_74762_e(key));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeInt(this.getInt());
        data.writeInt(this.getMin());
        data.writeInt(this.getMax());
    }

    @Override
    public void readData(DataIn data) {
        this.setInt(data.readInt());
        this.setMin(data.readInt());
        this.setMax(data.readInt());
    }

    @Override
    public int getAsInt() {
        return this.getInt();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        this.setInt(value.getInt());
    }

    @Override
    public void setValueFromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            this.setInt(json.getAsInt());
        }
    }

    public static class SimpleInt
    extends ConfigInt {
        private final IntSupplier get;
        private final IntConsumer set;

        public SimpleInt(int min, int max, IntSupplier g, IntConsumer s) {
            super(0, min, max);
            this.get = g;
            this.set = s;
        }

        @Override
        public int getInt() {
            return this.get.getAsInt();
        }

        @Override
        public void setInt(int v) {
            this.set.accept(v);
        }
    }
}

