/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.proxy;

import java.io.File;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.proxy.AbstractCommonProxy;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WrenchChecker;
import mcjty.rftoolsdim.ForgeEventHandlers;
import mcjty.rftoolsdim.ModCrafting;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.blocks.ModBlocks;
import mcjty.rftoolsdim.config.DimletConfiguration;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.rftoolsdim.config.DimletRules;
import mcjty.rftoolsdim.config.GeneralConfiguration;
import mcjty.rftoolsdim.config.LostCityConfiguration;
import mcjty.rftoolsdim.config.MachineConfiguration;
import mcjty.rftoolsdim.config.MobConfiguration;
import mcjty.rftoolsdim.config.OresAPlentyConfiguration;
import mcjty.rftoolsdim.config.PowerConfiguration;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.DimensionTickEvent;
import mcjty.rftoolsdim.dimensions.ModDimensions;
import mcjty.rftoolsdim.gui.GuiProxy;
import mcjty.rftoolsdim.items.ModItems;
import mcjty.rftoolsdim.network.RFToolsDimMessages;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public abstract class CommonProxy
extends AbstractCommonProxy {
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        this.mainConfig = new Configuration(new File(this.modConfigDir.getPath() + File.separator + "rftools", "dimensions.cfg"));
        this.readMainConfig();
        SimpleNetworkWrapper network = PacketHandler.registerMessages((String)"rftoolsdim", (String)"rftoolsdim");
        RFToolsDimMessages.registerNetworkMessages(network);
        ModItems.init();
        ModBlocks.init();
        ModDimensions.init();
        DimletRules.readRules(this.modConfigDir);
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment("general", "Dimension related settings");
            cfg.addCustomCategoryComment("machines", "Machine related settings");
            cfg.addCustomCategoryComment("worldgen", "Worldgen related settings");
            cfg.addCustomCategoryComment("power", "Power related settings");
            cfg.addCustomCategoryComment("dimlets", "Dimlet related settings");
            cfg.addCustomCategoryComment("mobs", "Mob related settings");
            cfg.addCustomCategoryComment("oresaplenty", "Settings for the OresAPlenty dimlet");
            cfg.addCustomCategoryComment("dimletconstruction", "Dimlet construction related settings");
            cfg.addCustomCategoryComment("lostcity", "Settings related to the Lost City dimlet");
            GeneralConfiguration.init(cfg);
            MachineConfiguration.init(cfg);
            WorldgenConfiguration.init(cfg);
            PowerConfiguration.init(cfg);
            DimletConfiguration.init(cfg);
            MobConfiguration.init(cfg);
            OresAPlentyConfiguration.init(cfg);
            LostCityConfiguration.init(cfg);
            DimletConstructionConfiguration.init(cfg);
        }
        catch (Exception e1) {
            Logging.logError((String)"Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        super.init(e);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)RFToolsDim.instance, (IGuiHandler)new GuiProxy());
        MinecraftForge.EVENT_BUS.register((Object)new DimensionTickEvent());
        ModCrafting.init();
    }

    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
        this.mainConfig = null;
        WrenchChecker.init();
    }
}

