/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.api.event.BloodMagicCraftedEvent;
import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.api.impl.recipe.RecipeAlchemyTable;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.core.registry.AlchemyTableRecipeRegistry;
import WayofTime.bloodmagic.iface.IBindable;
import WayofTime.bloodmagic.iface.ICustomAlchemyConsumable;
import WayofTime.bloodmagic.orb.BloodOrb;
import WayofTime.bloodmagic.orb.IBloodOrb;
import WayofTime.bloodmagic.recipe.alchemyTable.AlchemyTableRecipe;
import WayofTime.bloodmagic.tile.TileInventory;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.ArrayUtils;

public class TileAlchemyTable
extends TileInventory
implements ISidedInventory,
ITickable {
    public static final int orbSlot = 6;
    public static final int toolSlot = 7;
    public static final int outputSlot = 8;
    public EnumFacing direction = EnumFacing.NORTH;
    public boolean isSlave = false;
    public int burnTime = 0;
    public int ticksRequired = 1;
    public BlockPos connectedPos = BlockPos.field_177992_a;
    public boolean[] blockedSlots = new boolean[]{false, false, false, false, false, false};

    public TileAlchemyTable() {
        super(9, "alchemyTable");
    }

    public void setInitialTableParameters(EnumFacing direction, boolean isSlave, BlockPos connectedPos) {
        this.isSlave = isSlave;
        this.connectedPos = connectedPos;
        if (!isSlave) {
            this.direction = direction;
        }
    }

    public boolean isInvisible() {
        return this.isSlave();
    }

    public boolean isInputSlotAccessible(int slot) {
        return slot >= 6 || slot < 0 || !this.blockedSlots[slot];
    }

    public void toggleInputSlotAccessible(int slot) {
        if (slot < 6 && slot >= 0) {
            this.blockedSlots[slot] = !this.blockedSlots[slot];
        }
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.isSlave = tag.func_74767_n("isSlave");
        this.direction = EnumFacing.func_82600_a((int)tag.func_74762_e("direction"));
        this.connectedPos = new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
        this.burnTime = tag.func_74762_e("burnTime");
        this.ticksRequired = tag.func_74762_e("ticksRequired");
        byte[] array = tag.func_74770_j("blockedSlots");
        for (int i = 0; i < array.length; ++i) {
            this.blockedSlots[i] = array[i] != 0;
        }
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74757_a("isSlave", this.isSlave);
        tag.func_74768_a("direction", this.direction.func_176745_a());
        tag.func_74768_a("xCoord", this.connectedPos.func_177958_n());
        tag.func_74768_a("yCoord", this.connectedPos.func_177956_o());
        tag.func_74768_a("zCoord", this.connectedPos.func_177952_p());
        tag.func_74768_a("burnTime", this.burnTime);
        tag.func_74768_a("ticksRequired", this.ticksRequired);
        byte[] blockedSlotArray = new byte[this.blockedSlots.length];
        for (int i = 0; i < this.blockedSlots.length; ++i) {
            blockedSlotArray[i] = (byte)(this.blockedSlots[i] ? 1 : 0);
        }
        tag.func_74773_a("blockedSlots", blockedSlotArray);
        return tag;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.isSlave()) {
                TileEntity tile = this.func_145831_w().func_175625_s(this.connectedPos);
                if (tile instanceof TileAlchemyTable && !((TileAlchemyTable)tile).isSlave) {
                    return (T)tile.getCapability(capability, facing);
                }
            } else {
                return super.getCapability(capability, facing);
            }
        }
        return super.getCapability(capability, facing);
    }

    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return new int[]{8};
            }
            case UP: {
                return new int[]{6, 7};
            }
        }
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        TileEntity tile;
        switch (direction) {
            case DOWN: {
                return index != 8 && index != 6 && index != 7;
            }
            case UP: {
                if (index == 6 && !stack.func_190926_b() && stack.func_77973_b() instanceof IBloodOrb) {
                    return true;
                }
                return index != 7;
            }
        }
        if (this.isSlave && (tile = this.func_145831_w().func_175625_s(this.connectedPos)) instanceof TileAlchemyTable && !((TileAlchemyTable)tile).isSlave) {
            return ((TileAlchemyTable)tile).func_180462_a(index, stack, direction);
        }
        return this.getAccessibleInputSlots(direction).contains(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        TileEntity tile;
        switch (direction) {
            case DOWN: {
                return index == 8;
            }
            case UP: {
                if (index == 6 && !stack.func_190926_b() && stack.func_77973_b() instanceof IBloodOrb) {
                    return true;
                }
                if (index == 7) {
                    return true;
                }
                return true;
            }
        }
        if (this.isSlave && (tile = this.func_145831_w().func_175625_s(this.connectedPos)) instanceof TileAlchemyTable && !((TileAlchemyTable)tile).isSlave) {
            return ((TileAlchemyTable)tile).func_180461_b(index, stack, direction);
        }
        return this.getAccessibleInputSlots(direction).contains(index);
    }

    public List<Integer> getAccessibleInputSlots(EnumFacing direction) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 6; ++i) {
            if (!this.isInputSlotAccessible(i)) continue;
            list.add(i);
        }
        return list;
    }

    public void func_73660_a() {
        if (this.isSlave()) {
            return;
        }
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            inputList.add(this.func_70301_a(i));
        }
        int tier = this.getTierOfOrb();
        AlchemyTableRecipe recipe = AlchemyTableRecipeRegistry.getMatchingRecipe(inputList, this.func_145831_w(), this.func_174877_v());
        if (recipe != null && (this.burnTime > 0 || !this.func_145831_w().field_72995_K && tier >= recipe.getTierRequired() && this.getContainedLp() >= recipe.getLpDrained())) {
            if (this.burnTime == 1) {
                this.notifyUpdate();
            }
            if (this.canCraft(recipe.getRecipeOutput(inputList))) {
                this.ticksRequired = recipe.getTicksRequired();
                ++this.burnTime;
                if (this.burnTime == this.ticksRequired) {
                    if (!this.func_145831_w().field_72995_K) {
                        int requiredLp = recipe.getLpDrained();
                        if (requiredLp > 0 && !this.func_145831_w().field_72995_K) {
                            this.consumeLp(requiredLp);
                        }
                        if (!this.func_145831_w().field_72995_K) {
                            this.craftItem(inputList, recipe);
                        }
                    }
                    this.burnTime = 0;
                    IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
                    this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
                } else if (this.burnTime > this.ticksRequired + 10) {
                    this.burnTime = 0;
                }
            } else {
                this.burnTime = 0;
            }
        } else {
            RecipeAlchemyTable recipeAlchemyTable = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyTable(inputList);
            if (recipeAlchemyTable != null && (this.burnTime > 0 || !this.func_145831_w().field_72995_K && tier >= recipeAlchemyTable.getMinimumTier() && this.getContainedLp() >= recipeAlchemyTable.getSyphon())) {
                if (this.burnTime == 1) {
                    this.notifyUpdate();
                }
                if (this.canCraft(recipeAlchemyTable.getOutput())) {
                    this.ticksRequired = recipeAlchemyTable.getTicks();
                    ++this.burnTime;
                    if (this.burnTime >= this.ticksRequired && !this.func_145831_w().field_72995_K) {
                        if (recipeAlchemyTable.getSyphon() > 0 && this.consumeLp(recipeAlchemyTable.getSyphon()) < recipeAlchemyTable.getSyphon()) {
                            this.burnTime = 0;
                            this.notifyUpdate();
                            return;
                        }
                        Object[] inputs = new ItemStack[]{};
                        for (ItemStack stack : inputList) {
                            ArrayUtils.add((Object[])inputs, (Object)stack.func_77946_l());
                        }
                        BloodMagicCraftedEvent.AlchemyTable event = new BloodMagicCraftedEvent.AlchemyTable(recipeAlchemyTable.getOutput().func_77946_l(), (ItemStack[])inputs);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        ItemStack outputSlotStack = this.func_70301_a(8);
                        if (outputSlotStack.func_190926_b()) {
                            this.func_70299_a(8, event.getOutput());
                        } else {
                            outputSlotStack.func_190917_f(event.getOutput().func_190916_E());
                        }
                        for (int i = 0; i < 6; ++i) {
                            ItemStack currentStack = this.func_70301_a(i);
                            if (currentStack.func_77973_b().hasContainerItem(currentStack)) {
                                this.func_70299_a(i, currentStack.func_77973_b().getContainerItem(currentStack));
                                continue;
                            }
                            if (currentStack.func_77973_b() instanceof ICustomAlchemyConsumable) {
                                this.func_70299_a(i, ((ICustomAlchemyConsumable)currentStack.func_77973_b()).drainUseOnAlchemyCraft(currentStack));
                                continue;
                            }
                            currentStack.func_190918_g(1);
                        }
                        this.burnTime = 0;
                        this.notifyUpdate();
                    }
                }
            } else {
                this.burnTime = 0;
            }
        }
    }

    public double getProgressForGui() {
        return (double)this.burnTime / (double)this.ticksRequired;
    }

    private boolean canCraft(ItemStack output) {
        ItemStack currentOutputStack = this.func_70301_a(8);
        if (output.func_190926_b()) {
            return false;
        }
        if (currentOutputStack.func_190926_b()) {
            return true;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)currentOutputStack)) {
            return false;
        }
        int result = currentOutputStack.func_190916_E() + output.func_190916_E();
        return result <= this.func_70297_j_() && result <= currentOutputStack.func_77976_d();
    }

    public int getTierOfOrb() {
        ItemStack orbStack = this.func_70301_a(6);
        if (!orbStack.func_190926_b() && orbStack.func_77973_b() instanceof IBloodOrb) {
            BloodOrb orb = ((IBloodOrb)orbStack.func_77973_b()).getOrb(orbStack);
            return orb == null ? 0 : orb.getTier();
        }
        return 0;
    }

    public int getContainedLp() {
        ItemStack orbStack = this.func_70301_a(6);
        if (!orbStack.func_190926_b() && orbStack.func_77973_b() instanceof IBloodOrb) {
            Binding binding = ((IBindable)orbStack.func_77973_b()).getBinding(orbStack);
            if (binding == null) {
                return 0;
            }
            SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
            return network.getCurrentEssence();
        }
        return 0;
    }

    public void craftItem(List<ItemStack> inputList, AlchemyTableRecipe recipe) {
        ItemStack outputStack = recipe.getRecipeOutput(inputList);
        if (this.canCraft(outputStack)) {
            ItemStack currentOutputStack = this.func_70301_a(8);
            Object[] inputs = new ItemStack[]{};
            for (ItemStack stack : inputList) {
                ArrayUtils.add((Object[])inputs, (Object)stack.func_77946_l());
            }
            BloodMagicCraftedEvent.AlchemyTable event = new BloodMagicCraftedEvent.AlchemyTable(outputStack.func_77946_l(), (ItemStack[])inputs);
            MinecraftForge.EVENT_BUS.post((Event)event);
            outputStack = event.getOutput();
            if (currentOutputStack.func_190926_b()) {
                this.func_70299_a(8, outputStack);
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)currentOutputStack)) {
                currentOutputStack.func_190917_f(outputStack.func_190916_E());
            }
            this.consumeInventory(recipe);
        }
    }

    public int consumeLp(int requested) {
        ItemStack orbStack = this.func_70301_a(6);
        if (!orbStack.func_190926_b() && orbStack.func_77973_b() instanceof IBloodOrb && NetworkHelper.syphonFromContainer(orbStack, SoulTicket.item(orbStack, this.field_145850_b, this.field_174879_c, requested))) {
            return requested;
        }
        return 0;
    }

    public void consumeInventory(AlchemyTableRecipe recipe) {
        ItemStack[] input = new ItemStack[6];
        for (int i = 0; i < 6; ++i) {
            input[i] = this.func_70301_a(i);
        }
        ItemStack[] result = recipe.getRemainingItems(input);
        for (int i = 0; i < 6; ++i) {
            this.func_70299_a(i, result[i]);
        }
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public boolean isSlave() {
        return this.isSlave;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public BlockPos getConnectedPos() {
        return this.connectedPos;
    }

    public boolean[] getBlockedSlots() {
        return this.blockedSlots;
    }

    public static int getOrbSlot() {
        return 6;
    }

    public static int getToolSlot() {
        return 7;
    }

    public static int getOutputSlot() {
        return 8;
    }
}

