/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.client.morph;

import me.ichun.mods.morph.client.model.ModelHandler;
import me.ichun.mods.morph.client.model.ModelInfo;
import me.ichun.mods.morph.client.model.ModelMorph;
import me.ichun.mods.morph.common.morph.MorphInfo;
import me.ichun.mods.morph.common.morph.MorphState;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MorphInfoClient
extends MorphInfo {
    private ModelInfo prevStateModel;
    private ModelInfo nextStateModel;
    private ModelMorph modelMorph;

    public MorphInfoClient(EntityPlayer player, MorphState prevState, MorphState nextState) {
        super(player, prevState, nextState);
    }

    public ModelInfo getNextStateModel(World world) {
        if (this.nextStateModel == null) {
            this.nextStateModel = ModelHandler.getEntityModelInfo(this.nextState.getEntInstance(world));
        }
        return this.nextStateModel;
    }

    public ModelInfo getPrevStateModel(World world) {
        if (this.prevState != null && this.prevStateModel == null) {
            this.prevStateModel = ModelHandler.getEntityModelInfo(this.prevState.getEntInstance(world));
        }
        return this.prevStateModel;
    }

    public ModelMorph getModelMorph(World world) {
        if (this.modelMorph == null) {
            GameType oriGameTypePrev = null;
            NetworkPlayerInfo npiPrev = null;
            if (this.prevState != null && this.prevState.getEntInstance(world) instanceof EntityOtherPlayerMP && (npiPrev = Minecraft.func_71410_x().func_147114_u().func_175102_a(((EntityOtherPlayerMP)this.prevState.getEntInstance(world)).func_146103_bH().getId())) != null) {
                oriGameTypePrev = npiPrev.func_178848_b();
                npiPrev.func_178839_a(GameType.ADVENTURE);
            }
            GameType oriGameTypeNext = null;
            NetworkPlayerInfo npiNext = null;
            if (this.nextState.getEntInstance(world) instanceof EntityOtherPlayerMP && (npiNext = Minecraft.func_71410_x().func_147114_u().func_175102_a(((EntityOtherPlayerMP)this.nextState.getEntInstance(world)).func_146103_bH().getId())) != null) {
                oriGameTypeNext = npiNext.func_178848_b();
                npiNext.func_178839_a(GameType.ADVENTURE);
            }
            this.modelMorph = new ModelMorph(this.getPrevStateModel(world), this.getNextStateModel(world), (Entity)(this.prevState != null ? this.prevState.getEntInstance(world) : null), (Entity)this.nextState.getEntInstance(world));
            if (npiPrev != null) {
                npiPrev.func_178839_a(oriGameTypePrev);
            }
            if (npiNext != null) {
                npiNext.func_178839_a(oriGameTypeNext);
            }
        }
        return this.modelMorph;
    }

    @Override
    public void clean() {
        super.clean();
        if (this.modelMorph != null) {
            this.modelMorph.modelList.stream().filter(renderer -> renderer.field_78812_q).forEach(renderer -> {
                GLAllocation.func_74523_b((int)renderer.field_78811_r);
                renderer.field_78812_q = false;
            });
        }
    }

    @Override
    public void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        GameType oriGameTypePrev = null;
        NetworkPlayerInfo npiPrev = null;
        if (this.prevState != null && this.prevState.getEntInstance((World)mc.field_71441_e) instanceof EntityOtherPlayerMP) {
            EntityOtherPlayerMP player = (EntityOtherPlayerMP)this.prevState.getEntInstance((World)mc.field_71441_e);
            npiPrev = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_146103_bH().getId());
            if (npiPrev != null) {
                oriGameTypePrev = npiPrev.func_178848_b();
                npiPrev.func_178839_a(GameType.SPECTATOR);
            }
        }
        GameType oriGameTypeNext = null;
        NetworkPlayerInfo npiNext = null;
        if (this.nextState.getEntInstance((World)mc.field_71441_e) instanceof EntityOtherPlayerMP) {
            EntityOtherPlayerMP player = (EntityOtherPlayerMP)this.nextState.getEntInstance((World)mc.field_71441_e);
            npiNext = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_146103_bH().getId());
            if (npiNext != null) {
                oriGameTypeNext = npiNext.func_178848_b();
                npiNext.func_178839_a(GameType.SPECTATOR);
            }
        }
        super.tick();
        if (npiPrev != null) {
            npiPrev.func_178839_a(oriGameTypePrev);
        }
        if (npiNext != null) {
            npiNext.func_178839_a(oriGameTypeNext);
        }
    }

    @Override
    public void syncEntityWithPlayer(EntityLivingBase ent) {
        if (this.player == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ent.field_70758_at = this.player.field_70758_at;
        ent.field_70126_B = this.player.field_70126_B;
        ent.field_70127_C = this.player.field_70127_C;
        ent.field_70760_ar = this.player.field_70760_ar;
        ent.field_184618_aE = this.player.field_184618_aE;
        ent.field_70732_aI = this.player.field_70732_aI;
        ent.field_70169_q = this.player.field_70169_q;
        ent.field_70167_r = this.player.field_70167_r;
        ent.field_70166_s = this.player.field_70166_s;
        ent.field_70759_as = this.player.field_70759_as;
        ent.field_70177_z = this.player.field_70177_z;
        ent.field_70125_A = this.player.field_70125_A;
        ent.field_70761_aq = this.player.field_70761_aq;
        ent.field_70721_aZ = this.player.field_70721_aZ;
        ent.field_184619_aG = this.player.field_184619_aG;
        ent.field_70165_t = this.player.field_70165_t;
        ent.field_70163_u = this.player.field_70163_u;
        ent.field_70161_v = this.player.field_70161_v;
        ent.field_70159_w = this.player.field_70159_w;
        ent.field_70181_x = this.player.field_70181_x;
        ent.field_70179_y = this.player.field_70179_y;
        ent.field_70173_aa = this.player.field_70173_aa;
        ent.field_70160_al = this.player.field_70160_al;
        ent.field_70702_br = this.player.field_70702_br;
        ent.field_191988_bg = this.player.field_191988_bg;
        ent.field_71093_bK = this.player.field_71093_bK;
        ent.field_70170_p = this.player.func_130014_f_();
        ent.field_184239_as = this.player.field_184239_as;
        ent.field_70737_aN = this.player.field_70737_aN;
        ent.field_70725_aQ = this.player.field_70725_aQ;
        ent.field_82175_bq = this.player.field_82175_bq;
        ent.field_184622_au = this.player.field_184622_au;
        ent.field_70733_aJ = this.player.field_70733_aJ;
        ent.field_110158_av = this.player.field_110158_av;
        boolean prevOnGround = ent.field_70122_E;
        ent.field_70122_E = this.player.field_70122_E;
        if (this.player != mc.field_71439_g) {
            ent.field_70159_w = this.player.field_70165_t - this.player.field_70142_S;
            ent.field_70181_x = this.player.field_70163_u - this.player.field_70137_T;
            ent.field_70179_y = this.player.field_70161_v - this.player.field_70136_U;
            ent.field_70145_X = false;
            ent.func_174826_a(this.player.func_174813_aQ());
            float distanceWalkedModified = ent.field_70140_Q;
            float distanceWalkedOnStepModified = ent.field_82151_R;
            ent.func_70091_d(MoverType.SELF, 0.0, -0.01, 0.0);
            ent.field_70140_Q = distanceWalkedModified;
            ent.field_82151_R = distanceWalkedOnStepModified;
            ent.field_70163_u = this.player.field_70163_u;
        }
        ent.field_70145_X = true;
        ent.field_70144_Y = 1.0f;
        ent.func_174826_a(this.player.func_174813_aQ());
        ent.func_70095_a(this.player.func_70093_af());
        ent.func_70031_b(this.player.func_70051_ag());
        ent.func_82142_c(this.player.func_82150_aj());
        ent.func_70606_j(ent.func_110138_aP() * (this.player.func_110143_aJ() / this.player.func_110138_aP()));
        if (ent instanceof EntitySlime && prevOnGround && !ent.field_70122_E) {
            ((EntitySlime)ent).field_70813_a = 0.6f;
        }
        if (ent instanceof EntityRabbit && ((double)MathHelper.func_76133_a((double)(ent.field_70159_w * ent.field_70159_w + ent.field_70179_y * ent.field_70179_y)) > 0.02 && ((EntityRabbit)ent).func_175521_o(0.0f) == 0.0f || prevOnGround && !ent.field_70122_E)) {
            ((EntityRabbit)ent).func_184770_cZ();
            int i = MathHelper.func_76128_c((double)this.player.field_70165_t);
            int j = MathHelper.func_76128_c((double)(this.player.field_70163_u - (double)0.2f));
            int k = MathHelper.func_76128_c((double)this.player.field_70161_v);
            BlockPos blockpos = new BlockPos(i, j, k);
            IBlockState iblockstate = this.player.func_130014_f_().func_180495_p(blockpos);
            if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                this.player.func_130014_f_().func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.player.field_70165_t + ((double)this.player.func_70681_au().nextFloat() - 0.5) * (double)this.player.field_70130_N, this.player.func_174813_aQ().field_72338_b + 0.1, this.player.field_70161_v + ((double)this.player.func_70681_au().nextFloat() - 0.5) * (double)this.player.field_70130_N, -ent.field_70159_w * 4.0, 1.5, -ent.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
        }
        if (ent instanceof EntityDragon) {
            ent.field_70126_B += 180.0f;
            ent.field_70177_z += 180.0f;
            ((EntityDragon)ent).field_70995_bG = this.player.field_70725_aQ;
        }
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            ItemStack itemstack = ent.func_184582_a(entityequipmentslot);
            ItemStack itemstack1 = this.player.func_184582_a(entityequipmentslot);
            if (!(itemstack.func_190926_b() && !itemstack1.func_190926_b() || !itemstack.func_190926_b() && itemstack1.func_190926_b()) && (itemstack.func_190926_b() || itemstack1.func_190926_b() || itemstack.func_77969_a(itemstack1))) continue;
            ent.func_184201_a(entityequipmentslot, !itemstack1.func_190926_b() ? itemstack1.func_77946_l() : ItemStack.field_190927_a);
        }
        if (this.player.field_184627_bm != ent.field_184627_bm) {
            if (this.player.field_184627_bm == ItemStack.field_190927_a) {
                ent.func_184602_cy();
                if (ent instanceof IRangedAttackMob) {
                    ((IRangedAttackMob)ent).func_184724_a(false);
                }
            } else if (!this.player.field_184627_bm.func_77969_a(ent.field_184627_bm)) {
                ent.func_184598_c(this.player.func_184600_cs());
                ent.field_184627_bm = this.player.field_184627_bm.func_77946_l();
                ent.field_184628_bn = this.player.field_184628_bn;
                if (ent instanceof IRangedAttackMob) {
                    ((IRangedAttackMob)ent).func_184724_a(true);
                }
            }
        }
    }
}

