/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.api.ability;

import java.util.ArrayList;
import me.ichun.mods.morph.api.ability.AbilityHandlerDummy;
import me.ichun.mods.morph.api.ability.IAbilityHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Ability
implements Comparable<Ability> {
    private transient EntityLivingBase parent = null;
    public transient float strength = 0.0f;
    public transient boolean isActive;
    protected transient ResourceLocation iconResource;
    private static IAbilityHandler abilityHandlerImpl = new AbilityHandlerDummy();

    public abstract String getType();

    public abstract Ability clone();

    public void setParent(EntityLivingBase ent) {
        this.parent = ent;
    }

    public EntityLivingBase getParent() {
        return this.parent;
    }

    public void tick() {
    }

    public boolean isActive() {
        return this.isActive;
    }

    public float activeCost() {
        return 0.0f;
    }

    public void kill(ArrayList<Ability> nextAbilities) {
    }

    public boolean entityHasAbility(EntityLivingBase living) {
        return true;
    }

    public boolean isUsable() {
        return false;
    }

    public boolean isCharacteristic(EntityLivingBase living) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getIcon() {
        return this.iconResource;
    }

    @SideOnly(value=Side.CLIENT)
    public void postRender() {
    }

    @Override
    public int compareTo(Ability ability) {
        if (this.isUsable() != ability.isUsable()) {
            return this.isUsable() ? 1 : -1;
        }
        return this.getType().compareTo(ability.getType());
    }

    public static void registerAbility(String name, Class<? extends Ability> clz) {
        abilityHandlerImpl.registerAbility(name, clz);
    }

    public static void mapAbilities(Class<? extends EntityLivingBase> entClass, Ability ... abilities) {
        abilityHandlerImpl.mapAbilities(entClass, abilities);
    }

    public static void removeAbility(Class<? extends EntityLivingBase> entClass, String type) {
        abilityHandlerImpl.removeAbility(entClass, type);
    }

    public static boolean hasAbility(Class<? extends EntityLivingBase> entClass, String type) {
        return abilityHandlerImpl.hasAbility(entClass, type);
    }

    public static Ability createNewAbilityByType(String type, String json) {
        return abilityHandlerImpl.createNewAbilityByType(type, json);
    }

    public ArrayList<Ability> getEntityAbilities(Class<? extends EntityLivingBase> entClass) {
        return abilityHandlerImpl.getEntityAbilities(entClass);
    }

    public static IAbilityHandler getAbilityHandlerImpl() {
        return abilityHandlerImpl;
    }

    public static void setAbilityHandlerImpl(IAbilityHandler abilityHandlerImpl) {
        Ability.abilityHandlerImpl = abilityHandlerImpl;
    }
}

