/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.client.model;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.CachedBuilderModel;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.render.helpers.ModularBoxRenderer;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawersextra.StorageDrawersExtra;
import com.jaquadro.minecraft.storagedrawersextra.block.BlockTrimExtra;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumMod;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumVariant;
import com.jaquadro.minecraft.storagedrawersextra.client.model.TextureFace;
import com.jaquadro.minecraft.storagedrawersextra.config.ConfigManagerExt;
import com.jaquadro.minecraft.storagedrawersextra.core.ModBlocks;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ExtraTrimModel
extends ChamModel {
    private static final ItemHandler itemHandler = new ItemHandler();

    public static IBakedModel fromBlock(IBlockState state) {
        if (!(state.func_177230_c() instanceof BlockTrimExtra)) {
            return new ExtraTrimModel(state, false, new Object[]{EnumVariant.DEFAULT});
        }
        BlockTrimExtra block = (BlockTrimExtra)state.func_177230_c();
        return new ExtraTrimModel(state, false, new Object[]{EnumVariant.byGroupMeta(block.getGroup(), (Integer)state.func_177229_b((IProperty)BlockTrimExtra.META))});
    }

    public static IBakedModel fromItem(@Nonnull ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (!(block instanceof BlockTrimExtra)) {
            return new ExtraTrimModel(ModBlocks.extraTrim[0].func_176223_P(), true, new Object[]{EnumVariant.DEFAULT});
        }
        BlockTrimExtra blockTrim = (BlockTrimExtra)block;
        IBlockState state = blockTrim.func_176203_a(stack.func_77960_j());
        return new ExtraTrimModel(state, false, new Object[]{EnumVariant.byGroupMeta(blockTrim.getGroup(), (Integer)state.func_177229_b((IProperty)BlockTrimExtra.META))});
    }

    public ExtraTrimModel(IBlockState state, boolean mergeLayers, Object ... args) {
        super(state, mergeLayers, args);
    }

    protected void renderSolidLayer(ChamRender renderer, IBlockState state, Object ... args) {
        EnumVariant varient = (EnumVariant)((Object)args[0]);
        ModularBoxRenderer boxRenderer = new ModularBoxRenderer(renderer);
        boxRenderer.setColor(ModularBoxRenderer.COLOR_WHITE);
        boxRenderer.setExteriorIcon(Chameleon.instance.iconRegistry.getIcon(TextureFace.SIDE.getLocation(varient)));
        renderer.targetFaceGroup(true);
        boxRenderer.renderSolidBox(null, state, BlockPos.field_177992_a, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        renderer.targetFaceGroup(false);
    }

    public TextureAtlasSprite func_177554_e() {
        IBlockState state = this.getState();
        if (!(state.func_177230_c() instanceof BlockTrimExtra)) {
            return Chameleon.instance.iconRegistry.getIcon(TextureMap.field_174945_f);
        }
        BlockTrimExtra block = (BlockTrimExtra)state.func_177230_c();
        EnumVariant variant = EnumVariant.byGroupMeta(block.getGroup(), (Integer)state.func_177229_b((IProperty)BlockTrimExtra.META));
        return Chameleon.instance.iconRegistry.getIcon(TextureFace.SIDE.getLocation(variant));
    }

    private static class ItemHandler
    extends ItemOverrideList {
        public ItemHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
            return ExtraTrimModel.fromItem(stack);
        }
    }

    private static class Model
    extends ProxyBuilderModel {
        public Model() {
            super(Chameleon.instance.iconRegistry.getIcon(new ResourceLocation("storagedrawers", "blocks/base/base_default")));
        }

        protected IBakedModel buildModel(IBlockState state, IBakedModel parent) {
            try {
                return ExtraTrimModel.fromBlock(state);
            }
            catch (Throwable t) {
                return parent;
            }
        }

        public ItemOverrideList func_188617_f() {
            return itemHandler;
        }

        public List<Object> getKey(IBlockState state) {
            try {
                ArrayList<Object> key = new ArrayList<Object>();
                key.add(state.func_177229_b((IProperty)BlockTrimExtra.META));
                return key;
            }
            catch (Throwable t) {
                return super.getKey(state);
            }
        }
    }

    public static class Register
    extends DefaultRegister<BlockTrimExtra> {
        public Register(BlockTrimExtra block) {
            super((Block)block);
        }

        public List<IBlockState> getBlockStates() {
            ArrayList<IBlockState> states = new ArrayList<IBlockState>();
            for (int i = 0; i < 16; ++i) {
                EnumVariant varient = EnumVariant.byGroupMeta(((BlockTrimExtra)this.getBlock()).getGroup(), i);
                if (varient == EnumVariant.DEFAULT) continue;
                states.add(((BlockTrimExtra)this.getBlock()).func_176223_P().func_177226_a((IProperty)BlockTrimExtra.META, (Comparable)Integer.valueOf(i)));
            }
            return states;
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model(), state);
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new Model();
        }

        public List<ResourceLocation> getTextureResources() {
            ConfigManagerExt configExt = StorageDrawersExtra.config;
            ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
            for (int i = 0; i < 16; ++i) {
                EnumMod mod;
                EnumVariant variant = EnumVariant.byGroupMeta(((BlockTrimExtra)this.getBlock()).getGroup(), i);
                if (variant == EnumVariant.DEFAULT || (mod = variant.getMod()) == null || !mod.isEnabled(configExt.getModToggleState(mod))) continue;
                String path = "blocks/" + variant.getDomain() + "/drawers_" + variant.getPath() + "_side";
                resources.add(new ResourceLocation("storagedrawersextra", path));
            }
            return resources;
        }
    }
}

