/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class BooleanEditor
extends AbstractParameterEditor {
    private ChoiceLabel label;

    private static Boolean parseBoolSafe(String t) {
        if ("*".equals(t)) {
            return null;
        }
        return "true".equals(t);
    }

    @Override
    public void build(Minecraft mc, Gui gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = new Panel(mc, gui).setLayout((Layout)new HorizontalLayout());
        this.label = (ChoiceLabel)new ChoiceLabel(mc, gui).addChoices(new String[]{"*", "true", "false"}).addChoiceEvent((parent, newChoice) -> callback.valueChanged(this.readValue())).setDesiredWidth(60);
        constantPanel.addChild((Widget)this.label);
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_BOOLEAN);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant(BooleanEditor.parseBoolSafe(this.label.getCurrentChoice()));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.label.setChoice("*");
        } else {
            String choice = value.getValue().toString();
            this.label.setChoice(choice);
        }
    }
}

