/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_voidminer.tile;

import com.valkyrieofnight.et.ETMod;
import com.valkyrieofnight.et.api.m_multiblocks.m_components.m_modifiers.ETModifierAttributes;
import com.valkyrieofnight.et.api.m_multiblocks.m_components.m_modifiers.attribute.AttributeForgeEnergyMultiplier;
import com.valkyrieofnight.et.api.m_multiblocks.m_components.m_modifiers.attribute.AttributeSpeed;
import com.valkyrieofnight.et.api.m_multiblocks.m_voidminer.IBLaserLens;
import com.valkyrieofnight.et.base.tile.ETControllerEConsumer;
import com.valkyrieofnight.et.m_multiblocks.m_voidminer.block.BlockLaserCore;
import com.valkyrieofnight.et.m_multiblocks.m_voidminer.network.PacketVoidMinerUpdate;
import com.valkyrieofnight.et.m_multiblocks.m_voidminer.registry.ITargetableRegistry;
import com.valkyrieofnight.vlib.lib.inventory.VLItemHandler;
import com.valkyrieofnight.vlib.lib.multiblock.tilemodule.StructureFormer;
import com.valkyrieofnight.vlib.lib.stack.WeightedStackBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StringUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TileContVoidMinerBase
extends ETControllerEConsumer {
    public static final String T_BASE_DURATION = "t_default_duration";
    public static final String T_MIN_DURATION = "t_min_duration";
    public static final EnumFacing[] ENERGY_DIRECTIONS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.UP};
    private VLItemHandler output;
    private BlockPos drillTip;
    private BlockPos laserLens;
    private List<WeightedStackBase> possibleResults;
    private String target;
    private Random rand;
    private BlockPos voidBlock;
    private float focusBoostModifier = 1.0f;
    private boolean updateClients = false;
    private int voidCheckTick = 0;
    private int ucTick = 0;
    private boolean canMine = false;
    private boolean canSeeVoid = false;
    private float[] lensColor;
    private boolean processing = false;
    public static final AxisAlignedBB INFINITE_EXTENT_AABB = new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public TileContVoidMinerBase(int rfInternal, int totalInternalStacks) {
        super(rfInternal);
        this.output = new VLItemHandler(totalInternalStacks);
        this.possibleResults = new ArrayList<WeightedStackBase>();
        this.rand = new Random();
        this.lensColor = EnumDyeColor.WHITE.func_193349_f();
        this.ic2EU = true;
        this.bcMJ = true;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public String getInfo() {
        return super.getInfo() + " FE/T: " + this.getEnergyCostPerTick() + " ";
    }

    @Override
    public void updateTile() {
        super.updateTile();
        ++this.voidCheckTick;
        if (!this.getTheWorld().field_72995_K) {
            int lowestY;
            ++this.ucTick;
            if (this.drillTip != null && this.laserLens != null) {
                this.canMine = true;
                this.updateClients = true;
                if (this.voidCheckTick % 80 == 0) {
                    this.voidBlock = this.canSeeVoidOrBedrock(this.drillTip);
                    this.canSeeVoid = this.voidBlock != null;
                    this.updateClients = true;
                }
            } else {
                this.canMine = false;
                this.updateClients = true;
                lowestY = 255;
                for (BlockPos blockPos : this.getStructure().getSlavesOfType(BlockLaserCore.class, this.func_174877_v(), this.former.getMBDirectionE())) {
                    if (blockPos.func_177956_o() >= lowestY) continue;
                    lowestY = blockPos.func_177956_o();
                    this.drillTip = blockPos;
                }
                this.laserLens = (BlockPos)this.getStructure().getSlavesOfType(IBLaserLens.class, this.func_174877_v(), this.former.getMBDirectionE()).get(0);
            }
            if (this.updateClients && this.ucTick >= 20) {
                this.ucTick = 0;
                this.updateClients = false;
                ETMod.DISPATCHER.sendToAllAround((IMessage)new PacketVoidMinerUpdate(this), this.getTheWorld().field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 16.0);
            } else {
                if (this.drillTip != null) {
                    if (this.voidCheckTick % 80 == 0) {
                        this.voidBlock = this.canSeeVoidOrBedrock(this.drillTip);
                        this.canSeeVoid = this.voidBlock != null;
                    }
                } else {
                    lowestY = 255;
                    for (BlockPos blockPos : this.getStructure().getSlavesOfType(BlockLaserCore.class, this.func_174877_v(), this.former.getMBDirectionE())) {
                        if (blockPos.func_177956_o() >= lowestY) continue;
                        lowestY = blockPos.func_177956_o();
                        this.drillTip = blockPos;
                    }
                }
                if (this.isFormed()) {
                    this.laserLens = (BlockPos)this.getStructure().getSlavesOfType(IBLaserLens.class, this.func_174877_v(), this.former.getMBDirectionE()).get(0);
                    IBlockState lensBlock = this.getTheWorld().func_180495_p(this.laserLens);
                    if (lensBlock.func_177230_c() instanceof IBLaserLens) {
                        IBLaserLens lens = (IBLaserLens)lensBlock.func_177230_c();
                        this.target = lens.getTargetIdentifier(lensBlock);
                        this.lensColor = lens.getCustomColor(lensBlock);
                    }
                } else {
                    this.processing = false;
                }
            }
            if (this.voidCheckTick > 80000) {
                this.voidCheckTick = 0;
            }
        } else {
            if (this.drillTip != null) {
                if (this.voidCheckTick % 80 == 0) {
                    this.voidBlock = this.canSeeVoidOrBedrock(this.drillTip);
                    this.canSeeVoid = this.voidBlock != null;
                }
            } else {
                int lowestY = 255;
                for (BlockPos blockPos : this.getStructure().getSlavesOfType(BlockLaserCore.class, this.func_174877_v(), this.former.getMBDirectionE())) {
                    if (blockPos.func_177956_o() >= lowestY) continue;
                    lowestY = blockPos.func_177956_o();
                    this.drillTip = blockPos;
                }
            }
            this.laserLens = (BlockPos)this.getStructure().getSlavesOfType(IBLaserLens.class, this.func_174877_v(), this.former.getMBDirectionE()).get(0);
            IBlockState lensBlock = this.getTheWorld().func_180495_p(this.laserLens);
            if (lensBlock.func_177230_c() instanceof IBLaserLens) {
                IBLaserLens lens = (IBLaserLens)lensBlock.func_177230_c();
                this.target = lens.getTargetIdentifier(lensBlock);
                this.lensColor = lens.getCustomColor(lensBlock);
            }
        }
    }

    private BlockPos canSeeVoidOrBedrock(BlockPos pos) {
        for (int yy = pos.func_177956_o() - 1; yy > 0; --yy) {
            BlockPos bts = new BlockPos(pos.func_177958_n(), yy, pos.func_177952_p());
            IBlockState bs = this.getTheWorld().func_180495_p(bts);
            Block blk = bs.func_177230_c();
            if (blk == Blocks.field_150357_h) {
                return bts;
            }
            this.getTheWorld().func_175710_j(pos);
            if (blk == Blocks.field_150350_a || blk.getLightOpacity(bs, (IBlockAccess)this.getTheWorld(), bts) <= 0 || bs.func_185904_a().func_76224_d()) continue;
            return null;
        }
        return new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public boolean getCanMine() {
        return this.canMine;
    }

    public boolean canSeeVoid() {
        return this.canSeeVoid;
    }

    public void packetUpdate(boolean canMine2, boolean canSeeVoid2, boolean isProcessing, int energyLevel) {
        this.canMine = canMine2;
        this.canSeeVoid = canSeeVoid2;
        this.processing = isProcessing;
        this.eBuffer.iSetFEStored(energyLevel);
    }

    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean toItem) {
        super.saveTileData(nbt, toItem);
        nbt.func_74782_a("outputs", (NBTBase)this.output.serializeNBT());
        if (toItem) {
            return nbt;
        }
        nbt.func_74757_a("seevoid", this.canSeeVoid);
        return nbt;
    }

    public void loadTileData(NBTTagCompound nbt, boolean fromItem) {
        super.loadTileData(nbt, fromItem);
        this.output.deserializeNBT(nbt.func_74775_l("outputs"));
        if (fromItem) {
            return;
        }
        this.canSeeVoid = nbt.func_74767_n("seevoid");
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.output;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int modifyDuration(int unmodifiedDuration) {
        if (this.modifierHandler.hasAttribute(AttributeSpeed.SPEED)) {
            return (Integer)ETModifierAttributes.SPEED_1.getAttributeID().getCalculator().calculateModifiedValue(this.modifierHandler.getAttributeFinalValue(ETModifierAttributes.SPEED_1.getAttributeID()), (Object)unmodifiedDuration);
        }
        return unmodifiedDuration;
    }

    @Override
    public boolean canProcess() {
        IBlockState lensBlock;
        Object finalValue = this.modifierHandler.getAttributeFinalValue(ETModifierAttributes.ACCURACY_1.getAttributeID());
        this.focusBoostModifier = ((Float)ETModifierAttributes.ACCURACY_1.getAttributeID().getCalculator().calculateModifiedValue(finalValue != null ? finalValue : Float.valueOf(0.0f), (Object)Float.valueOf(0.0f))).floatValue();
        if (this.possibleResults != null && this.possibleResults.isEmpty() && this.laserLens != null && (lensBlock = this.getTheWorld().func_180495_p(this.laserLens)).func_177230_c() instanceof IBLaserLens) {
            IBLaserLens lens = (IBLaserLens)lensBlock.func_177230_c();
            this.target = lens.getTargetIdentifier(lensBlock);
            this.lensColor = lens.getCustomColor(lensBlock);
            this.possibleResults = !StringUtils.func_151246_b((String)this.target) ? this.getRegistry().getTargetedList(this.target, this.focusBoostModifier) : this.getRegistry().getList();
        }
        if (this.output.getFreeSlots() < 1) {
            this.ejectAll((IItemHandler)this.output);
            return false;
        }
        if (this.eBuffer.getEnergyStored() < this.getEnergyCostPerTick()) {
            return false;
        }
        return this.canMine && this.canSeeVoid ? super.canProcess() : false;
    }

    public int getEnergyCostPerTick() {
        if (this.modifierHandler.hasAttribute(AttributeForgeEnergyMultiplier.FORGE_ENERGY_MULTIPLIER)) {
            int e = (int)((float)this.getEnergyCostPerDuration());
            Object finalValue = this.modifierHandler.getAttributeFinalValue(AttributeForgeEnergyMultiplier.FORGE_ENERGY_MULTIPLIER);
            e = (Integer)AttributeForgeEnergyMultiplier.FORGE_ENERGY_MULTIPLIER.getCalculator().calculateModifiedValue(finalValue != null ? finalValue : Integer.valueOf(0), (Object)e);
            return e / this.getCurrentDuration();
        }
        return this.getEnergyCostPerDuration() / this.getCurrentDuration();
    }

    public void onProcessTick(int ticks) {
        this.eBuffer.iExtractFE(this.getEnergyCostPerTick(), false);
        this.processing = true;
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return 5;
    }

    public void onProcessComplete() {
        if (this.possibleResults == null || this.possibleResults.size() <= 0) {
            return;
        }
        WeightedStackBase result = (WeightedStackBase)WeightedRandom.func_76271_a((Random)this.rand, this.possibleResults);
        ItemStack cloneStack = result.getMainStack().func_77946_l();
        cloneStack.func_190920_e(1);
        ItemHandlerHelper.insertItem((IItemHandler)this.output, (ItemStack)cloneStack, (boolean)false);
        this.ejectAll((IItemHandler)this.output);
    }

    @Override
    public void deformMultiblock() {
        super.deformMultiblock();
        this.possibleResults = new ArrayList<WeightedStackBase>();
    }

    public BlockPos getVoidPos() {
        return this.voidBlock;
    }

    public abstract ITargetableRegistry getRegistry();

    public abstract int getEnergyCostPerDuration();

    public float[] getLaserColor() {
        return this.lensColor;
    }

    public void onProcessStart() {
    }

    public void onIdleTick() {
        this.processing = false;
    }

    @Override
    public EnumFacing[] validEnergyDirections() {
        return ENERGY_DIRECTIONS;
    }

    public StructureFormer getFormer() {
        return this.former;
    }
}

