/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.tanks;

import com.google.common.collect.Sets;
import elec332.core.grid.AbstractGridHandler;
import elec332.core.world.DimensionCoordinate;
import java.util.Set;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.tanks.TankGrid;
import mcjty.deepresonance.tanks.TankTileLink;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TankGridHandler
extends AbstractGridHandler<TankTileLink> {
    private final Set<TankGrid> grids = Sets.newHashSet();

    protected void onObjectRemoved(TankTileLink o, Set<DimensionCoordinate> set) {
        DimensionCoordinate coord = o.getPosition();
        TankGrid grid = o.getGrid();
        if (grid == null) {
            this.removeObject(coord);
            return;
        }
        for (TankTileLink o2 : grid.getConnections()) {
            grid.onRemoved(o2);
            if (set.contains(o2.getPosition()) || o == o2) continue;
            this.add.add(o2.getPosition());
        }
        grid.invalidate();
        this.grids.remove(grid);
    }

    protected void internalAdd(TankTileLink o) {
        DimensionCoordinate coord = o.getPosition();
        BlockPos pos = coord.getPos();
        o.setGrid(this.newGrid(o));
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TankGrid grid;
            TankTileLink ttl = (TankTileLink)((Object)this.getDim(coord).get(pos.func_177972_a(facing)));
            if (ttl == null || (grid = ttl.getGrid()) == null || !o.getGrid().canMerge(grid)) continue;
            o.getGrid().mergeWith(grid);
            grid.invalidate();
            this.grids.remove(grid);
        }
    }

    public void tick() {
        for (TankGrid grid : this.grids) {
            grid.tick();
        }
    }

    public boolean isValidObject(TileEntity tileEntity) {
        return tileEntity instanceof TileTank;
    }

    protected TankTileLink createNewObject(TileEntity tileEntity) {
        return new TankTileLink((TileTank)tileEntity);
    }

    private TankGrid newGrid(TankTileLink tank) {
        TankGrid ret = new TankGrid(tank);
        this.grids.add(ret);
        return ret;
    }
}

