/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.pulser;

import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public class PulserTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable {
    private int pulsePower = 0;

    public PulserTileEntity() {
        super((long)ConfigMachines.pulser.rfMaximum, (long)ConfigMachines.pulser.rfPerTick);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int rfToTransfer;
            long rf;
            if (this.powerLevel > 0 && (rf = this.getStoredPower()) >= (long)(rfToTransfer = ConfigMachines.pulser.rfPerPulse / 15 * this.powerLevel)) {
                this.consumeEnergy(rfToTransfer);
                this.pulsePower += rfToTransfer;
                this.markDirtyQuick();
            }
            if (this.pulsePower >= ConfigMachines.pulser.rfPerPulse) {
                this.pulsePower -= ConfigMachines.pulser.rfPerPulse;
                this.markDirtyQuick();
                int x = this.field_174879_c.func_177958_n();
                int y = this.field_174879_c.func_177956_o();
                int z = this.field_174879_c.func_177952_p();
                int range = 6;
                for (int dx = -range; dx <= range; ++dx) {
                    for (int dy = -range; dy <= range; ++dy) {
                        for (int dz = -range; dz <= range; ++dz) {
                            BlockPos p = new BlockPos(x + dx, y + dy, z + dz);
                            TileEntity te = this.field_145850_b.func_175625_s(p);
                            if (!(te instanceof ResonatingCrystalTileEntity)) continue;
                            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
                            crystal.pulse();
                        }
                    }
                }
            }
        }
    }

    public int getPulsePower() {
        return this.pulsePower;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.pulsePower = tagCompound.func_74762_e("pulsePower");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("pulsePower", this.pulsePower);
    }
}

