/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.TeleportationTools;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.meecreeps.MeeCreeps;
import mcjty.meecreeps.MeeCreepsApi;
import mcjty.meecreeps.actions.ActionOptions;
import mcjty.meecreeps.actions.MeeCreepActionType;
import mcjty.meecreeps.actions.Stage;
import mcjty.meecreeps.actions.workers.WorkerHelper;
import mcjty.meecreeps.api.IActionWorker;
import mcjty.meecreeps.config.Config;
import mcjty.meecreeps.entities.EntityMeeCreeps;
import mcjty.meecreeps.items.CreepCubeItem;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.tuple.Pair;

public class ServerActionManager
extends AbstractWorldData<ServerActionManager> {
    private static final String NAME = "MeeCreepsData";
    private List<ActionOptions> options = new ArrayList<ActionOptions>();
    private Map<Integer, ActionOptions> optionMap = new HashMap<Integer, ActionOptions>();
    private int lastId = 0;
    private Map<Integer, EntityMeeCreeps> entityCache = new HashMap<Integer, EntityMeeCreeps>();
    private static Random random = new Random();

    public ServerActionManager(String name) {
        super(name);
    }

    public void clear() {
        this.options.clear();
        this.optionMap.clear();
        this.lastId = 0;
        this.entityCache.clear();
    }

    public void clearOptions(ICommandSender sender, @Nullable EntityPlayer player) {
        if (player == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Cleared " + this.options.size() + " active operations"));
            this.options.clear();
        } else {
            int cnt = 0;
            ArrayList<ActionOptions> toKeep = new ArrayList<ActionOptions>();
            for (ActionOptions option : this.options) {
                if (!player.func_146103_bH().getId().equals(option.getPlayerId())) {
                    toKeep.add(option);
                    continue;
                }
                ++cnt;
            }
            this.options = toKeep;
            sender.func_145747_a((ITextComponent)new TextComponentString("Cleared " + cnt + " active operations"));
        }
        this.save();
        if (player == null) {
            Integer[] iDs = DimensionManager.getStaticDimensionIDs();
            int cnt = 0;
            for (Integer id : iDs) {
                World w = TeleportationTools.getWorldForDimension((int)id);
                List entities = w.func_175644_a(EntityMeeCreeps.class, input -> true);
                for (EntityMeeCreeps entity : entities) {
                    entity.func_70106_y();
                    ++cnt;
                }
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Additionally killed " + cnt + " MeeCreeps"));
        }
    }

    public void listOptions(ICommandSender sender) {
        for (Map.Entry<Integer, ActionOptions> entry : this.optionMap.entrySet()) {
            ActionOptions options = entry.getValue();
            Stage stage = options.getStage();
            MeeCreepActionType task = options.getTask();
            EntityMeeCreeps entity = this.findMeeCreep(sender.func_130014_f_(), entry.getKey(), options.getDimension());
            String name = entity == null ? "<none>" : entity.func_110124_au().toString();
            sender.func_145747_a((ITextComponent)new TextComponentString("Action " + entry.getKey() + ", Task " + task.getId() + ", Stage " + (Object)((Object)stage) + ", Entity " + name));
        }
    }

    public void updateEntityCache(int actionId, @Nullable EntityMeeCreeps entity) {
        if (entity == null) {
            this.entityCache.remove(actionId);
        } else {
            this.entityCache.put(actionId, entity);
        }
    }

    public EntityMeeCreeps getCachedEntity(int actionId) {
        return this.entityCache.get(actionId);
    }

    public int newId() {
        ++this.lastId;
        this.save();
        return this.lastId;
    }

    public ActionOptions getOptions(int id) {
        return this.optionMap.get(id);
    }

    public int countMeeCreeps(EntityPlayer player) {
        int cnt = 0;
        for (ActionOptions option : this.options) {
            if (!Objects.equals(option.getPlayerId(), player.func_146103_bH().getId())) continue;
            ++cnt;
        }
        return cnt;
    }

    @Nonnull
    public static ServerActionManager getManager() {
        return (ServerActionManager)ServerActionManager.getData(ServerActionManager.class, (String)NAME);
    }

    public int createActionOptions(World world, BlockPos pos, EnumFacing side, @Nullable EntityPlayer player) {
        ArrayList<MeeCreepActionType> types = new ArrayList<MeeCreepActionType>();
        ArrayList<MeeCreepActionType> maybeTypes = new ArrayList<MeeCreepActionType>();
        for (MeeCreepsApi.Factory type : MeeCreeps.api.getFactories()) {
            if (!Config.allowedActions.contains(type.getId())) continue;
            if (type.getFactory().isPossible(world, pos, side)) {
                types.add(new MeeCreepActionType(type.getId()));
                continue;
            }
            if (!type.getFactory().isPossibleSecondary(world, pos, side)) continue;
            maybeTypes.add(new MeeCreepActionType(type.getId()));
        }
        int actionId = this.newId();
        ActionOptions opt = new ActionOptions(types, maybeTypes, pos, side, world.field_73011_w.getDimension(), player == null ? null : player.func_110124_au(), actionId);
        this.options.add(opt);
        this.optionMap.put(actionId, opt);
        this.save();
        return actionId;
    }

    public void performAction(@Nullable EntityPlayerMP player, int id, MeeCreepActionType type, @Nullable String furtherQuestionId) {
        ActionOptions option = this.getOptions(id);
        if (option != null) {
            option.setStage(Stage.WORKING);
            option.setTask(type, furtherQuestionId);
            this.save();
            if (player != null) {
                ItemStack cube = CreepCubeItem.getCube((EntityPlayer)player);
                if (!cube.func_190926_b()) {
                    CreepCubeItem.setLastAction(cube, type, furtherQuestionId);
                }
                if (Config.meeCreepVolume > 0.01f) {
                    String snd = "ok";
                    switch (random.nextInt(2)) {
                        case 0: {
                            snd = "ok";
                            break;
                        }
                        case 1: {
                            snd = "ok2";
                        }
                    }
                    SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("meecreeps", snd));
                    SoundTools.playSound((World)player.func_130014_f_(), (SoundEvent)sound, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)Config.meeCreepVolume, (double)1.0);
                }
            }
        }
    }

    public void cancelAction(EntityPlayerMP player, int id) {
        ActionOptions option = this.getOptions(id);
        if (option != null) {
            option.setStage(Stage.DONE);
            option.setPaused(false);
        }
    }

    public void resumeAction(EntityPlayerMP player, int id) {
        ActionOptions option = this.getOptions(id);
        if (option != null) {
            option.setPaused(false);
        }
    }

    private EntityMeeCreeps findMeeCreep(World world, int actionId, int dimension) {
        EntityMeeCreeps cachedEntity = this.getCachedEntity(actionId);
        if (cachedEntity != null && !cachedEntity.field_70128_L) {
            return cachedEntity;
        }
        List entities = world.func_175644_a(EntityMeeCreeps.class, input -> input != null && input.getActionId() == actionId && !input.field_70128_L);
        if (!entities.isEmpty()) {
            this.updateEntityCache(actionId, (EntityMeeCreeps)entities.get(0));
            return (EntityMeeCreeps)entities.get(0);
        }
        for (WorldServer w : DimensionManager.getWorlds()) {
            entities = w.func_175644_a(EntityMeeCreeps.class, input -> input != null && input.getActionId() == actionId && !input.field_70128_L);
            if (entities.isEmpty()) continue;
            this.updateEntityCache(actionId, (EntityMeeCreeps)entities.get(0));
            return (EntityMeeCreeps)entities.get(0);
        }
        World w = TeleportationTools.getWorldForDimension((int)dimension);
        entities = w.func_175644_a(EntityMeeCreeps.class, input -> input != null && input.getActionId() == actionId && !input.field_70128_L);
        if (!entities.isEmpty()) {
            this.updateEntityCache(actionId, (EntityMeeCreeps)entities.get(0));
            return (EntityMeeCreeps)entities.get(0);
        }
        return null;
    }

    public void tick() {
        this.save();
        ArrayList<ActionOptions> newlist = new ArrayList<ActionOptions>();
        HashMap<Integer, ActionOptions> newmap = new HashMap<Integer, ActionOptions>();
        for (ActionOptions option : this.options) {
            BlockPos meeCreepPos;
            EntityMeeCreeps meeCreep = this.findMeeCreep((World)DimensionManager.getWorld((int)0), option.getActionId(), option.getDimension());
            boolean keep = true;
            World world = meeCreep == null ? DimensionManager.getWorld((int)option.getDimension()) : meeCreep.func_130014_f_();
            BlockPos blockPos = meeCreepPos = meeCreep == null ? option.getTargetPos() : meeCreep.func_180425_c();
            if (world != null && world.func_175667_e(meeCreepPos)) {
                if (!option.tick(world)) {
                    keep = false;
                }
            } else if (option.getStage() != Stage.OPENING_GUI && option.getStage() != Stage.WAITING_FOR_PLAYER_INPUT && option.getStage() != Stage.WAITING_FOR_SPAWN) {
                keep = false;
            }
            if (meeCreep != null) {
                this.stayWithPlayer(option, meeCreep);
            } else if (option.getStage() != Stage.OPENING_GUI && option.getStage() != Stage.WAITING_FOR_PLAYER_INPUT && option.getStage() != Stage.WAITING_FOR_SPAWN) {
                keep = false;
            }
            if (meeCreep == null) {
                int failureCount = option.getFailureCount();
                option.setFailureCount(--failureCount);
                if (failureCount <= 0) {
                    System.out.println("ServerActionManager.tick: FAILURE");
                    keep = false;
                }
            }
            if (keep) {
                newlist.add(option);
                newmap.put(option.getActionId(), option);
                continue;
            }
            if (world == null) continue;
            this.dropRemainingDrops(option, world);
        }
        this.options = newlist;
        this.optionMap = newmap;
    }

    private void dropRemainingDrops(ActionOptions option, World world) {
        List<Pair<BlockPos, ItemStack>> drops = option.getDrops();
        if (!drops.isEmpty()) {
            for (Pair<BlockPos, ItemStack> pair : drops) {
                EntityItem entityItem = new EntityItem(world);
                entityItem.func_92058_a((ItemStack)pair.getValue());
                BlockPos pos = (BlockPos)pair.getKey();
                entityItem.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, 0.0f);
                world.func_72838_d((Entity)entityItem);
            }
        }
    }

    private void stayWithPlayer(ActionOptions option, EntityMeeCreeps meeCreep) {
        IActionWorker worker;
        EntityPlayer player = option.getPlayer();
        if (player != null && meeCreep.getHelper() != null && (worker = meeCreep.getHelper().getWorker()).needsToFollowPlayer() && (this.isDifferentDimension(player, meeCreep) || this.isTooFar(player, meeCreep))) {
            meeCreep.cancelJob();
            BlockPos p = WorkerHelper.findSuitablePositionNearPlayer(meeCreep, player, 4.0);
            meeCreep = (EntityMeeCreeps)TeleportationTools.teleportEntity((Entity)meeCreep, (World)player.func_130014_f_(), (double)((double)p.func_177958_n() + 0.5), (double)p.func_177956_o(), (double)((double)p.func_177952_p() + 0.5), (EnumFacing)EnumFacing.NORTH);
            this.updateEntityCache(option.getActionId(), meeCreep);
            option.setDimension(player.func_130014_f_().field_73011_w.getDimension());
        }
    }

    private boolean isDifferentDimension(EntityPlayer player, EntityMeeCreeps meeCreep) {
        return player.func_130014_f_().field_73011_w.getDimension() != meeCreep.func_130014_f_().field_73011_w.getDimension();
    }

    private boolean isTooFar(EntityPlayer player, EntityMeeCreeps meeCreep) {
        return player.func_174791_d().func_72436_e(meeCreep.func_174791_d()) > 3600.0;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("actions", 10);
        this.options = new ArrayList<ActionOptions>();
        this.optionMap = new HashMap<Integer, ActionOptions>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ActionOptions opt = new ActionOptions(list.func_150305_b(i));
            this.options.add(opt);
            this.optionMap.put(opt.getActionId(), opt);
        }
        this.lastId = nbt.func_74762_e("lastId");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (ActionOptions option : this.options) {
            NBTTagCompound tc = new NBTTagCompound();
            option.writeToNBT(tc);
            list.func_74742_a((NBTBase)tc);
        }
        compound.func_74782_a("actions", (NBTBase)list);
        compound.func_74768_a("lastId", this.lastId);
        return compound;
    }
}

