/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.raoulvdberge.refinedstorage.api.util.IQuantityFormatter;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class QuantityFormatter
implements IQuantityFormatter {
    private DecimalFormat formatterWithUnits = new DecimalFormat("####0.#", DecimalFormatSymbols.getInstance(Locale.US));
    private DecimalFormat formatter = new DecimalFormat("#,###", DecimalFormatSymbols.getInstance(Locale.US));
    private DecimalFormat bucketFormatter = new DecimalFormat("####0.###", DecimalFormatSymbols.getInstance(Locale.US));

    public QuantityFormatter() {
        this.formatterWithUnits.setRoundingMode(RoundingMode.DOWN);
    }

    @Override
    public String formatWithUnits(int qty) {
        if (qty >= 1000000) {
            float qtyShort = (float)qty / 1000000.0f;
            if (qty >= 100000000) {
                qtyShort = Math.round(qtyShort);
            }
            return this.formatterWithUnits.format(qtyShort) + "M";
        }
        if (qty >= 1000) {
            float qtyShort = (float)qty / 1000.0f;
            if (qty >= 100000) {
                qtyShort = Math.round(qtyShort);
            }
            return this.formatterWithUnits.format(qtyShort) + "K";
        }
        return String.valueOf(qty);
    }

    @Override
    public String format(int qty) {
        return this.formatter.format(qty);
    }

    @Override
    public String formatInBucketForm(int qty) {
        return this.bucketFormatter.format((float)qty / 1000.0f) + " B";
    }

    @Override
    public String formatInBucketFormWithOnlyTrailingDigitsIfZero(int qty) {
        float amountRaw = (float)qty / 1000.0f;
        int amount = (int)amountRaw;
        if (amount >= 1) {
            return API.instance().getQuantityFormatter().formatWithUnits(amount);
        }
        return String.format("%.1f", Float.valueOf(amountRaw));
    }
}

