/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeExternalStorage;
import com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage.StorageExternalItem;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerProxy;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeInterface
extends NetworkNode
implements IComparable {
    public static final String ID = "interface";
    private static final String NBT_COMPARE = "Compare";
    private ItemHandlerBase importItems = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private ItemHandlerBase exportFilterItems = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private ItemHandlerBase exportItems = new ItemHandlerBase(9, new ListenerNetworkNode(this), new Predicate[0]);
    private IItemHandler items = new ItemHandlerProxy((IItemHandler)this.importItems, (IItemHandler)this.exportItems);
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 2, 4, 3);
    private int compare = 3;
    private int currentSlot = 0;

    public NetworkNodeInterface(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.interfaceUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public void update() {
        ItemStack slot;
        super.update();
        if (this.network == null || !this.canUpdate()) {
            return;
        }
        if (this.currentSlot >= this.importItems.getSlots()) {
            this.currentSlot = 0;
        }
        if ((slot = this.importItems.getStackInSlot(this.currentSlot)).func_190926_b()) {
            ++this.currentSlot;
        } else if (this.ticks % this.upgrades.getSpeed() == 0) {
            int size = Math.min(slot.func_190916_E(), this.upgrades.getItemInteractCount());
            ItemStack remainder = this.network.insertItemTracked(slot, size);
            if (remainder == null) {
                this.importItems.extractItem(this.currentSlot, size, false);
            } else if (size - remainder.func_190916_E() > 0) {
                this.importItems.extractItem(this.currentSlot, size - remainder.func_190916_E(), false);
                ++this.currentSlot;
            }
        }
        for (int i = 0; i < 9; ++i) {
            int delta;
            ItemStack wanted = this.exportFilterItems.getStackInSlot(i);
            ItemStack got = this.exportItems.getStackInSlot(i);
            if (wanted.func_190926_b()) {
                if (got.func_190926_b()) continue;
                this.exportItems.setStackInSlot(i, StackUtils.nullToEmpty(this.network.insertItemTracked(got, got.func_190916_E())));
                continue;
            }
            if (!got.func_190926_b() && !API.instance().getComparer().isEqual(wanted, got, this.getCompare())) {
                this.exportItems.setStackInSlot(i, StackUtils.nullToEmpty(this.network.insertItemTracked(got, got.func_190916_E())));
                continue;
            }
            int n = delta = got.func_190926_b() ? wanted.func_190916_E() : wanted.func_190916_E() - got.func_190916_E();
            if (delta > 0) {
                boolean actingAsStorage = this.isActingAsStorage();
                ItemStack result = this.network.extractItem(wanted, delta, this.compare, Action.PERFORM, s -> {
                    if (!actingAsStorage) {
                        return true;
                    }
                    return !(s instanceof StorageExternalItem) || !((StorageExternalItem)s).isConnectedToInterface();
                });
                if (result != null) {
                    if (this.exportItems.getStackInSlot(i).func_190926_b()) {
                        this.exportItems.setStackInSlot(i, result);
                    } else {
                        this.exportItems.getStackInSlot(i).func_190917_f(result.func_190916_E());
                    }
                }
                if ((delta -= result == null ? 0 : result.func_190916_E()) <= 0 || !this.upgrades.hasUpgrade(3)) continue;
                this.network.getCraftingManager().request((INetworkNode)this, wanted, delta);
                continue;
            }
            if (delta >= 0) continue;
            ItemStack remainder = this.network.insertItemTracked(got, Math.abs(delta));
            if (remainder == null) {
                this.exportItems.extractItem(i, Math.abs(delta), false);
                continue;
            }
            this.exportItems.extractItem(i, Math.abs(delta) - remainder.func_190916_E(), false);
        }
    }

    private boolean isActingAsStorage() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            INetworkNode facingNode = API.instance().getNetworkNodeManager(this.world).getNode(this.pos.func_177972_a(facing));
            if (!(facingNode instanceof NetworkNodeExternalStorage) || !facingNode.canUpdate() || ((NetworkNodeExternalStorage)facingNode).getDirection() != facing.func_176734_d() || ((NetworkNodeExternalStorage)facingNode).getType() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.importItems, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.exportItems, 2, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 3, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.importItems, 0, tag);
        StackUtils.writeItems((IItemHandler)this.exportItems, 2, tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 3, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.exportFilterItems, 1, tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.exportFilterItems, 1, tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
    }

    public IItemHandler getImportItems() {
        return this.importItems;
    }

    public IItemHandler getExportFilterItems() {
        return this.exportFilterItems;
    }

    public IItemHandler getExportItems() {
        return this.exportItems;
    }

    public IItemHandler getItems() {
        return this.items;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.importItems, this.exportItems, this.upgrades});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }
}

