/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.items.ItemCaps;

import com.direwolf20.buildinggadgets.items.ItemCaps.ItemEnergyForge;
import com.direwolf20.buildinggadgets.tools.GadgetUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class CapabilityProviderEnergy
implements ICapabilityProvider {
    private ItemStack stack;
    private int energyCapacity;

    public CapabilityProviderEnergy(ItemStack stack, int energyCapacity) {
        this.stack = stack;
        this.energyCapacity = energyCapacity;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)new ItemEnergyForge(this.stack, this.energyCapacity)) : null);
    }

    @Nonnull
    public static IEnergyStorage getCap(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energy == null) {
            throw new IllegalArgumentException("CapabilityEnergy could not be retrieved for " + GadgetUtils.getStackErrorSuffix(stack));
        }
        return energy;
    }
}

