/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.items;

import com.direwolf20.buildinggadgets.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.tools.UniqueItem;
import com.direwolf20.buildinggadgets.tools.WorldSave;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface ITemplate {
    @Nullable
    public String getUUID(ItemStack var1);

    public WorldSave getWorldSave(World var1);

    default public void setItemCountMap(ItemStack stack, Map<UniqueItem, Integer> tagMap) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        NBTTagList tagList = GadgetUtils.itemCountToNBT(tagMap);
        tagCompound.func_74782_a("itemcountmap", (NBTBase)tagList);
        stack.func_77982_d(tagCompound);
    }

    @Nonnull
    default public Map<UniqueItem, Integer> getItemCountMap(ItemStack stack) {
        Map<UniqueItem, Integer> tagMap;
        NBTTagCompound tagCompound = stack.func_77978_p();
        Map<UniqueItem, Integer> map = tagMap = tagCompound == null ? null : GadgetUtils.nbtToItemCount((NBTTagList)tagCompound.func_74781_a("itemcountmap"));
        if (tagMap == null) {
            throw new IllegalArgumentException("ITemplate#getItemCountMap faild to retieve tag map from " + GadgetUtils.getStackErrorSuffix(stack));
        }
        return tagMap;
    }

    default public int getCopyCounter(ItemStack stack) {
        return GadgetUtils.getStackTag(stack).func_74762_e("copycounter");
    }

    default public void setCopyCounter(ItemStack stack, int counter) {
        NBTTagCompound tagCompound = GadgetUtils.getStackTag(stack);
        tagCompound.func_74768_a("copycounter", counter);
        stack.func_77982_d(tagCompound);
    }

    default public void incrementCopyCounter(ItemStack stack) {
        NBTTagCompound tagCompound = GadgetUtils.getStackTag(stack);
        tagCompound.func_74768_a("copycounter", tagCompound.func_74762_e("copycounter") + 1);
        stack.func_77982_d(tagCompound);
    }

    default public void setStartPos(ItemStack stack, BlockPos startPos) {
        GadgetUtils.writePOSToNBT(stack, startPos, "startPos");
    }

    @Nullable
    default public BlockPos getStartPos(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "startPos");
    }

    default public void setEndPos(ItemStack stack, BlockPos startPos) {
        GadgetUtils.writePOSToNBT(stack, startPos, "endPos");
    }

    @Nullable
    default public BlockPos getEndPos(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "endPos");
    }
}

