/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.items;

import com.direwolf20.buildinggadgets.Config;
import com.direwolf20.buildinggadgets.ModItems;
import com.direwolf20.buildinggadgets.entities.BlockBuildEntity;
import com.direwolf20.buildinggadgets.items.FakeBuilderWorld;
import com.direwolf20.buildinggadgets.items.GenericGadget;
import com.direwolf20.buildinggadgets.items.ItemCaps.CapabilityProviderEnergy;
import com.direwolf20.buildinggadgets.tools.ExchangingModes;
import com.direwolf20.buildinggadgets.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.tools.VectorTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExchangerTool
extends GenericGadget {
    private static final FakeBuilderWorld fakeWorld = new FakeBuilderWorld();

    public ExchangerTool() {
        this.setRegistryName("exchangertool");
        this.func_77655_b("buildinggadgets.exchangertool");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        if (!Config.poweredByFE) {
            this.func_77656_e(Config.durabilityExchanger);
        }
    }

    public int func_77619_b() {
        return 3;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        if (EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185306_r)) {
            return true;
        }
        return super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185306_r) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private static void setFuzzy(ItemStack stack, boolean fuzzy) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74757_a("fuzzy", fuzzy);
    }

    public static boolean getFuzzy(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        return tagCompound.func_74767_n("fuzzy");
    }

    private static void setToolMode(ItemStack stack, ToolMode mode) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74778_a("mode", mode.name());
        stack.func_77982_d(tagCompound);
    }

    public static ToolMode getToolMode(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        ToolMode mode = ToolMode.Wall;
        if (tagCompound == null) {
            ExchangerTool.setToolMode(stack, mode);
            return mode;
        }
        try {
            mode = ToolMode.valueOf(tagCompound.func_74779_i("mode"));
        }
        catch (Exception e) {
            ExchangerTool.setToolMode(stack, mode);
        }
        return mode;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, world, list, b);
        list.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tooltip.gadget.block", (Object[])new Object[0]) + ": " + GadgetUtils.getToolBlock(stack).func_177230_c().func_149732_F());
        list.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.gadget.mode", (Object[])new Object[0]) + ": " + (Object)((Object)ExchangerTool.getToolMode(stack)));
        list.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.gadget.range", (Object[])new Object[0]) + ": " + GadgetUtils.getToolRange(stack));
        if (Config.poweredByFE) {
            IEnergyStorage energy = CapabilityProviderEnergy.getCap(stack);
            list.add(TextFormatting.WHITE + I18n.func_135052_a((String)"tooltip.gadget.energy", (Object[])new Object[0]) + ": " + GadgetUtils.withSuffix(energy.getEnergyStored()) + "/" + GadgetUtils.withSuffix(energy.getMaxEnergyStored()));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                GadgetUtils.selectBlock(stack, player);
            } else {
                this.exchange(player, stack);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                GadgetUtils.selectBlock(itemstack, player);
            } else {
                this.exchange(player, itemstack);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void toggleMode(EntityPlayer player, ItemStack heldItem) {
        ToolMode mode = ExchangerTool.getToolMode(heldItem);
        mode = mode.next();
        ExchangerTool.setToolMode(heldItem, mode);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.toolmode", new Object[0]).func_150261_e() + ": " + mode.name()), true);
    }

    public void setMode(EntityPlayer player, ItemStack heldItem, int modeInt) {
        ToolMode mode = ToolMode.values()[modeInt];
        ExchangerTool.setToolMode(heldItem, mode);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.toolmode", new Object[0]).func_150261_e() + ": " + mode.name()), true);
    }

    public void toggleFuzzy(EntityPlayer player, ItemStack heldItem) {
        ExchangerTool.setFuzzy(heldItem, !ExchangerTool.getFuzzy(heldItem));
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.fuzzymode", new Object[0]).func_150261_e() + ": " + ExchangerTool.getFuzzy(heldItem)), true);
    }

    public void rangeChange(EntityPlayer player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = ExchangerTool.getToolMode(heldItem) == ToolMode.Checkerboard || range % 2 == 0 ? 1 : 2;
        range = player.func_70093_af() ? (range <= 1 ? Config.maxRange : range - changeAmount) : (range >= Config.maxRange ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_AQUA + new TextComponentTranslation("message.gadget.toolrange", new Object[0]).func_150261_e() + ": " + range), true);
    }

    private boolean exchange(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        List<BlockPos> coords = GadgetUtils.getAnchor(stack);
        if (coords.size() == 0) {
            RayTraceResult lookingAt = VectorTools.getLookingAt(player);
            if (lookingAt == null) {
                return false;
            }
            BlockPos startBlock = lookingAt.func_178782_a();
            EnumFacing sideHit = lookingAt.field_178784_b;
            coords = ExchangingModes.getBuildOrders(world, player, startBlock, sideHit, stack);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
        }
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>(coords);
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof ExchangerTool) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof ExchangerTool)) {
            return false;
        }
        IBlockState blockState = GadgetUtils.getToolBlock(heldItem);
        if (blockState != Blocks.field_150350_a.func_176223_P()) {
            IBlockState state = Blocks.field_150350_a.func_176223_P();
            fakeWorld.setWorldAndState(player.field_70170_p, blockState, coordinates);
            for (BlockPos coordinate : coords) {
                if (fakeWorld.func_175624_G() != WorldType.field_180272_g) {
                    try {
                        state = blockState.func_185899_b((IBlockAccess)fakeWorld, coordinate);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.exchangeBlock(world, player, coordinate, state);
            }
        }
        return true;
    }

    private boolean exchangeBlock(World world, EntityPlayer player, BlockPos pos, IBlockState setBlock) {
        ItemStack tool;
        IBlockState currentBlock = world.func_180495_p(pos);
        boolean useConstructionPaste = false;
        ItemStack itemStack = setBlock.func_177230_c().canSilkHarvest(world, pos, setBlock, player) ? InventoryManipulation.getSilkTouchDrop(setBlock) : setBlock.func_177230_c().getPickBlock(setBlock, null, world, pos, player);
        if (itemStack.func_77973_b().equals(Items.field_190931_a)) {
            itemStack = setBlock.func_177230_c().getPickBlock(setBlock, null, world, pos, player);
        }
        if (!((tool = player.func_184614_ca()).func_77973_b() instanceof ExchangerTool) && !((tool = player.func_184592_cb()).func_77973_b() instanceof ExchangerTool)) {
            return false;
        }
        NonNullList drops = NonNullList.func_191196_a();
        setBlock.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, setBlock, 0);
        int neededItems = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_77973_b().equals(itemStack.func_77973_b())) continue;
            ++neededItems;
        }
        if (neededItems == 0) {
            neededItems = 1;
        }
        if (InventoryManipulation.countItem(itemStack, player) < neededItems) {
            ItemStack constructionPaste = new ItemStack((Item)ModItems.constructionPaste);
            if (InventoryManipulation.countPaste(player) < neededItems) {
                return false;
            }
            itemStack = constructionPaste.func_77946_l();
            useConstructionPaste = true;
        }
        if (!player.func_175142_cm()) {
            return false;
        }
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blockSnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND).isCanceled()) {
            return false;
        }
        BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(world, pos, currentBlock, player);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        if (Config.poweredByFE) {
            if (!GadgetUtils.useEnergy(tool, Config.energyCostExchanger, player)) {
                return false;
            }
        } else if (tool.func_77952_i() >= tool.func_77958_k()) {
            if (tool.func_77984_f()) {
                return false;
            }
        } else {
            tool.func_77972_a(2, (EntityLivingBase)player);
        }
        currentBlock.func_177230_c().func_180657_a(world, player, pos, currentBlock, world.func_175625_s(pos), tool);
        boolean useItemSuccess = useConstructionPaste ? InventoryManipulation.usePaste(player, 1) : InventoryManipulation.useItem(itemStack, player, neededItems);
        if (useItemSuccess) {
            world.func_72838_d((Entity)new BlockBuildEntity(world, pos, (EntityLivingBase)player, setBlock, 3, GadgetUtils.getToolActualBlock(tool), useConstructionPaste));
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public static enum ToolMode {
        Wall,
        VerticalColumn,
        HorizontalColumn,
        Checkerboard;

        private static ToolMode[] vals;

        public ToolMode next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = ToolMode.values();
        }
    }
}

