/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets;

import com.direwolf20.buildinggadgets.BuildingGadgets;
import com.direwolf20.buildinggadgets.CommonProxy;
import com.direwolf20.buildinggadgets.tools.BlacklistBlocks;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class Config {
    private static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_BLACKLIST = "blockBlacklist";
    public static int maxRange = 15;
    public static int energyCostBuilder = 50;
    public static int energyCostExchanger = 100;
    public static int energyCostDestruction = 200;
    public static int energyMax = 500000;
    public static int energyMaxDestruction = 1000000;
    public static boolean poweredByFE = true;
    public static int durabilityBuilder = 500;
    public static int durabilityExchanger = 500;
    public static boolean enablePaste = true;
    public static boolean enableDestructionTool = true;
    public static boolean absoluteCoordDefault = false;
    public static boolean canOverwriteBlocks = true;

    public static void readConfig() {
        Configuration cfg = CommonProxy.config;
        try {
            cfg.load();
            Config.initGeneralConfig(cfg);
        }
        catch (Exception e1) {
            BuildingGadgets.logger.log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    private static void initGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_GENERAL, "General configuration");
        maxRange = cfg.getInt("maxRange", CATEGORY_GENERAL, maxRange, 1, 25, "The max range of the building tool");
        energyCostBuilder = cfg.getInt("energyCostBuilder", CATEGORY_GENERAL, energyCostBuilder, 0, 100000, "The energy cost of the Builder per block");
        energyCostExchanger = cfg.getInt("energyCostExchanger", CATEGORY_GENERAL, energyCostExchanger, 0, 100000, "The energy cost of the Exchanger per block");
        energyCostDestruction = cfg.getInt("energyCostDestruction", CATEGORY_GENERAL, energyCostDestruction, 0, 100000, "The energy cost of the Destruction Gadget per block");
        energyMax = cfg.getInt("energyMax", CATEGORY_GENERAL, energyMax, 0, Integer.MAX_VALUE, "The max energy of the Builder & Exchanger");
        energyMaxDestruction = cfg.getInt("energyMaxDestruction", CATEGORY_GENERAL, energyMaxDestruction, 0, Integer.MAX_VALUE, "The max energy of the Destruction Gadget");
        poweredByFE = cfg.getBoolean("poweredByFE", CATEGORY_GENERAL, poweredByFE, "Set to true for Forge Energy Support, set to False for vanilla Item Damage");
        durabilityBuilder = cfg.getInt("durabilityBuilder", CATEGORY_GENERAL, durabilityBuilder, 0, 100000, "The max durability of the Builder (Ignored if powered by FE)");
        durabilityExchanger = cfg.getInt("durabilityExchanger", CATEGORY_GENERAL, durabilityExchanger, 0, 100000, "The max durability of the Exchanger (Ignored if powered by FE)");
        enablePaste = cfg.getBoolean("enablePaste", CATEGORY_GENERAL, enablePaste, "Set to false to disable the recipe for construction paste.");
        enableDestructionTool = cfg.getBoolean("enableDestructionTool", CATEGORY_GENERAL, enableDestructionTool, "Set to false to disable the destruction tool.");
        absoluteCoordDefault = cfg.getBoolean("absoluteCoordinateModeDefault", CATEGORY_GENERAL, absoluteCoordDefault, "Determines if the Copy/Paste GUI's coordinate mode starts in 'Absolute' mode by default. Set to true for Absolute, set to False for Relative.");
        canOverwriteBlocks = cfg.getBoolean("canOverwriteBlocks", CATEGORY_GENERAL, canOverwriteBlocks, "Whether the Builder / CopyPaste gadgets can overwrite blocks like water, lava, grass, etc (like a player can). False will only allow it to overwrite air blocks.");
        cfg.addCustomCategoryComment(CATEGORY_BLACKLIST, "Blacklist configuration");
        BlacklistBlocks.getBlacklist(cfg);
    }
}

