/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.configurabletypeaction.BlockAction;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.item.ItemBlockMetadata;

public abstract class BlockConfig
extends ExtendedConfig<BlockConfig>
implements IModelProviderConfig {
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation dynamicBlockVariantLocation;
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation dynamicItemVariantLocation;

    public BlockConfig(ModBase mod, boolean enabled, String namedId, String comment, Class<? extends Block> element) {
        super(mod, enabled, namedId, comment, element);
        if (MinecraftHelpers.isClientSide()) {
            this.dynamicBlockVariantLocation = null;
            this.dynamicItemVariantLocation = null;
        }
    }

    @Override
    public String getModelName(ItemStack itemStack) {
        return this.getNamedId();
    }

    @Override
    public String getUnlocalizedName() {
        return "blocks." + this.getMod().getModId() + "." + this.getNamedId();
    }

    @Override
    public String getFullUnlocalizedName() {
        return "tile." + this.getUnlocalizedName() + ".name";
    }

    @Override
    public ConfigurableType getHolderType() {
        return ConfigurableType.BLOCK;
    }

    public Class<? extends Item> getItemBlockClass() {
        return ItemBlockMetadata.class;
    }

    public String getOreDictionaryId() {
        return null;
    }

    public boolean isMultipartEnabled() {
        return false;
    }

    public Block getBlockInstance() {
        return (Block)super.getSubInstance();
    }

    @Nonnull
    public Item getItemInstance() {
        return Item.func_150898_a((Block)this.getBlockInstance());
    }

    public CreativeTabs getTargetTab() {
        return this.getMod().getDefaultCreativeTab();
    }

    @SideOnly(value=Side.CLIENT)
    public Pair<ModelResourceLocation, ModelResourceLocation> registerDynamicModel() {
        String blockName = this.getMod().getModId() + ":" + this.getNamedId();
        final ModelResourceLocation blockLocation = new ModelResourceLocation(blockName, "normal");
        ModelResourceLocation itemLocation = new ModelResourceLocation(blockName, "inventory");
        ModelLoader.setCustomStateMapper((Block)this.getBlockInstance(), (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState blockState) {
                return blockLocation;
            }
        });
        ModelLoader.setCustomModelResourceLocation((Item)this.getItemInstance(), (int)0, (ModelResourceLocation)itemLocation);
        return Pair.of((Object)blockLocation, (Object)itemLocation);
    }

    @Override
    public void onRegistered() {
        super.onRegistered();
        if (MinecraftHelpers.isClientSide() && this.getBlockInstance() instanceof IDynamicModelElement && ((IDynamicModelElement)this.getBlockInstance()).hasDynamicModel()) {
            BlockAction.handleDynamicBlockModel(this);
        }
    }

    @Override
    public IForgeRegistry<?> getRegistry() {
        return ForgeRegistries.BLOCKS;
    }
}

