/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.main;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.api.discovery.ASMDataProcessor;
import elec332.core.api.discovery.IASMDataHelper;
import elec332.core.api.discovery.IASMDataProcessor;
import elec332.core.api.discovery.IAdvancedASMData;
import elec332.core.util.FMLUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import org.objectweb.asm.Type;

public class ElecCoreDiscoverer {
    private static final boolean useCache = false;
    private final Map<LoaderState, List<IASMDataProcessor>> asmLoaderMap = Maps.newHashMap();
    private final List<LoaderState> validStates = ImmutableList.of((Object)LoaderState.CONSTRUCTING, (Object)LoaderState.PREINITIALIZATION, (Object)LoaderState.INITIALIZATION, (Object)LoaderState.POSTINITIALIZATION, (Object)LoaderState.AVAILABLE);
    IASMDataHelper asmDataHelper;

    ElecCoreDiscoverer() {
    }

    void identify(final ASMDataTable dataTable) {
        for (LoaderState state : this.validStates) {
            this.asmLoaderMap.put(state, Lists.newArrayList());
        }
        this.asmDataHelper = new IASMDataHelper(){
            private final Map<String, Set<IAdvancedASMData>> annotationData = Maps.newHashMap();

            @Override
            public ASMDataTable getASMDataTable() {
                return dataTable;
            }

            @Override
            public Set<ASMDataTable.ASMData> getAnnotationList(Class<? extends Annotation> annotationClass) {
                return this.getASMDataTable().getAll(annotationClass.getName());
            }

            @Override
            public Set<IAdvancedASMData> getAdvancedAnnotationList(Class<? extends Annotation> annotationClass) {
                String s = annotationClass.getName();
                return this.createNew(s);
            }

            private Set<IAdvancedASMData> createNew(String s) {
                HashSet ret = Sets.newHashSet();
                for (ASMDataTable.ASMData data : this.getASMDataTable().getAll(s)) {
                    ret.add(new AdvancedASMData(data));
                }
                return ImmutableSet.copyOf((Collection)ret);
            }
        };
        for (ASMDataTable.ASMData data : this.asmDataHelper.getAnnotationList(ASMDataProcessor.class)) {
            Class<?> clazz;
            HashMap dataMap = Maps.newHashMap();
            boolean eb = false;
            try {
                clazz = Class.forName(data.getClassName());
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (clazz == null) continue;
            if (clazz.isAnnotationPresent(ASMDataProcessor.class)) {
                LoaderState[] ls = clazz.getAnnotation(ASMDataProcessor.class).value();
                if (clazz.isEnum()) {
                    for (Object e : clazz.getEnumConstants()) {
                        if (!(e instanceof IASMDataProcessor)) continue;
                        dataMap.put((IASMDataProcessor)e, ls);
                    }
                    eb = true;
                } else {
                    Object obj;
                    try {
                        obj = clazz.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error invocating annotated IASMData class: " + data.getClassName());
                    }
                    if (obj instanceof IASMDataProcessor) {
                        dataMap.put((IASMDataProcessor)obj, ls);
                    }
                }
            }
            if (!eb) {
                for (Field field : clazz.getDeclaredFields()) {
                    Object obj;
                    if (!field.isAnnotationPresent(ASMDataProcessor.class)) continue;
                    try {
                        obj = field.get(null);
                    }
                    catch (Exception e) {
                        continue;
                    }
                    if (!(obj instanceof IASMDataProcessor)) continue;
                    dataMap.put((IASMDataProcessor)obj, field.getAnnotation(ASMDataProcessor.class).value());
                }
            }
            for (Map.Entry entry : dataMap.entrySet()) {
                LoaderState[] hS = (LoaderState[])entry.getValue();
                if (hS == null || hS.length == 0) {
                    throw new IllegalArgumentException("Invalid LoaderState parameters: Null or empty array; For " + data.getClassName());
                }
                for (LoaderState state : hS) {
                    if (!this.validStates.contains(state)) {
                        throw new IllegalArgumentException("Invalid LoaderState parameter: " + state + "; For " + data.getClassName());
                    }
                    this.asmLoaderMap.get(state).add((IASMDataProcessor)entry.getKey());
                }
            }
        }
    }

    void process(LoaderState state) {
        if (this.validStates.contains(state)) {
            List<IASMDataProcessor> dataProcessors = this.asmLoaderMap.get(state);
            for (IASMDataProcessor dataProcessor : dataProcessors) {
                dataProcessor.processASMData(this.asmDataHelper, state);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.asmLoaderMap.remove(state);
    }

    private static class AdvancedASMData
    implements IAdvancedASMData {
        private final ASMDataTable.ASMData asmData;
        private final Map<String, Object> annotationInfo;
        private final boolean isField;
        private final boolean isClass;
        private Class<?> clazz;
        private Field field;
        private String methodName;
        private String methodParams;
        private Method method;
        private Type[] paramTypes;
        private Class[] params;

        private AdvancedASMData(ASMDataTable.ASMData asmData) {
            this.asmData = asmData;
            this.isField = asmData.getObjectName().indexOf(40) == -1;
            this.isClass = asmData.getObjectName().indexOf(46) != -1;
            this.annotationInfo = Collections.unmodifiableMap(asmData.getAnnotationInfo());
        }

        @Override
        public ModCandidate getContainer() {
            return this.asmData.getCandidate();
        }

        @Override
        public String getAnnotationName() {
            return this.asmData.getAnnotationName();
        }

        @Override
        public Map<String, Object> getAnnotationInfo() {
            return this.annotationInfo;
        }

        @Override
        public String getClassName() {
            return this.asmData.getClassName();
        }

        @Override
        public Class<?> loadClass() {
            if (this.clazz != null) {
                return this.clazz;
            }
            try {
                this.clazz = FMLUtil.loadClass(this.asmData.getClassName());
                return this.clazz;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean isField() {
            return this.isField && !this.isClass;
        }

        @Override
        public String getFieldName() {
            if (!this.isField()) {
                throw new IllegalAccessError();
            }
            return this.asmData.getObjectName();
        }

        @Override
        public Field getField() {
            if (this.field != null) {
                return this.field;
            }
            if (!this.isField()) {
                throw new IllegalAccessError();
            }
            try {
                this.field = this.loadClass().getDeclaredField(this.getFieldName());
                this.field.setAccessible(true);
                return this.field;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Class<?> getFieldType() {
            return this.getField().getType();
        }

        @Override
        public boolean isMethod() {
            return !this.isField && !this.isClass;
        }

        @Override
        public String getMethodName() {
            if (!this.isMethod()) {
                throw new IllegalAccessError();
            }
            if (this.methodName == null) {
                String targetName = this.asmData.getObjectName();
                int i = targetName.indexOf(40);
                int i2 = targetName.indexOf(41);
                this.methodName = targetName.substring(0, i);
                if (i2 - i == 1) {
                    this.methodParams = "";
                    this.paramTypes = new Type[0];
                    this.params = new Class[0];
                } else {
                    this.methodParams = targetName.substring(i, i2 + 1);
                }
            }
            return this.methodName;
        }

        @Override
        public Method getMethod() {
            if (this.method != null) {
                return this.method;
            }
            if (!this.isMethod()) {
                throw new IllegalAccessError();
            }
            try {
                this.method = this.loadClass().getMethod(this.getMethodName(), this.getMethodParameters());
                this.method.setAccessible(true);
                return this.method;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Type[] getMethodParameterTypes() {
            if (this.methodParams == null) {
                this.getMethodName();
            }
            if (this.paramTypes != null) {
                return this.paramTypes;
            }
            this.paramTypes = Type.getArgumentTypes((String)this.methodParams);
            return this.paramTypes;
        }

        @Override
        public Class<?>[] getMethodParameters() {
            if (this.params != null) {
                return this.params;
            }
            if (!this.isMethod()) {
                throw new IllegalAccessError();
            }
            Type[] p = this.getMethodParameterTypes();
            Class[] ret = new Class[p.length];
            try {
                for (int i = 0; i < p.length; ++i) {
                    ret[i] = Class.forName(p[i].getClassName());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.params = ret;
            return ret;
        }
    }
}

