/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.api.registry;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import elec332.core.api.registry.IDualObjectRegistry;
import elec332.core.api.registry.ISingleObjectRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class SimpleRegistries {
    private static final ISingleObjectRegistry NULL_SINGLE_REGISTRY = new ISingleObjectRegistry(){

        @Override
        public boolean register(Object o) {
            return false;
        }

        public Set getAllRegisteredObjects() {
            return ImmutableSet.of();
        }
    };
    private static final IDualObjectRegistry NULL_DUAL_REGISTRY = new IDualObjectRegistry(){

        @Override
        public boolean register(Object o, Object o2) {
            return false;
        }

        public Map getAllRegisteredObjects() {
            return ImmutableMap.of();
        }
    };

    public static <T> ISingleObjectRegistry<T> newSingleObjectRegistry() {
        return SimpleRegistries.newSingleObjectRegistry(Predicates.alwaysTrue());
    }

    public static <T> ISingleObjectRegistry<T> newSingleObjectRegistry(Predicate<T> ... predicates) {
        return SimpleRegistries.newSingleObjectRegistry(Predicates.and(predicates));
    }

    public static <T> ISingleObjectRegistry<T> newSingleObjectRegistry(Predicate<T> predicate) {
        return new DefaultSingleObjectRegistry(predicate);
    }

    public static <T> ISingleObjectRegistry<T> emptySingleObjectRegistry() {
        return NULL_SINGLE_REGISTRY;
    }

    public static <T, V> IDualObjectRegistry<T, V> newDualObjectRegistry() {
        return SimpleRegistries.newDualObjectRegistry(Predicates.alwaysTrue());
    }

    public static <T, V> IDualObjectRegistry<T, V> newDualObjectRegistry(Predicate<Pair<T, V>> ... predicates) {
        return SimpleRegistries.newDualObjectRegistry(Predicates.and(predicates));
    }

    public static <T, V> IDualObjectRegistry<T, V> newDualObjectRegistry(Predicate<Pair<T, V>> predicate) {
        return new DefaultDualObjectRegistry(predicate);
    }

    public static <T, V> IDualObjectRegistry<T, V> emptyDualObjectRegistry(Predicate<Pair<T, V>> ... predicates) {
        return NULL_DUAL_REGISTRY;
    }

    private static class DefaultDualObjectRegistry<T, V>
    implements IDualObjectRegistry<T, V> {
        private final Predicate<Pair<T, V>> predicate;
        private final Map<T, V> map = Maps.newHashMap();
        private final Map<T, V> map_ = Collections.unmodifiableMap(this.map);

        private DefaultDualObjectRegistry(Predicate<Pair<T, V>> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean register(T t, V v) {
            if (this.predicate.apply((Object)Pair.of(t, v))) {
                this.map.put(t, v);
                return true;
            }
            return false;
        }

        @Override
        public Map<T, V> getAllRegisteredObjects() {
            return this.map_;
        }
    }

    private static class DefaultSingleObjectRegistry<T>
    implements ISingleObjectRegistry<T> {
        private final Set<T> type = Sets.newHashSet();
        private final Set<T> immutableSet = Collections.unmodifiableSet(this.type);
        private final Predicate<T> predicate;

        private DefaultSingleObjectRegistry(Predicate<T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean register(T t) {
            return this.predicate.apply(t) && this.type.add(t);
        }

        @Override
        public Set<T> getAllRegisteredObjects() {
            return this.immutableSet;
        }
    }
}

