/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTree;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktSyncKnowledge
implements IMessage,
IMessageHandler<PktSyncKnowledge, IMessage> {
    public static final byte STATE_ADD = 0;
    public static final byte STATE_WIPE = 1;
    private byte state;
    public List<String> knownConstellations = new ArrayList<String>();
    public List<String> seenConstellations = new ArrayList<String>();
    public List<ResearchProgression> researchProgression = new ArrayList<ResearchProgression>();
    public List<SextantFinder.TargetObject> usedTargets = new ArrayList<SextantFinder.TargetObject>();
    public IMajorConstellation attunedConstellation = null;
    public int progressTier = 0;
    public boolean wasOnceAttuned = false;
    public Map<AbstractPerk, NBTTagCompound> usedPerks = new HashMap<AbstractPerk, NBTTagCompound>();
    public List<String> freePointTokens = Lists.newArrayList();
    public List<AbstractPerk> sealedPerks = Lists.newArrayList();
    public double perkExp = 0.0;

    public PktSyncKnowledge() {
    }

    public PktSyncKnowledge(byte state) {
        this.state = state;
    }

    public void load(PlayerProgress progress) {
        this.knownConstellations = progress.getKnownConstellations();
        this.seenConstellations = progress.getSeenConstellations();
        this.researchProgression = progress.getResearchProgression();
        this.progressTier = progress.getTierReached().ordinal();
        this.attunedConstellation = progress.getAttunedConstellation();
        this.freePointTokens = progress.getFreePointTokens();
        this.usedPerks = progress.getUnlockedPerkData();
        this.sealedPerks = progress.getSealedPerks();
        this.perkExp = progress.getPerkExp();
        this.wasOnceAttuned = progress.wasOnceAttuned();
        this.usedTargets = progress.getUsedTargets();
    }

    public void fromBytes(ByteBuf buf) {
        int tokenLength;
        int targetLength;
        int sealLength;
        AbstractPerk perk;
        int perkLength;
        byte attunementPresent;
        int rLength;
        String val;
        int i;
        this.state = buf.readByte();
        int cLength = buf.readInt();
        if (cLength != -1) {
            this.knownConstellations = new ArrayList<String>(cLength);
            for (i = 0; i < cLength; ++i) {
                val = ByteBufUtils.readString(buf);
                this.knownConstellations.add(val);
            }
        } else {
            this.knownConstellations = new ArrayList<String>();
        }
        if ((cLength = buf.readInt()) != -1) {
            this.seenConstellations = new ArrayList<String>(cLength);
            for (i = 0; i < cLength; ++i) {
                val = ByteBufUtils.readString(buf);
                this.seenConstellations.add(val);
            }
        } else {
            this.seenConstellations = new ArrayList<String>();
        }
        if ((rLength = buf.readInt()) != -1) {
            this.researchProgression = new ArrayList<ResearchProgression>(rLength);
            for (int i2 = 0; i2 < rLength; ++i2) {
                this.researchProgression.add(ResearchProgression.getById(buf.readInt()));
            }
        } else {
            this.researchProgression = new ArrayList<ResearchProgression>();
        }
        if ((attunementPresent = buf.readByte()) != -1) {
            String attunement = ByteBufUtils.readString(buf);
            IConstellation c = ConstellationRegistry.getConstellationByName(attunement);
            if (c == null || !(c instanceof IMajorConstellation)) {
                AstralSorcery.log.warn("received constellation-attunement progress-packet with unknown constellation: " + attunement);
            } else {
                this.attunedConstellation = (IMajorConstellation)c;
            }
        }
        if ((perkLength = buf.readInt()) != -1) {
            this.usedPerks = new HashMap<AbstractPerk, NBTTagCompound>();
            for (int i3 = 0; i3 < perkLength; ++i3) {
                String key = ByteBufUtils.readString(buf);
                NBTTagCompound tag = ByteBufUtils.readNBTTag(buf);
                perk = PerkTree.PERK_TREE.getPerk(new ResourceLocation(key));
                if (perk == null) continue;
                this.usedPerks.put(perk, tag);
            }
        } else {
            this.usedPerks = new HashMap<AbstractPerk, NBTTagCompound>();
        }
        if ((sealLength = buf.readInt()) != -1) {
            this.sealedPerks = new ArrayList<AbstractPerk>(sealLength);
            for (int i4 = 0; i4 < sealLength; ++i4) {
                String key = ByteBufUtils.readString(buf);
                perk = PerkTree.PERK_TREE.getPerk(new ResourceLocation(key));
                if (perk == null) continue;
                this.sealedPerks.add(perk);
            }
        } else {
            this.sealedPerks = Lists.newArrayList();
        }
        if ((targetLength = buf.readInt()) != -1) {
            this.usedTargets = new ArrayList<SextantFinder.TargetObject>(targetLength);
            for (int i5 = 0; i5 < targetLength; ++i5) {
                String str = ByteBufUtils.readString(buf);
                SextantFinder.TargetObject to = SextantFinder.getByName(str);
                if (to == null) continue;
                this.usedTargets.add(to);
            }
        } else {
            this.usedTargets = Lists.newArrayList();
        }
        if ((tokenLength = buf.readInt()) != -1) {
            this.freePointTokens = new ArrayList<String>(tokenLength);
            for (int i6 = 0; i6 < tokenLength; ++i6) {
                this.freePointTokens.add(ByteBufUtils.readString(buf));
            }
        } else {
            this.freePointTokens = Lists.newArrayList();
        }
        this.wasOnceAttuned = buf.readBoolean();
        this.progressTier = buf.readInt();
        this.perkExp = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.state);
        if (this.knownConstellations != null) {
            buf.writeInt(this.knownConstellations.size());
            for (String string : this.knownConstellations) {
                ByteBufUtils.writeString(buf, string);
            }
        } else {
            buf.writeInt(-1);
        }
        if (this.seenConstellations != null) {
            buf.writeInt(this.seenConstellations.size());
            for (String string : this.seenConstellations) {
                ByteBufUtils.writeString(buf, string);
            }
        } else {
            buf.writeInt(-1);
        }
        if (this.researchProgression != null) {
            buf.writeInt(this.researchProgression.size());
            for (ResearchProgression researchProgression : this.researchProgression) {
                buf.writeInt(researchProgression.getProgressId());
            }
        } else {
            buf.writeInt(-1);
        }
        if (this.attunedConstellation != null) {
            buf.writeByte(1);
            ByteBufUtils.writeString(buf, this.attunedConstellation.getUnlocalizedName());
        } else {
            buf.writeByte(-1);
        }
        if (this.usedPerks != null) {
            buf.writeInt(this.usedPerks.size());
            for (Map.Entry entry : this.usedPerks.entrySet()) {
                ByteBufUtils.writeString(buf, ((AbstractPerk)entry.getKey()).getRegistryName().toString());
                ByteBufUtils.writeNBTTag(buf, (NBTTagCompound)entry.getValue());
            }
        } else {
            buf.writeInt(-1);
        }
        if (this.sealedPerks != null) {
            buf.writeInt(this.sealedPerks.size());
            for (AbstractPerk abstractPerk : this.sealedPerks) {
                ByteBufUtils.writeString(buf, abstractPerk.getRegistryName().toString());
            }
        } else {
            buf.writeInt(-1);
        }
        if (this.usedTargets != null) {
            buf.writeInt(this.usedTargets.size());
            for (SextantFinder.TargetObject targetObject : this.usedTargets) {
                ByteBufUtils.writeString(buf, targetObject.getRegistryName());
            }
        } else {
            buf.writeInt(-1);
        }
        if (this.freePointTokens != null) {
            buf.writeInt(this.freePointTokens.size());
            for (String string : this.freePointTokens) {
                ByteBufUtils.writeString(buf, string);
            }
        } else {
            buf.writeInt(-1);
        }
        buf.writeBoolean(this.wasOnceAttuned);
        buf.writeInt(this.progressTier);
        buf.writeDouble(this.perkExp);
    }

    public PktSyncKnowledge onMessage(PktSyncKnowledge message, MessageContext ctx) {
        this.receiveMessageClient(message, ctx);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void receiveMessageClient(PktSyncKnowledge message, MessageContext ctx) {
        AstralSorcery.proxy.scheduleClientside(() -> {
            switch (message.state) {
                case 0: {
                    ResearchManager.recieveProgressFromServer(message);
                    break;
                }
                case 1: {
                    ResearchManager.clientProgress = new PlayerProgress();
                }
            }
        });
    }
}

