/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item;

import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ItemBlockStorage
extends Item {
    public static void tryStoreBlock(ItemStack storeIn, World w, BlockPos pos) {
        if (w.func_175625_s(pos) != null) {
            return;
        }
        IBlockState stateToStore = w.func_180495_p(pos);
        if (Item.func_150898_a((Block)stateToStore.func_177230_c()) == Items.field_190931_a) {
            return;
        }
        if (stateToStore.func_185887_b(w, pos) == -1.0f) {
            return;
        }
        NBTTagCompound stateTag = NBTHelper.getBlockStateNBTTag(stateToStore);
        if (stateTag == null) {
            return;
        }
        NBTTagCompound cmp = NBTHelper.getPersistentData(storeIn);
        NBTTagList list = cmp.func_150295_c("storedStates", 10);
        list.func_74742_a((NBTBase)stateTag);
        cmp.func_74782_a("storedStates", (NBTBase)list);
    }

    @Nonnull
    public static Map<IBlockState, ItemStack> getMappedStoredStates(ItemStack referenceContainer) {
        NonNullList<IBlockState> blockStates = ItemBlockStorage.getStoredStates(referenceContainer);
        LinkedHashMap<IBlockState, ItemStack> map = new LinkedHashMap<IBlockState, ItemStack>();
        for (IBlockState state : blockStates) {
            ItemStack stack = ItemUtils.createBlockStack(state);
            if (stack.func_190926_b()) continue;
            map.put(state, stack);
        }
        return map;
    }

    @Nonnull
    private static NonNullList<IBlockState> getStoredStates(ItemStack referenceContainer) {
        NonNullList states = NonNullList.func_191196_a();
        if (!referenceContainer.func_190926_b() && referenceContainer.func_77973_b() instanceof ItemBlockStorage) {
            NBTTagCompound persistent = NBTHelper.getPersistentData(referenceContainer);
            NBTTagList stored = persistent.func_150295_c("storedStates", 10);
            for (int i = 0; i < stored.func_74745_c(); ++i) {
                IBlockState state = NBTHelper.getBlockStateFromTag(stored.func_150305_b(i));
                if (state == null) continue;
                states.add((Object)state);
            }
        }
        return states;
    }

    public static void tryClearContainerFor(EntityPlayer player) {
        ItemStack used = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!used.func_190926_b() && used.func_77973_b() instanceof ItemBlockStorage) {
            NBTHelper.getPersistentData(used).func_82580_o("storedStates");
        }
    }

    protected static Random getPreviewRandomFromWorld(World world) {
        long tempSeed = 7508891506429673237L;
        return new Random(tempSeed *= world.func_82737_E() / 40L << 8);
    }
}

