/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data;

import hellfirepvp.astralsorcery.common.data.AbstractData;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopEffectHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class DataTimeFreezeEffects
extends AbstractData {
    private Map<Integer, List<TimeStopEffectHelper>> clientActiveFreezeZones = new HashMap<Integer, List<TimeStopEffectHelper>>();
    private Map<Integer, List<TimeStopEffectHelper>> serverActiveFreezeZones = new HashMap<Integer, List<TimeStopEffectHelper>>();
    private List<ServerSyncAction> scheduledServerSyncChanges = new LinkedList<ServerSyncAction>();
    private NBTTagCompound clientReadBuffer = new NBTTagCompound();

    public void server_addNewEffect(int dimId, TimeStopEffectHelper effectHelper) {
        List zones = this.serverActiveFreezeZones.computeIfAbsent(dimId, id -> new LinkedList());
        zones.add(effectHelper);
        this.scheduledServerSyncChanges.add(new ServerSyncAction(ServerSyncAction.ActionType.ADD, dimId, effectHelper));
        this.markDirty();
    }

    public void server_removeEffect(int dimId, TimeStopEffectHelper effectHelper) {
        if (this.serverActiveFreezeZones.containsKey(dimId)) {
            this.serverActiveFreezeZones.get(dimId).remove(effectHelper);
        }
        this.scheduledServerSyncChanges.add(new ServerSyncAction(ServerSyncAction.ActionType.REMOVE, dimId, effectHelper));
        this.markDirty();
    }

    public void server_clearEffects(int dimId) {
        this.serverActiveFreezeZones.remove(dimId);
        this.scheduledServerSyncChanges.add(new ServerSyncAction(ServerSyncAction.ActionType.CLEAR, dimId, null));
        this.markDirty();
    }

    @Nullable
    public List<TimeStopEffectHelper> client_getTimeStopEffects(World world) {
        if (world.field_73011_w == null) {
            return null;
        }
        return this.client_getTimeStopEffects(world.field_73011_w.getDimension());
    }

    @Nullable
    public List<TimeStopEffectHelper> client_getTimeStopEffects(int dimensionId) {
        return this.clientActiveFreezeZones.get(dimensionId);
    }

    private void client_applyChange(ServerSyncAction action) {
        switch (action.type) {
            case ADD: {
                List zones = this.clientActiveFreezeZones.computeIfAbsent(action.dimId, id -> new LinkedList());
                zones.add(action.involvedEffect);
                break;
            }
            case REMOVE: {
                if (!this.clientActiveFreezeZones.containsKey(action.dimId)) break;
                this.clientActiveFreezeZones.get(action.dimId).remove(action.involvedEffect);
                break;
            }
            case CLEAR: {
                this.clientActiveFreezeZones.remove(action.dimId);
            }
        }
    }

    @Override
    public void writeAllDataToPacket(NBTTagCompound compound) {
        compound.func_74757_a("sync_all", true);
        NBTTagCompound dims = new NBTTagCompound();
        for (int dimId : this.serverActiveFreezeZones.keySet()) {
            NBTTagList cmp = new NBTTagList();
            for (TimeStopEffectHelper effect : this.serverActiveFreezeZones.get(dimId)) {
                cmp.func_74742_a((NBTBase)effect.serializeNBT());
            }
            dims.func_74782_a(String.valueOf(dimId), (NBTBase)cmp);
        }
        compound.func_74782_a("dimensions", (NBTBase)dims);
    }

    @Override
    public void writeToPacket(NBTTagCompound compound) {
        compound.func_74757_a("sync_all", false);
        NBTTagList changes = new NBTTagList();
        for (ServerSyncAction action : this.scheduledServerSyncChanges) {
            changes.func_74742_a((NBTBase)action.serializeNBT());
        }
        compound.func_74782_a("changes", (NBTBase)changes);
        this.scheduledServerSyncChanges.clear();
    }

    @Override
    public void readRawFromPacket(NBTTagCompound compound) {
        this.clientReadBuffer = compound;
    }

    @Override
    public void handleIncomingData(AbstractData serverData) {
        if (!(serverData instanceof DataTimeFreezeEffects)) {
            return;
        }
        NBTTagCompound buf = ((DataTimeFreezeEffects)serverData).clientReadBuffer;
        if (buf.func_74767_n("sync_all")) {
            NBTTagCompound dims = buf.func_74775_l("dimensions");
            for (String key : dims.func_150296_c()) {
                int dimId;
                try {
                    dimId = Integer.parseInt(key);
                }
                catch (Exception exc) {
                    continue;
                }
                LinkedList<TimeStopEffectHelper> effectList = new LinkedList<TimeStopEffectHelper>();
                this.clientActiveFreezeZones.put(dimId, effectList);
                NBTTagList effects = dims.func_150295_c(key, 10);
                for (int i = 0; i < effects.func_74745_c(); ++i) {
                    NBTTagCompound cmp = effects.func_150305_b(i);
                    effectList.add(TimeStopEffectHelper.deserializeNBT(cmp));
                }
            }
        } else {
            NBTTagList changes = buf.func_150295_c("changes", 10);
            for (int i = 0; i < changes.func_74745_c(); ++i) {
                ServerSyncAction action = ServerSyncAction.deserializeNBT(changes.func_150305_b(i));
                this.client_applyChange(action);
            }
        }
    }

    public void clientClean() {
        this.clientActiveFreezeZones = new HashMap<Integer, List<TimeStopEffectHelper>>();
        this.clientReadBuffer = null;
    }

    public static class Provider
    extends AbstractData.ProviderAutoAllocate<DataTimeFreezeEffects> {
        public Provider(String key) {
            super(key);
        }

        @Override
        public DataTimeFreezeEffects provideNewInstance(Side side) {
            return new DataTimeFreezeEffects();
        }
    }

    public static class ServerSyncAction {
        private final ActionType type;
        private final int dimId;
        private TimeStopEffectHelper involvedEffect;

        private ServerSyncAction(ActionType type, int dimId, TimeStopEffectHelper involvedEffect) {
            this.type = type;
            this.dimId = dimId;
            this.involvedEffect = involvedEffect;
        }

        private NBTTagCompound serializeNBT() {
            NBTTagCompound out = new NBTTagCompound();
            out.func_74768_a("type", this.type.ordinal());
            out.func_74768_a("dimId", this.dimId);
            switch (this.type) {
                case ADD: 
                case REMOVE: {
                    out.func_74782_a("effectTag", (NBTBase)this.involvedEffect.serializeNBT());
                }
            }
            return out;
        }

        private static ServerSyncAction deserializeNBT(NBTTagCompound cmp) {
            ActionType type = ActionType.values()[MathHelper.func_76125_a((int)cmp.func_74762_e("type"), (int)0, (int)(ActionType.values().length - 1))];
            int dimId = cmp.func_74762_e("dimId");
            TimeStopEffectHelper helper = null;
            switch (type) {
                case ADD: 
                case REMOVE: {
                    helper = TimeStopEffectHelper.deserializeNBT(cmp.func_74775_l("effectTag"));
                }
            }
            return new ServerSyncAction(type, dimId, helper);
        }

        public static enum ActionType {
            ADD,
            REMOVE,
            CLEAR;

        }
    }
}

