/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.constellation.perk.PlayerAttributeMap;
import hellfirepvp.astralsorcery.common.constellation.perk.attribute.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.nodes.AttributeConverterPerk;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;

public class AttributeModifierPerk
extends AttributeConverterPerk {
    private List<PerkAttributeModifier> typeModifierList = Lists.newArrayList();

    public AttributeModifierPerk(String name, int x, int y) {
        super(name, x, y);
    }

    public <T> T addModifier(float modifier, PerkAttributeModifier.Mode mode, String type) {
        this.typeModifierList.add(new PerkAttributeModifier(type, mode, modifier));
        return (T)this;
    }

    @Override
    public void applyPerkLogic(EntityPlayer player, Side side) {
        super.applyPerkLogic(player, side);
        PlayerAttributeMap attr = PerkAttributeHelper.getOrCreateMap(player, side);
        for (PerkAttributeModifier modifier : this.typeModifierList) {
            ArrayList modify = Lists.newArrayList();
            modify.add(modifier);
            modify.addAll(attr.gainModifiers(modifier, this));
            for (PerkAttributeModifier mod : modify) {
                if (attr.applyModifier(player, (mod = attr.convertModifier(mod, this)).getAttributeType(), mod)) continue;
            }
        }
    }

    @Override
    public void removePerkLogic(EntityPlayer player, Side side) {
        super.removePerkLogic(player, side);
        PlayerAttributeMap attr = PerkAttributeHelper.getOrCreateMap(player, side);
        for (PerkAttributeModifier modifier : this.typeModifierList) {
            ArrayList modify = Lists.newArrayList();
            modify.add(modifier);
            modify.addAll(attr.gainModifiers(modifier, this));
            for (PerkAttributeModifier mod : modify) {
                if (attr.removeModifier(player, (mod = attr.convertModifier(mod, this)).getAttributeType(), mod)) continue;
            }
        }
    }
}

