/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree;

import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.resource.SpriteQuery;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.tree.PerkTreePoint;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PerkTreeMajor
extends PerkTreePoint {
    private SpriteQuery queryCstUnAllocated;
    private SpriteQuery queryCstAllocated;
    private SpriteQuery queryCstUnlockable;

    public PerkTreeMajor(AbstractPerk perk, Point offset) {
        super(perk, offset);
        this.setRenderSize((int)((double)this.getRenderSize() * 1.4));
    }

    public void setQueryMajorPerkHaloUnAllocated(SpriteQuery queryCstUnAllocated) {
        this.queryCstUnAllocated = queryCstUnAllocated;
    }

    public void setQueryMajorPerkHaloUnlockable(SpriteQuery queryCstUnlockable) {
        this.queryCstUnlockable = queryCstUnlockable;
    }

    public void setQueryMajorPerkHaloAllocated(SpriteQuery queryCstAllocated) {
        this.queryCstAllocated = queryCstAllocated;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Rectangle renderAtCurrentPos(PerkTreePoint.AllocationStatus status, long spriteOffsetTick, float pTicks) {
        SpriteSheetResource tex;
        if (this.queryCstUnAllocated == null) {
            this.queryCstUnAllocated = SpriteQuery.of(SpriteLibrary.spriteHalo4);
        }
        if (this.queryCstAllocated == null) {
            this.queryCstAllocated = SpriteQuery.of(SpriteLibrary.spriteHalo5);
        }
        if (this.queryCstUnlockable == null) {
            this.queryCstUnlockable = SpriteQuery.of(SpriteLibrary.spriteHalo6);
        }
        int haloRenderSize = (int)((double)this.getRenderSize() * 0.8);
        switch (status) {
            case UNALLOCATED: {
                tex = this.queryCstUnAllocated.resolveSprite();
                break;
            }
            case ALLOCATED: {
                haloRenderSize = (int)((double)haloRenderSize * 1.3);
                tex = this.queryCstAllocated.resolveSprite();
                break;
            }
            case UNLOCKABLE: {
                tex = this.queryCstUnlockable.resolveSprite();
                break;
            }
            default: {
                tex = this.queryCstUnAllocated.resolveSprite();
            }
        }
        if (tex == null) {
            return null;
        }
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Vector3 starVec = new Vector3(-haloRenderSize, -haloRenderSize, 0);
        tex.bindTexture();
        double uLength = tex.getULength();
        double vLength = tex.getVLength();
        Tuple<Double, Double> frameUV = tex.getUVOffset(spriteOffsetTick);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(haloRenderSize * u * 2).addY(haloRenderSize * v * 2);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((Double)frameUV.key + uLength * (double)u, (Double)frameUV.value + vLength * (double)v).func_181675_d();
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        return super.renderAtCurrentPos(status, spriteOffsetTick, pTicks);
    }
}

