/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.cmd;

import hellfirepvp.astralsorcery.common.auxiliary.StarlightNetworkDebugHandler;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.PerkLevelManager;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.lib.MultiBlockArrays;
import hellfirepvp.astralsorcery.common.registry.RegistryStructures;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.struct.BlockArray;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandAstralSorcery
extends CommandBase {
    private List<String> cmdAliases = new ArrayList<String>();
    private static final String[] COMMANDS = new String[]{"help", "constellations", "research", "progress", "reset", "exp", "attune", "build", "maximize", "slnetwork"};

    public CommandAstralSorcery() {
        this.cmdAliases.add("astralsorcery");
        this.cmdAliases.add("as");
    }

    public String func_71517_b() {
        return "astralsorcery";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/astralsorcery <action> [player] [arguments...]";
    }

    public List<String> func_71514_a() {
        return this.cmdAliases;
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 1;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandAstralSorcery.func_71530_a((String[])args, (String[])COMMANDS);
        }
        String identifier = args[0].toLowerCase();
        if (identifier.equals("build")) {
            void var10_19;
            Field[] fields = MultiBlockArrays.class.getDeclaredFields();
            ArrayList<String> names = new ArrayList<String>(fields.length);
            Field[] fieldArray = fields;
            int n = fieldArray.length;
            boolean bl = false;
            while (var10_19 < n) {
                Field f = fieldArray[var10_19];
                if (!f.isAnnotationPresent(MultiBlockArrays.PasteBlacklist.class)) {
                    names.add(f.getName());
                }
                ++var10_19;
            }
            return CommandAstralSorcery.func_175762_a((String[])args, names);
        }
        if (args.length == 2) {
            return CommandAstralSorcery.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 3) {
            switch (identifier) {
                case "constellations": {
                    ArrayList<String> names = new ArrayList<String>();
                    for (IConstellation iConstellation : ConstellationRegistry.getAllConstellations()) {
                        names.add(iConstellation.getUnlocalizedName());
                    }
                    names.add("all");
                    return CommandAstralSorcery.func_175762_a((String[])args, names);
                }
                case "research": {
                    ArrayList<String> names = new ArrayList<String>();
                    for (ResearchProgression r : ResearchProgression.values()) {
                        names.add(r.name());
                    }
                    names.add("all");
                    return CommandAstralSorcery.func_175762_a((String[])args, names);
                }
                case "progress": {
                    return CommandAstralSorcery.func_71530_a((String[])args, (String[])new String[]{"all"});
                }
                case "attune": {
                    ArrayList<String> names = new ArrayList<String>();
                    for (IConstellation iConstellation : ConstellationRegistry.getMajorConstellations()) {
                        names.add(iConstellation.getUnlocalizedName());
                    }
                    return CommandAstralSorcery.func_175762_a((String[])args, names);
                }
            }
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cNot enough arguments."));
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cType \"/astralsorcery help\" for help"));
            return;
        }
        if (args.length >= 1) {
            String identifier = args[0];
            if (identifier.equalsIgnoreCase("help")) {
                this.displayHelp(sender);
            } else if (identifier.equalsIgnoreCase("slnetwork")) {
                this.tryEnterSLNetworkDebugMode(server, sender);
            } else if (identifier.equalsIgnoreCase("constellation") || identifier.equalsIgnoreCase("constellations")) {
                if (args.length == 1) {
                    this.listConstellations(sender);
                } else if (args.length == 2) {
                    this.listConstellations(server, sender, args[1]);
                } else if (args.length == 3) {
                    this.addConstellations(server, sender, args[1], args[2]);
                }
            } else if (identifier.equalsIgnoreCase("research") || identifier.equalsIgnoreCase("res")) {
                if (args.length == 3) {
                    this.modifyResearch(server, sender, args[1], args[2]);
                }
            } else if (identifier.equalsIgnoreCase("progress") || identifier.equalsIgnoreCase("prog")) {
                if (args.length <= 2) {
                    this.showProgress(server, sender, args.length == 1 ? sender.func_70005_c_() : args[1]);
                } else if (args.length == 3) {
                    this.modifyProgress(server, sender, args[1], args[2]);
                }
            } else if (identifier.equalsIgnoreCase("reset")) {
                if (args.length == 2) {
                    this.wipeProgression(server, sender, args[1]);
                }
            } else if (identifier.equalsIgnoreCase("charge") || identifier.equalsIgnoreCase("exp")) {
                if (args.length == 3) {
                    this.setExp(server, sender, args[1], args[2]);
                }
            } else if (identifier.equalsIgnoreCase("attune")) {
                if (args.length == 3) {
                    this.attuneToConstellation(server, sender, args[1], args[2]);
                }
            } else if (identifier.equalsIgnoreCase("build")) {
                if (args.length == 2) {
                    this.buildStruct(server, sender, args[1]);
                } else {
                    RegistryStructures.init();
                }
            } else if (identifier.equalsIgnoreCase("maximize") && args.length == 2) {
                this.maxAll(server, sender, args[1]);
            }
        }
    }

    private void tryEnterSLNetworkDebugMode(MinecraftServer server, ICommandSender sender) {
        if (!(sender instanceof EntityPlayer)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("This command can only be executed by a player!"));
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (!player.func_184812_l_()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cYou have to be in creative-mode to use the debug mode!"));
            return;
        }
        StarlightNetworkDebugHandler.INSTANCE.awaitDebugInteraction(player, () -> sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cStarlight network debug-rightclick timed out.")));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aRightclick a block within 20 seconds to collect information about its starlight network activity."));
    }

    private void attuneToConstellation(MinecraftServer server, ICommandSender sender, String otherPlayerName, String majorConstellationStr) {
        Tuple<EntityPlayerMP, PlayerProgress> prTuple = this.tryGetProgressWithMessages(server, sender, otherPlayerName);
        if (prTuple == null) {
            return;
        }
        PlayerProgress progress = (PlayerProgress)prTuple.value;
        EntityPlayer other = (EntityPlayer)prTuple.key;
        IMajorConstellation cst = ConstellationRegistry.getMajorConstellationByName(majorConstellationStr);
        if (cst == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Given constellation name is not a (major) constellation! " + majorConstellationStr));
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cSee '/astralsorcery constellations' to get all constellations!"));
            return;
        }
        if (ResearchManager.setAttunedConstellation(other, cst)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aSuccess! Player has been attuned to " + cst.getUnlocalizedName()));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Player specified doesn't seem to have a research progress!"));
        }
    }

    private void setExp(MinecraftServer server, ICommandSender sender, String otherPlayerName, String strCharge) {
        int chargeToSet;
        Tuple<EntityPlayerMP, PlayerProgress> prTuple = this.tryGetProgressWithMessages(server, sender, otherPlayerName);
        if (prTuple == null) {
            return;
        }
        PlayerProgress progress = (PlayerProgress)prTuple.value;
        EntityPlayer other = (EntityPlayer)prTuple.key;
        try {
            chargeToSet = Integer.parseInt(strCharge);
        }
        catch (NumberFormatException exc) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Alignment charge to set should be a number! " + strCharge));
            return;
        }
        if (ResearchManager.setExp(other, chargeToSet)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aSuccess! Player charge has been set to " + chargeToSet));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Player specified doesn't seem to have a research progress!"));
        }
    }

    private void modifyResearch(MinecraftServer server, ICommandSender sender, String otherPlayerName, String research) {
        Tuple<EntityPlayerMP, PlayerProgress> prTuple = this.tryGetProgressWithMessages(server, sender, otherPlayerName);
        if (prTuple == null) {
            return;
        }
        PlayerProgress progress = (PlayerProgress)prTuple.value;
        EntityPlayerMP other = (EntityPlayerMP)prTuple.key;
        if (research.equalsIgnoreCase("all")) {
            ResearchManager.forceMaximizeResearch((EntityPlayer)other);
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aSuccess!"));
        } else {
            ResearchProgression pr = ResearchProgression.getByEnumName(research);
            if (pr == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Unknown research: " + research));
            } else {
                ResearchManager.unsafeForceGiveResearch(other, pr);
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aSuccess!"));
            }
        }
    }

    private void maxAll(MinecraftServer server, ICommandSender sender, String otherPlayerName) {
        Tuple<EntityPlayerMP, PlayerProgress> prTuple = this.tryGetProgressWithMessages(server, sender, otherPlayerName);
        if (prTuple == null) {
            return;
        }
        PlayerProgress progress = (PlayerProgress)prTuple.value;
        EntityPlayer other = (EntityPlayer)prTuple.key;
        ResearchManager.forceMaximizeAll(other);
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aSuccess!"));
    }

    private void buildStruct(MinecraftServer server, ICommandSender sender, String name) {
        BlockPos hit;
        EntityPlayerMP exec;
        BlockArray array;
        try {
            Field f = MultiBlockArrays.class.getDeclaredField(name);
            f.setAccessible(true);
            if (f.isAnnotationPresent(MultiBlockArrays.PasteBlacklist.class)) {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! You may not paste " + name + ", as it may be unstable or may have other unwanted effects!"));
                return;
            }
            array = (BlockArray)f.get(null);
        }
        catch (NoSuchFieldException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! " + name + " doesn't exist!"));
            return;
        }
        catch (IllegalAccessException e) {
            return;
        }
        try {
            exec = CommandAstralSorcery.func_71521_c((ICommandSender)sender);
        }
        catch (PlayerNotFoundException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Couldn't find you as player in the world!"));
            return;
        }
        RayTraceResult res = MiscUtils.rayTraceLook((EntityLivingBase)exec, 60.0);
        if (res == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Couldn't find the block you're looking at?"));
            return;
        }
        switch (res.field_72313_a) {
            case BLOCK: {
                hit = res.func_178782_a();
                break;
            }
            default: {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Couldn't find the block you're looking at?"));
                return;
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aStarting to build " + name + " at " + hit.toString() + "!"));
        array.placeInWorld(exec.field_70170_p, hit);
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aBuilt " + name + "!"));
    }

    private void wipeProgression(MinecraftServer server, ICommandSender sender, String otherPlayerName) {
        Tuple<EntityPlayerMP, PlayerProgress> prTuple = this.tryGetProgressWithMessages(server, sender, otherPlayerName);
        if (prTuple == null) {
            return;
        }
        PlayerProgress progress = (PlayerProgress)prTuple.value;
        EntityPlayerMP other = (EntityPlayerMP)prTuple.key;
        ResearchManager.wipeKnowledge(other);
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aWiped " + otherPlayerName + "'s data!"));
    }

    private void modifyProgress(MinecraftServer server, ICommandSender sender, String otherPlayerName, String argument) {
        Tuple<EntityPlayerMP, PlayerProgress> prTuple = this.tryGetProgressWithMessages(server, sender, otherPlayerName);
        if (prTuple == null) {
            return;
        }
        PlayerProgress progress = (PlayerProgress)prTuple.value;
        EntityPlayer other = (EntityPlayer)prTuple.key;
        if (argument.equalsIgnoreCase("all")) {
            if (!ResearchManager.maximizeTier(other)) {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Could not load Progress for (" + otherPlayerName + ") !"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aMaximized ProgressionTier for " + otherPlayerName + " !"));
            }
        }
    }

    private void showProgress(MinecraftServer server, ICommandSender sender, String otherPlayerName) {
        Tuple<EntityPlayerMP, PlayerProgress> prTuple = this.tryGetProgressWithMessages(server, sender, otherPlayerName);
        if (prTuple == null) {
            return;
        }
        PlayerProgress progress = (PlayerProgress)prTuple.value;
        EntityPlayer other = (EntityPlayer)prTuple.key;
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aPlayer " + otherPlayerName + "'s research Data:"));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aProgression tier: " + progress.getTierReached().name()));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aAttuned to: " + (progress.getAttunedConstellation() == null ? "<none>" : progress.getAttunedConstellation().getUnlocalizedName())));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aPerk-Exp: " + progress.getPerkExp() + " - As level: " + PerkLevelManager.INSTANCE.getLevel(MathHelper.func_76128_c((double)progress.getPerkExp()))));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aUnlocked perks + unlock-level:"));
        for (AbstractPerk perk : progress.getAppliedPerks()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77" + perk.getUnlocalizedName() + ".name"));
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aUnlocked research groups:"));
        StringBuilder sb = new StringBuilder();
        for (ResearchProgression rp : progress.getResearchProgression()) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(rp.name());
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77" + sb.toString()));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aUnlocked constellations:"));
        sb = new StringBuilder();
        for (String str : progress.getKnownConstellations()) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(str);
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77" + sb.toString()));
    }

    private void addConstellations(MinecraftServer server, ICommandSender sender, String otherPlayerName, String argument) {
        Tuple<EntityPlayerMP, PlayerProgress> prTuple = this.tryGetProgressWithMessages(server, sender, otherPlayerName);
        if (prTuple == null) {
            return;
        }
        PlayerProgress progress = (PlayerProgress)prTuple.value;
        EntityPlayer other = (EntityPlayer)prTuple.key;
        if (argument.equals("all")) {
            List<IConstellation> constellations = ConstellationRegistry.getAllConstellations();
            if (!ResearchManager.discoverConstellations(constellations, other)) {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Could not load Progress for (" + otherPlayerName + ") !"));
                return;
            }
            other.func_145747_a((ITextComponent)new TextComponentString("\u00a7aDiscovered all Constellations!"));
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aSuccess!"));
        } else {
            IConstellation c = ConstellationRegistry.getConstellationByName(argument);
            if (c == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cUnknown constellation: " + argument));
                return;
            }
            if (!ResearchManager.discoverConstellation(c, other)) {
                sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cFailed! Could not load Progress for (" + otherPlayerName + ") !"));
                return;
            }
            other.func_145747_a((ITextComponent)new TextComponentString("\u00a7aDiscovered constellation " + c.getUnlocalizedName() + "!"));
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7aSuccess!"));
        }
    }

    private void listConstellations(MinecraftServer server, ICommandSender sender, String otherPlayerName) {
        Tuple<EntityPlayerMP, PlayerProgress> prTuple = this.tryGetProgressWithMessages(server, sender, otherPlayerName);
        if (prTuple == null) {
            return;
        }
        PlayerProgress progress = (PlayerProgress)prTuple.value;
        EntityPlayer other = (EntityPlayer)prTuple.key;
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7c" + otherPlayerName + " has discovered the constellations:"));
        if (progress.getKnownConstellations().size() == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7c NONE"));
            return;
        }
        for (String s : progress.getKnownConstellations()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77" + s));
        }
    }

    private Tuple<EntityPlayerMP, PlayerProgress> tryGetProgressWithMessages(MinecraftServer server, ICommandSender sender, String otherPlayerName) {
        EntityPlayerMP other;
        try {
            other = CommandAstralSorcery.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)otherPlayerName);
        }
        catch (CommandException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cSpecified player (" + otherPlayerName + ") is not online!"));
            return null;
        }
        PlayerProgress progress = ResearchManager.getProgress(other);
        if (progress == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cCould not get Progress for (" + otherPlayerName + ") !"));
            return null;
        }
        return new Tuple<EntityPlayerMP, PlayerProgress>(other, progress);
    }

    private void displayHelp(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery constellation\u00a77 - lists all constellations"));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery constellation [playerName]\u00a77 - lists all discovered constellations of the specified player if he/she is online"));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery constellation [playerName] <cName;all>\u00a77 - player specified discovers the specified constellation or all or resets all"));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery progress [playerName]\u00a77 - displays progress information about the player (Enter no player to view your own)"));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery progress [playerName] <all>\u00a77 - maximize progression"));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery research [playerName] <research;all>\u00a77 - set/add Research"));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery reset [playerName]\u00a77 - resets all progression-related data for that player."));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery build [structure]\u00a77 - builds the named structure wherever the player is looking at."));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery maximize [playerName]\u00a77 - unlocks everything for that player."));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery exp [playerName] <exp>\u00a77 - sets the perk exp for a player"));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery attune [playerName] <majorConstellationName>\u00a77 - sets the attunement constellation for a player"));
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7a/astralsorcery slnetwork\u00a77 - Executing player enters StarlightNetwork debug mode for the next block"));
    }

    private void listConstellations(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cMajor \"Bright\" Constellations:"));
        for (IMajorConstellation iMajorConstellation : ConstellationRegistry.getMajorConstellations()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77" + iMajorConstellation.getUnlocalizedName()));
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7Weak \"Dim\" Constellations:"));
        for (IWeakConstellation iWeakConstellation : ConstellationRegistry.getWeakConstellations()) {
            if (iWeakConstellation instanceof IMajorConstellation) continue;
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77" + iWeakConstellation.getUnlocalizedName()));
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("\u00a7cMinor \"Faint\" Constellations:"));
        for (IMinorConstellation iMinorConstellation : ConstellationRegistry.getMinorConstellations()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("\u00a77" + iMinorConstellation.getUnlocalizedName()));
        }
    }
}

