/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.fluid;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.block.BlockCustomSandOre;
import hellfirepvp.astralsorcery.common.block.BlockInfusedWood;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidBlockLiquidStarlight
extends BlockFluidClassic {
    public FluidBlockLiquidStarlight() {
        super(BlocksAS.fluidLiquidStarlight, (Material)new MaterialLiquid(MapColor.field_151680_x));
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Integer level = (Integer)stateIn.func_177229_b((IProperty)LEVEL);
        double percHeight = 1.0 - ((double)level.intValue() + 1.0) / 8.0;
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        p.offset(0.0, percHeight, 0.0);
        p.offset((double)rand.nextFloat() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, (double)rand.nextFloat() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1));
        p.scale(0.2f).gravity(0.006).setColor(BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor);
        if (rand.nextInt(3) == 0) {
            p = EffectHelper.genericFlareParticle((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            p.offset(0.0, percHeight, 0.0);
            p.offset((double)rand.nextFloat() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, (double)rand.nextFloat() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1));
            p.scale(0.2f).gravity(0.006).setColor(BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor);
        }
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block neighborBlock, @Nonnull BlockPos neighbourPos) {
        super.func_189540_a(state, world, pos, neighborBlock, neighbourPos);
        this.interactWithAdjacent(world, pos, state);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.interactWithAdjacent(world, pos, state);
    }

    private void interactWithAdjacent(World world, BlockPos pos, IBlockState thisState) {
        boolean shouldCreateBlock = false;
        boolean isCold = true;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            IBlockState offset;
            if (side == EnumFacing.DOWN || !(offset = world.func_180495_p(pos.func_177972_a(side))).func_185904_a().func_76224_d() || offset.func_177230_c() instanceof FluidBlockLiquidStarlight || !(offset.func_177230_c() instanceof BlockFluidBase) && !(offset.func_177230_c() instanceof BlockLiquid)) continue;
            int temp = offset.func_177230_c() instanceof BlockFluidBase ? BlockFluidBase.getTemperature((IBlockAccess)world, (BlockPos)pos.func_177972_a(side)) : (offset.func_185904_a() == Material.field_151587_i ? FluidRegistry.LAVA.getTemperature() : (offset.func_185904_a() == Material.field_151586_h ? FluidRegistry.WATER.getTemperature() : 100));
            isCold = temp <= 300;
            shouldCreateBlock = true;
            break;
        }
        if (shouldCreateBlock) {
            if (isCold) {
                if (Config.liquidStarlightIce) {
                    world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                } else {
                    world.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
                }
            } else if (Config.liquidStarlightSand) {
                if (Config.liquidStarlightAquamarine && world.field_73012_v.nextInt(900) == 0) {
                    world.func_175656_a(pos, BlocksAS.customSandOre.func_176223_P().func_177226_a(BlockCustomSandOre.ORE_TYPE, (Comparable)((Object)BlockCustomSandOre.OreType.AQUAMARINE)));
                } else {
                    world.func_175656_a(pos, Blocks.field_150354_m.func_176223_P());
                }
            } else {
                world.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
            }
            world.func_184133_a(null, pos, SoundEvents.field_187835_fT, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int i = 0; i < 10; ++i) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_185904_a().func_76224_d() && super.displaceIfPossible(world, pos);
    }

    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        AxisAlignedBB entityBox;
        AxisAlignedBB box = iblockstate.func_185900_c(world, blockpos).func_186670_a(blockpos);
        return box.func_72326_a(entityBox = entity.func_174813_aQ()) && materialIn.func_76224_d();
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        ItemStack contained;
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityPlayer) {
            ((EntityPlayer)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0, true, true));
        } else if (entityIn instanceof EntityItem && !(contained = ((EntityItem)entityIn).func_92059_d()).func_190926_b()) {
            if (entityIn.func_130014_f_().field_72995_K) {
                return;
            }
            if (Config.liquidStarlightInfusedWood) {
                this.interactInfusedWood(contained, entityIn);
            }
        }
    }

    private void interactInfusedWood(ItemStack contained, Entity entityIn) {
        if (ItemUtils.hasOreName(contained, "logWood")) {
            if ((contained = ItemUtils.copyStackWithSize(contained, contained.func_190916_E() - 1)).func_190926_b()) {
                entityIn.func_70106_y();
            } else {
                ((EntityItem)entityIn).func_92058_a(contained);
            }
            ItemUtils.dropItemNaturally(entityIn.func_130014_f_(), entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, BlockInfusedWood.WoodType.RAW.asStack());
        }
    }
}

